/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.ui.editor.IServerEditorPartInput;
import org.eclipse.wst.server.ui.editor.ServerEditorPart;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorPartInput;
import org.eclipse.wst.server.ui.internal.editor.ServerResourceCommandManager;
import org.jboss.ide.eclipse.as.core.server.IServerWorkingCopyProvider;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentPageUIController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.tools.as.core.internal.modules.DeploymentPreferences;
import org.jboss.tools.as.core.internal.modules.DeploymentPreferencesLoader;

public class DeploymentPage
extends ServerEditorPart
implements IServerWorkingCopyProvider {
    protected ServerResourceCommandManager commandManager;
    protected DeploymentPreferences preferences;
    protected ServerAttributeHelper helper;
    private IServerListener listener;
    private IDeploymentPageUIController controller;

    private IDeploymentPageUIController getController() {
        IControllableServerBehavior beh;
        if (this.controller == null && (beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)this.getServer())) != null) {
            try {
                this.controller = (IDeploymentPageUIController)beh.getController("deploymentPage");
            }
            catch (CoreException ce) {
                JBossServerUIPlugin.log(ce.getStatus());
            }
        }
        return this.controller;
    }

    public ServerAttributeHelper getHelper() {
        if (this.helper == null) {
            this.helper = new ServerAttributeHelper(this.getServer().getOriginal(), this.getServer());
        } else {
            String officialTS;
            String helperTS = this.helper.getWorkingCopy().getAttribute("timestamp", null);
            if (!helperTS.equals(officialTS = this.getServer().getAttribute("timestamp", null))) {
                this.helper = new ServerAttributeHelper(this.getServer().getOriginal(), this.getServer());
            }
        }
        return this.helper;
    }

    public FormToolkit getFormToolkit(Composite parent) {
        return this.getFormToolkit(parent.getDisplay());
    }

    public IServerWorkingCopy getServer() {
        return this.server;
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (input instanceof IServerEditorPartInput) {
            IServerEditorPartInput sepi = (IServerEditorPartInput)input;
            this.server = sepi.getServer();
            this.commandManager = ((ServerEditorPartInput)sepi).getServerCommandManager();
            this.readOnly = sepi.isServerReadOnly();
            this.helper = new ServerAttributeHelper(this.server.getOriginal(), this.server);
            this.listener = new UnitedServerListener(){

                public void serverChanged(ServerEvent event) {
                    DeploymentPage.this.fireServerChanged(event);
                }
            };
            this.server.getOriginal().addServerListener(this.listener);
            this.fireServerChanged(null);
        }
        this.getController().init(site, input, this);
    }

    public void dispose() {
        super.dispose();
        this.server.getOriginal().removeServerListener(this.listener);
        this.getController().dispose();
    }

    public void execute(IUndoableOperation command) {
        this.commandManager.execute(command);
    }

    public void setFocus() {
    }

    public void doSave(IProgressMonitor monitor) {
        this.getController().doSave(monitor);
    }

    private void fireServerChanged(ServerEvent event) {
        this.getController().serverChanged(event);
    }

    public void createPartControl(Composite parent) {
        this.preferences = DeploymentPreferencesLoader.loadPreferencesFromServer((IServerAttributes)this.getServer());
        this.getController().createPartControl(parent);
    }

    public DeploymentPreferences getPreferences() {
        return this.preferences;
    }
}

