/*
 * Decompiled with CFR 0.152.
 */
package tern.server.nodejs.process;

import java.io.File;
import java.io.IOException;
import java.util.List;
import tern.server.nodejs.process.INodejsProcessListener;
import tern.server.nodejs.process.NodejsProcess;
import tern.server.nodejs.process.NodejsProcessAdapter;

public class PrintNodejsProcessListener
extends NodejsProcessAdapter {
    private static final INodejsProcessListener INSTANCE = new PrintNodejsProcessListener();

    public static INodejsProcessListener getInstance() {
        return INSTANCE;
    }

    @Override
    public void onCreate(NodejsProcess process, List<String> commands, File projectDir) {
        StringBuilder commandsAsString = new StringBuilder();
        int i = 0;
        for (String cmd : commands) {
            if (i > 0) {
                commandsAsString.append(" ");
            }
            if (i <= 1) {
                commandsAsString.append("\"");
            }
            commandsAsString.append(cmd);
            if (i <= 1) {
                commandsAsString.append("\"");
            }
            ++i;
        }
        System.out.println("Nodejs Commnand: " + commandsAsString.toString());
        String path = projectDir.getPath();
        try {
            path = projectDir.getCanonicalPath();
        }
        catch (IOException iOException) {}
        System.out.println("Project dir: " + path);
    }

    @Override
    public void onStart(NodejsProcess process) {
        System.out.println("Server started at " + process.getPort() + " on " + process.getElapsedStartTime());
    }

    @Override
    public void onData(NodejsProcess process, String line) {
        System.out.println(line);
    }

    @Override
    public void onStop(NodejsProcess process) {
        System.out.println("Server stopped at " + process.getPort());
    }

    @Override
    public void onError(NodejsProcess process, String line) {
        System.err.println(line);
    }
}

