/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.jface;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import tern.server.protocol.completions.TernCompletionItem;

public class TernImagesRegistry {
    public static final String IMG_FN = "tern.eclipse.jface.IMG_FN";
    public static final String IMG_ARRAY = "tern.eclipse.jface.IMG_ARRAY";
    public static final String IMG_NUMBER = "tern.eclipse.jface.IMG_NUMBER";
    public static final String IMG_STRING = "tern.eclipse.jface.IMG_STRING";
    public static final String IMG_BOOLEAN = "tern.eclipse.jface.IMG_BOOLEAN";
    public static final String IMG_UNKNOWN = "tern.eclipse.jface.IMG_UNKNOWN";

    static {
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        imageRegistry.put(IMG_FN, ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"images/fn.gif"));
        imageRegistry.put(IMG_ARRAY, ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"images/array.gif"));
        imageRegistry.put(IMG_NUMBER, ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"images/number.gif"));
        imageRegistry.put(IMG_STRING, ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"images/string.gif"));
        imageRegistry.put(IMG_BOOLEAN, ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"images/boolean.gif"));
        imageRegistry.put(IMG_UNKNOWN, ImageDescriptor.createFromFile(TernImagesRegistry.class, (String)"images/unknown.gif"));
    }

    public static Image getImage(String key) {
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        return imageRegistry.get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        return imageRegistry.getDescriptor(key);
    }

    private static String getImageKey(TernCompletionItem item, boolean returnNullIfUnknown) {
        if (item.isFunction()) {
            return IMG_FN;
        }
        if (item.isArray()) {
            return IMG_ARRAY;
        }
        String jsType = item.getJsType();
        if (jsType != null) {
            if ("string".equals(jsType)) {
                return IMG_STRING;
            }
            if ("number".equals(jsType)) {
                return IMG_NUMBER;
            }
            if ("bool".equals(jsType)) {
                return IMG_BOOLEAN;
            }
        }
        if (returnNullIfUnknown) {
            return null;
        }
        return IMG_UNKNOWN;
    }

    public static Image getImage(TernCompletionItem item, boolean returnNullIfUnknown) {
        String key = TernImagesRegistry.getImageKey(item, returnNullIfUnknown);
        return key != null ? TernImagesRegistry.getImage(key) : null;
    }

    public static ImageDescriptor getImageDescriptor(TernCompletionItem item, boolean returnNullIfUnknown) {
        String key = TernImagesRegistry.getImageKey(item, returnNullIfUnknown);
        return key != null ? TernImagesRegistry.getImageDescriptor(key) : null;
    }
}

