/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core.scriptpath;

import com.eclipsesource.json.JsonArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import tern.TernFileManager;
import tern.eclipse.ide.core.scriptpath.IScriptResource;
import tern.eclipse.ide.core.scriptpath.ITernScriptPath;
import tern.eclipse.ide.core.utils.FileUtils;
import tern.eclipse.ide.internal.core.Trace;
import tern.eclipse.ide.internal.core.scriptpath.AbstractTernScriptPath;
import tern.eclipse.ide.internal.core.scriptpath.JSFileScriptResource;
import tern.server.protocol.TernDoc;

public class FolderScriptPath
extends AbstractTernScriptPath {
    private final Collection<IScriptResource> scripts = new ArrayList<IScriptResource>();
    private IResourceVisitor scriptResourcesVisitor;

    public FolderScriptPath(IFolder folder, String external) {
        super((IResource)folder, ITernScriptPath.ScriptPathsType.FOLDER, external);
    }

    @Override
    public Collection<IScriptResource> getScriptResources() {
        this.scripts.clear();
        IFolder folder = (IFolder)this.getResource();
        try {
            folder.accept(this.getScriptResourcesVisitor());
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "Error while retrieving script resources from the folder script path " + folder.getName(), e);
        }
        return this.scripts;
    }

    @Override
    public void updateFiles(TernFileManager ternFileManager, TernDoc doc, JsonArray names) throws IOException {
        IContainer container = (IContainer)this.getResource();
        try {
            container.accept(this.newUpdateFilesVisitor(ternFileManager, doc, names));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public IResourceVisitor getScriptResourcesVisitor() {
        if (this.scriptResourcesVisitor == null) {
            this.scriptResourcesVisitor = new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    switch (resource.getType()) {
                        case 1: {
                            IFile file = (IFile)resource;
                            if (FileUtils.isJSFile((IResource)file)) {
                                FolderScriptPath.this.scripts.add(new JSFileScriptResource(file));
                                return true;
                            }
                            return false;
                        }
                        case 2: 
                        case 4: {
                            return true;
                        }
                    }
                    return false;
                }
            };
        }
        return this.scriptResourcesVisitor;
    }

    public IResourceVisitor newUpdateFilesVisitor(final TernFileManager ternFileManager, final TernDoc doc, final JsonArray names) {
        return new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                switch (resource.getType()) {
                    case 1: {
                        IFile file = (IFile)resource;
                        if (FileUtils.isJSFile((IResource)file)) {
                            try {
                                ternFileManager.updateFile((Object)file, doc, names);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            return true;
                        }
                        return false;
                    }
                    case 2: 
                    case 4: {
                        return true;
                    }
                }
                return false;
            }
        };
    }
}

