/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.validation;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.wst.validation.internal.MarkerManager;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.util.EclipseJavaUtil;
import org.jboss.tools.common.util.EclipseUIUtil;
import org.jboss.tools.common.validation.ContextValidationHelper;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IValidationErrorManager;
import org.jboss.tools.common.validation.ProblemMessage;
import org.jboss.tools.common.validation.ValidationMessages;
import org.jboss.tools.common.validation.WarningNameManager;

public abstract class ValidationErrorManager
implements IValidationErrorManager {
    public static String DEFAULT_VALIDATION_MARKER = "org.eclipse.wst.validation.problemmarker";
    static String VALIDATION_MARKER_OWNER = "owner";
    static String VALIDATION_MARKER_GROUP = "groupName";
    public static final String PREFERENCE_KEY_ATTRIBUTE_NAME = "preference_key";
    public static final String PREFERENCE_PAGE_ID_NAME = "preference_page_id";
    public static final String MESSAGE_ID_ATTRIBUTE_NAME = "Message_id";
    protected IStatus OK_STATUS = new Status(0, "org.eclipse.wst.validation", 0, "OK", null);
    protected IValidator validationManager;
    protected ContextValidationHelper coreHelper;
    protected IReporter reporter;
    protected IProject validatingProject;
    protected String markerId;
    protected IProjectValidationContext validationContext;
    protected TextFileDocumentProvider documentProvider;
    protected IDocument document;
    protected Set<IFile> dirtyFiles;
    private static final String SUPPRESS_WARNINGS_ANNOTATION_SHORT = "SuppressWarnings";
    private static final String SUPPRESS_WARNINGS_ANNOTATION_FULL = "java.lang.SuppressWarnings";
    private static final String ALL_WARNINGS = "all";
    private Set<MarkerID> markers = new HashSet<MarkerID>();
    protected String problemType = null;

    @Override
    public void init(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext validationContext, IValidator manager, IReporter reporter) {
        this.init(project, validationHelper, validationContext, manager, reporter, false);
    }

    @Override
    public void init(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext validationContext, IValidator manager, IReporter reporter, boolean asYouTypeValidation) {
        this.cleanSavedMarkers();
        this.setProject(project);
        this.setCoreHelper(validationHelper);
        this.setValidationManager(manager);
        this.setReporter(reporter);
        this.setValidationContext(validationContext);
        this.setMarkerId("markedKbResource");
        this.dirtyFiles = asYouTypeValidation ? new HashSet() : EclipseUIUtil.getDirtyFiles();
    }

    protected boolean shouldBeValidated(IFile file) {
        return file.isAccessible() && !this.dirtyFiles.contains(file);
    }

    public void setValidationManager(IValidator validationManager) {
        this.validationManager = validationManager;
    }

    public void setCoreHelper(ContextValidationHelper coreHelper) {
        this.coreHelper = coreHelper;
    }

    public void setReporter(IReporter reporter) {
        this.reporter = reporter;
    }

    public void setProject(IProject rootProject) {
        this.validatingProject = rootProject;
    }

    public void setMarkerId(String markerId) {
        this.markerId = markerId;
    }

    public void setValidationContext(IProjectValidationContext validationContext) {
        this.validationContext = validationContext;
    }

    @Override
    public IMarker addError(String message, String preferenceKey, String[] messageArguments, ITextSourceReference location, IResource target) {
        IResource newTarget = target;
        if (location.getResource() != null && location.getResource().exists() && !location.getResource().equals((Object)target)) {
            newTarget = location.getResource();
        }
        IMarker marker = null;
        int severity = this.getSeverity(preferenceKey, newTarget);
        try {
            if (!(severity == -1 || severity == 2 && ValidationErrorManager.hasSuppressWarningsAnnotation(preferenceKey, location))) {
                marker = this.addError(message, preferenceKey, messageArguments, 0, location.getLength(), location.getStartPosition(), newTarget, severity);
            }
        }
        catch (JavaModelException e) {
            CommonPlugin.getDefault().logError((Throwable)e);
        }
        return marker;
    }

    private static boolean hasSuppressWarningsAnnotation(String preferenceKey, IJavaElement element) throws JavaModelException {
        String[] names = WarningNameManager.getInstance().getWarningNames(preferenceKey);
        if (names == null || names.length == 1) {
            return false;
        }
        Set annotations = EclipseJavaUtil.findAnnotationsByShortName((IJavaElement)element, (String)SUPPRESS_WARNINGS_ANNOTATION_SHORT, (boolean)true);
        if (annotations != null) {
            for (IAnnotation annotation : annotations) {
                IMemberValuePair[] pairs = annotation.getMemberValuePairs();
                if (pairs.length != 1) continue;
                Object v = pairs[0].getValue();
                Object[] warnings = null;
                if (v instanceof Object[]) {
                    warnings = (Object[])v;
                } else {
                    if (!(v instanceof String)) continue;
                    warnings = new String[]{v.toString()};
                }
                Object[] objectArray = warnings;
                int n = warnings.length;
                int n2 = 0;
                while (n2 < n) {
                    Object warning = objectArray[n2];
                    if (warning != null) {
                        boolean found = false;
                        if (warning.equals(ALL_WARNINGS)) {
                            found = true;
                        } else {
                            String[] stringArray = names;
                            int n3 = names.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String name = stringArray[n4];
                                if (warning.equals(name)) {
                                    found = true;
                                    break;
                                }
                                ++n4;
                            }
                        }
                        if (found && EclipseJavaUtil.checkAnnotationByFulltName((IAnnotation)annotation, (String)SUPPRESS_WARNINGS_ANNOTATION_FULL)) {
                            return true;
                        }
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    protected static boolean hasSuppressWarningsAnnotation(String preferenceKey, ITextSourceReference location) throws JavaModelException {
        boolean result = false;
        if (location instanceof IJavaSourceReference) {
            IJavaElement element = ((IJavaSourceReference)location).getSourceElement();
            if (element != null) {
                result = ValidationErrorManager.hasSuppressWarningsAnnotation(preferenceKey, element);
            } else {
                IResource resource = location.getResource();
                if ("java".equalsIgnoreCase(resource.getFileExtension())) {
                    throw new NullPointerException("IJavaSourceReference referenced to java source should not return null in getSourceElement()");
                }
            }
        }
        return result;
    }

    @Override
    public IMarker addError(String message, String preferenceKey, ITextSourceReference location, IResource target) {
        return this.addError(message, preferenceKey, new String[0], location, target);
    }

    @Override
    public IMarker addError(String message, String preferenceKey, String[] messageArguments, IResource target) {
        return this.addError(message, preferenceKey, messageArguments, 0, 0, 0, target);
    }

    private String getMarkerId() {
        return this.markerId;
    }

    protected abstract String getPreference(IProject var1, String var2);

    protected boolean shouldCheckDuplicateMarkers() {
        return false;
    }

    protected void cleanSavedMarkers() {
        this.markers.clear();
    }

    protected int getSeverity(String preferenceKey, IResource target) {
        String preferenceValue = this.getPreference(target.getProject(), preferenceKey);
        int severity = -1;
        if (!"ignore".equals(preferenceValue)) {
            severity = "warning".equals(preferenceValue) ? (severity = 2) : 1;
        }
        return severity;
    }

    public IMarker addError(String message, String preferenceKey, String[] messageArguments, int lineNumber, int length, int offset, IResource target, int severity) {
        IMarker marker = null;
        if (severity != -1) {
            if (this.shouldCheckDuplicateMarkers()) {
                MarkerID id = new MarkerID(preferenceKey, length, offset, target.getFullPath().toOSString());
                if (!this.markers.contains(id) && (marker = this.addError(message, severity, messageArguments, lineNumber, length, offset, target, this.getDocumentProvider(), this.getMarkerId(), this.getMarkerOwner())) != null) {
                    this.markers.add(id);
                }
            } else {
                marker = this.addError(message, severity, messageArguments, lineNumber, length, offset, target, this.getDocumentProvider(), this.getMarkerId(), this.getMarkerOwner());
            }
        }
        try {
            if (marker != null && preferenceKey != null) {
                marker.setAttribute(PREFERENCE_KEY_ATTRIBUTE_NAME, (Object)preferenceKey);
            }
        }
        catch (CoreException e) {
            CommonPlugin.getDefault().logError((Throwable)e);
        }
        return marker;
    }

    @Override
    public IMarker addError(String message, String preferenceKey, String[] messageArguments, int lineNumber, int length, int offset, IResource target) {
        return this.addError(message, preferenceKey, messageArguments, lineNumber, length, offset, target, this.getSeverity(preferenceKey, target));
    }

    public IMarker addError(String message, String preferenceKey, String[] messageArguments, int length, int offset, IResource target, int messageId) {
        IMarker marker = this.addError(message, preferenceKey, messageArguments, length, offset, target);
        try {
            if (marker != null) {
                marker.setAttribute(MESSAGE_ID_ATTRIBUTE_NAME, (Object)new Integer(messageId));
            }
        }
        catch (CoreException e) {
            CommonPlugin.getDefault().logError((Throwable)e);
        }
        return marker;
    }

    @Override
    public IMarker addError(String message, String preferenceKey, String[] messageArguments, int length, int offset, IResource target) {
        return this.addError(message, preferenceKey, messageArguments, 0, length, offset, target);
    }

    public TextFileDocumentProvider getDocumentProvider() {
        if (this.documentProvider == null) {
            this.documentProvider = this.coreHelper != null ? this.coreHelper.getDocumentProvider() : new TextFileDocumentProvider();
        }
        return this.documentProvider;
    }

    protected Class getMarkerOwner() {
        return this.getClass();
    }

    public IProjectValidationContext getValidationContext() {
        return this.validationContext;
    }

    @Override
    public IMarker addError(String message, int severity, String[] messageArguments, int lineNumber, int length, int offset, IResource target) {
        return this.addError(message, severity, messageArguments, lineNumber, length, offset, target, this.getDocumentProvider(), this.getMarkerId(), this.getMarkerOwner());
    }

    public static IMarker addError(String message, int severity, Object[] messageArguments, int lineNumber, int length, int offset, IResource target, TextFileDocumentProvider documentProvider, String markerId, Class markerOwner, int maxNumberOfMarkersPerFile, String markerType) {
        IMarker marker = null;
        boolean connected = false;
        try {
            try {
                if (lineNumber < 1 && documentProvider != null) {
                    connected = true;
                    documentProvider.connect((Object)target);
                    IDocument doc = documentProvider.getDocument((Object)target);
                    if (doc != null) {
                        try {
                            lineNumber = doc.getLineOfOffset(offset) + 1;
                        }
                        catch (BadLocationException e) {
                            CommonPlugin.getDefault().logError("Wrong offset [" + offset + "] of the problem marker [" + MessageFormat.format(message, messageArguments) + "] for resource: " + target.getFullPath().toOSString(), (Throwable)e);
                        }
                    }
                }
                marker = ValidationErrorManager.addTask(markerOwner.getName().intern(), target, lineNumber, MessageFormat.format(message, messageArguments), severity, null, markerId, offset, length, maxNumberOfMarkersPerFile, markerType);
            }
            catch (CoreException e) {
                CommonPlugin.getDefault().logError(NLS.bind((String)ValidationMessages.EXCEPTION_DURING_CREATING_MARKER, (Object)target.getFullPath()), (Throwable)e);
                if (documentProvider != null && connected) {
                    documentProvider.disconnect((Object)target);
                }
            }
        }
        finally {
            if (documentProvider != null && connected) {
                documentProvider.disconnect((Object)target);
            }
        }
        return marker;
    }

    public IMarker addError(String message, String preferenceKey, ITextSourceReference location, IResource target, int messageId) {
        IMarker marker = this.addError(message, preferenceKey, location, target);
        try {
            if (marker != null) {
                marker.setAttribute(MESSAGE_ID_ATTRIBUTE_NAME, (Object)new Integer(messageId));
            }
        }
        catch (CoreException e) {
            CommonPlugin.getDefault().logError((Throwable)e);
        }
        return marker;
    }

    public IMarker addError(String message, int severity, Object[] messageArguments, int lineNumber, int length, int offset, IResource target, TextFileDocumentProvider documentProvider, String markerId, Class markerOwner) {
        if (this.document != null && lineNumber < 0) {
            try {
                lineNumber = this.document.getLineOfOffset(offset) + 1;
            }
            catch (BadLocationException e) {
                CommonPlugin.getDefault().logError("Wrong offset [" + offset + "] of the problem marker [" + MessageFormat.format(message, messageArguments) + "] for resource: " + target.getFullPath().toOSString(), (Throwable)e);
            }
        }
        MarkerManager.getDefault().getMarkers().add(this.getProblemType());
        return ValidationErrorManager.addError(message, severity, messageArguments, lineNumber, length, offset, target, documentProvider, markerId, markerOwner, this.getMaxNumberOfMarkersPerFile(target.getProject()), this.getProblemType());
    }

    public abstract int getMaxNumberOfMarkersPerFile(IProject var1);

    private static IMarker addTask(String pluginId, IResource resource, int location, String message, int severityEnumValue, String targetObjectName, String groupName, int offset, int length, int maxNumberOfMarkersPerFile, String markerType) throws CoreException {
        int existingMarkers;
        int severity = ValidationErrorManager.getSeverity(severityEnumValue);
        if (markerType == null) {
            markerType = DEFAULT_VALIDATION_MARKER;
        }
        if (maxNumberOfMarkersPerFile > 0 && (existingMarkers = resource.findMarkers(markerType, true, 0).length) >= maxNumberOfMarkersPerFile) {
            return null;
        }
        IMarker item = resource.createMarker(markerType);
        boolean offsetSet = offset != -1 && length != -1;
        int size = offsetSet ? 7 : 5;
        String[] attribNames = new String[size];
        Object[] attribValues = new Object[size];
        attribNames[0] = VALIDATION_MARKER_OWNER;
        attribValues[0] = pluginId;
        attribNames[1] = VALIDATION_MARKER_GROUP;
        attribValues[1] = groupName == null ? "" : groupName;
        attribNames[2] = "message";
        attribValues[2] = message;
        attribNames[3] = "severity";
        attribValues[3] = new Integer(severity);
        Integer lineNumber = location;
        attribNames[4] = "lineNumber";
        attribValues[4] = lineNumber;
        if (offsetSet) {
            attribNames[5] = "charStart";
            attribValues[5] = new Integer(offset);
            attribNames[6] = "charEnd";
            attribValues[6] = new Integer(offset + length);
        }
        item.setAttributes(attribNames, attribValues);
        return item;
    }

    private static int getSeverity(int severityEnumValue) {
        switch (severityEnumValue) {
            case 1: {
                return 2;
            }
            case 4: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return 1;
    }

    @Override
    public void displaySubtask(String messageId) {
        this.displaySubtask(messageId, null);
    }

    @Override
    public void displaySubtask(String message, String[] messageArguments) {
        ProblemMessage problemMessage = new ProblemMessage(message, 2, messageArguments);
        this.reporter.displaySubtask(this.validationManager, (IMessage)problemMessage);
    }

    @Override
    public void removeMessagesFromResources(Set<IResource> resources) {
        for (IResource r : resources) {
            WorkbenchReporter.removeAllMessages((IResource)r, (String[])new String[]{this.getMarkerOwner().getName()}, null);
        }
    }

    @Override
    public void removeAllMessagesFromResource(IResource resource) {
        WorkbenchReporter.removeAllMessages((IResource)resource, (String[])new String[]{this.getMarkerOwner().getName()}, null);
    }

    public void removeAllMessagesFromProject(IProject project) {
        HashSet<IMarker> markersToRemove = new HashSet<IMarker>();
        try {
            IMarker[] allMarkers;
            IMarker[] iMarkerArray = allMarkers = project.findMarkers(DEFAULT_VALIDATION_MARKER, true, 0);
            int n = allMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                Object owner = marker.getAttribute(VALIDATION_MARKER_OWNER);
                if (this.getMarkerOwner().getName().equals(owner)) {
                    markersToRemove.add(marker);
                }
                ++n2;
            }
            ResourcesPlugin.getWorkspace().deleteMarkers(markersToRemove.toArray(new IMarker[markersToRemove.size()]));
        }
        catch (CoreException e) {
            CommonPlugin.getDefault().logError((Throwable)e);
        }
    }

    protected abstract void registerPreferenceInfo();

    public final void setProblemType(String problemType) {
        this.problemType = problemType;
    }

    public final String getProblemType() {
        return this.problemType;
    }

    private static class MarkerID {
        String preferenceKey;
        int length;
        int offset;
        String path;

        public MarkerID(String preferenceKey, int length, int offset, String path) {
            this.preferenceKey = preferenceKey;
            this.length = length;
            this.offset = offset;
            this.path = path;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof MarkerID && this.toString().equals(obj.toString());
        }

        public String toString() {
            return String.valueOf(this.path) + ":" + this.preferenceKey + ":" + this.length + ":" + this.offset;
        }
    }
}

