/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.completions;

import java.util.ArrayList;
import java.util.List;
import tern.server.protocol.completions.Parameter;
import tern.utils.StringUtils;

public class TernCompletionItem {
    private final String name;
    private final String type;
    private final String doc;
    private final String url;
    private final String origin;
    private final String signature;
    private final boolean function;
    private boolean array;
    private String jsType;
    private List<Parameter> parameters;
    private String[] allTypes;

    public TernCompletionItem(String name, String type, String doc, String url, String origin) {
        this.name = name;
        this.type = type;
        this.doc = doc;
        this.url = url;
        this.origin = origin;
        this.parameters = null;
        StringBuilder currentParamName = null;
        boolean currentParamRequired = true;
        StringBuilder currentParamType = null;
        StringBuilder signature = new StringBuilder(name);
        this.jsType = type;
        if (!StringUtils.isEmpty(type)) {
            this.function = type.startsWith("fn(");
            if (this.function) {
                signature.append("(");
                int bracket = 0;
                String afterStartFn = type.substring(2, type.length());
                int i = 0;
                i = 0;
                while (i < afterStartFn.length()) {
                    char c = afterStartFn.charAt(i);
                    switch (c) {
                        case '(': {
                            ++bracket;
                            if (currentParamType == null) break;
                            currentParamType.append(c);
                            break;
                        }
                        case ')': {
                            if (--bracket < 1 || currentParamType == null) break;
                            currentParamType.append(c);
                            break;
                        }
                        default: {
                            if (bracket < 1) break;
                            if (currentParamType != null) {
                                if (c == ',') {
                                    if (bracket < 2) {
                                        this.parameters.add(new Parameter(currentParamName.toString(), currentParamRequired, currentParamType != null ? currentParamType.toString() : null));
                                        currentParamName = null;
                                        currentParamRequired = true;
                                        currentParamType = null;
                                        break;
                                    }
                                    currentParamType.append(c);
                                    break;
                                }
                                if (c == ' ') break;
                                currentParamType.append(c);
                                break;
                            }
                            if (currentParamName == null) {
                                if (c == ' ' || c == '?') break;
                                currentParamName = new StringBuilder();
                                currentParamName.append(c);
                                break;
                            }
                            if (c == ':') {
                                if (this.parameters == null) {
                                    this.parameters = new ArrayList<Parameter>();
                                } else {
                                    signature.append(", ");
                                }
                                signature.append(currentParamName.toString());
                                currentParamType = new StringBuilder();
                                break;
                            }
                            if (c == '?') {
                                currentParamRequired = false;
                                break;
                            }
                            if (c == ' ') break;
                            currentParamName.append(c);
                        }
                    }
                    if (bracket == 0) break;
                    ++i;
                }
                signature.append(")");
                StringBuilder s = null;
                int j = i + 1;
                while (j < afterStartFn.length()) {
                    char c = afterStartFn.charAt(j);
                    if (s != null) {
                        s.append(c);
                    } else if (c == '>') {
                        s = new StringBuilder();
                    }
                    ++j;
                }
                this.jsType = s != null ? s.toString().trim() : null;
            } else {
                this.array = type.indexOf("[") != -1;
            }
        } else {
            this.function = false;
            this.array = false;
        }
        if (currentParamName != null) {
            if (this.parameters == null) {
                this.parameters = new ArrayList<Parameter>();
            }
            this.parameters.add(new Parameter(currentParamName.toString(), currentParamRequired, currentParamType != null ? currentParamType.toString() : null));
            currentParamName = null;
            currentParamRequired = true;
            currentParamType = null;
        }
        this.signature = signature.toString();
    }

    public String[] expand() {
        if (this.allTypes == null) {
            if (this.parameters == null) {
                this.allTypes = StringUtils.EMPTY_ARRAY;
            } else {
                ArrayList<Parameter> optionalParameters = null;
                int i = 0;
                while (i < this.parameters.size()) {
                    Parameter parameter = this.parameters.get(i);
                    if (!parameter.isRequired()) {
                        if (optionalParameters == null) {
                            optionalParameters = new ArrayList<Parameter>();
                        }
                        optionalParameters.add(parameter);
                    }
                    ++i;
                }
                if (optionalParameters == null) {
                    this.allTypes = StringUtils.EMPTY_ARRAY;
                } else {
                    ArrayList<String> types = new ArrayList<String>();
                    int nbMaxOptionalParams = 0;
                    while (nbMaxOptionalParams < optionalParameters.size()) {
                        for (Parameter optional : optionalParameters) {
                            this.addType(types, nbMaxOptionalParams, optional, null);
                        }
                        ++nbMaxOptionalParams;
                    }
                    this.allTypes = types.toArray(StringUtils.EMPTY_ARRAY);
                }
            }
        }
        return this.allTypes;
    }

    public void addType(List<String> types, int nbMaxOptional, Parameter optional, Integer index) {
        Integer newIndex = null;
        int nbOptionalAdded = -1;
        StringBuilder newType = new StringBuilder("fn(");
        int i = 0;
        while (i < this.parameters.size()) {
            Parameter parameter = this.parameters.get(i);
            if (parameter.isRequired()) {
                this.addParam(newType, parameter);
            } else {
                if (nbOptionalAdded == -1 && optional.equals(parameter)) {
                    nbOptionalAdded = 0;
                }
                if (nbOptionalAdded != -1 && nbOptionalAdded < nbMaxOptional) {
                    boolean add = false;
                    if (nbOptionalAdded == 0) {
                        add = true;
                    } else if (index == null) {
                        add = true;
                    } else if (i == index) {
                        add = true;
                    }
                    if (newIndex == null && nbOptionalAdded == 1) {
                        newIndex = this.getNexOptionalIndex(this.parameters, i, index);
                    }
                    if (add) {
                        this.addParam(newType, parameter);
                        ++nbOptionalAdded;
                    }
                }
            }
            ++i;
        }
        newType.append(")");
        if (this.jsType != null) {
            newType.append(" -> ");
            newType.append(this.jsType);
        }
        if (!types.contains(newType.toString())) {
            types.add(newType.toString());
        }
        if (newIndex != null) {
            this.addType(types, nbMaxOptional, optional, newIndex);
        }
    }

    private Integer getNexOptionalIndex(List<Parameter> parameters, int i, Integer index) {
        Parameter parameter = null;
        int j = i + 1;
        while (j < parameters.size()) {
            parameter = parameters.get(j);
            if (!parameter.isRequired() && index == null || index != null && index < j) {
                return j;
            }
            ++j;
        }
        return null;
    }

    public void addParam(StringBuilder newType, Parameter parameter) {
        if (newType.length() > 3) {
            newType.append(", ");
        }
        newType.append(parameter.getName());
        if (!parameter.isRequired()) {
            newType.append("?");
        }
        if (parameter.getType() != null) {
            newType.append(": ");
            newType.append(parameter.getType());
        }
    }

    public String getText() {
        if (StringUtils.isEmpty(this.origin) && StringUtils.isEmpty(this.jsType)) {
            return this.signature;
        }
        StringBuilder text = new StringBuilder(this.signature);
        if (!StringUtils.isEmpty(this.jsType)) {
            text.append(" : ");
            text.append(this.jsType);
        }
        if (!StringUtils.isEmpty(this.origin)) {
            text.append(" - ");
            text.append(this.origin);
        }
        return text.toString();
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public boolean isFunction() {
        return this.function;
    }

    public boolean isArray() {
        return this.array;
    }

    public String getName() {
        return this.name;
    }

    public String getDoc() {
        return this.doc;
    }

    public String getURL() {
        return this.url;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getType() {
        return this.type;
    }

    public String getJsType() {
        return this.jsType;
    }
}

