/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol;

public class HtmlHelper {
    public static String extractJS(String html) {
        State state = new State();
        StringBuilder s = new StringBuilder();
        char[] chars = html.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    s.append(c);
                    break;
                }
                default: {
                    Region matchedRegion = state.add(c);
                    if (matchedRegion == null) {
                        if (state.getRegion().equals((Object)Region.END_SCRIPT)) {
                            s.append(c);
                            break;
                        }
                        s.append(' ');
                        break;
                    }
                    if (matchedRegion.equals((Object)Region.END_SCRIPT)) {
                        s = s.replace(i - 8, i, "        ");
                    }
                    s.append(' ');
                }
            }
            ++i;
        }
        return s.toString();
    }

    private static enum Region {
        OPEN_START_SCRIPT("<script"),
        CLOSE_START_SCRIPT(">"),
        END_SCRIPT("</script>");

        private final char[] pattern;

        private Region(String pattern) {
            this.pattern = pattern.toCharArray();
        }

        public Result search(char c, int index) {
            if (index < this.pattern.length && c == this.pattern[index]) {
                return index == this.pattern.length - 1 ? Result.MATCHED : Result.MATCHING;
            }
            return Result.NO_MATCHING;
        }
    }

    private static enum Result {
        MATCHING,
        NO_MATCHING,
        MATCHED;

    }

    protected static class State {
        private int index = 0;
        private Region region = Region.OPEN_START_SCRIPT;

        protected State() {
        }

        public Region add(char c) {
            Result result = this.region.search(c, this.index);
            switch (result) {
                case MATCHING: {
                    ++this.index;
                    break;
                }
                case NO_MATCHING: {
                    this.index = 0;
                    break;
                }
                case MATCHED: {
                    this.index = 0;
                    switch (this.region) {
                        case OPEN_START_SCRIPT: {
                            this.region = Region.CLOSE_START_SCRIPT;
                            return Region.OPEN_START_SCRIPT;
                        }
                        case CLOSE_START_SCRIPT: {
                            this.region = Region.END_SCRIPT;
                            return Region.CLOSE_START_SCRIPT;
                        }
                        case END_SCRIPT: {
                            this.region = Region.OPEN_START_SCRIPT;
                            return Region.END_SCRIPT;
                        }
                    }
                }
            }
            return null;
        }

        public Region getRegion() {
            return this.region;
        }
    }
}

