/*
 * Decompiled with CFR 0.152.
 */
package tern.metadata;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import tern.metadata.TernModuleMetadataOption;
import tern.server.protocol.JsonHelper;

public class TernModuleMetadata {
    private static final String NAME_FIELD = "name";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String HOMEPAGE_FIELD = "homepage";
    private static final String AUTHOR_FIELD = "author";
    private static final String REPOSITORY_FIELD = "repository";
    private static final String BUGS_FIELD = "bugs";
    private static final String HELP_FIELD = "help";
    private static final String URL_FIELD = "url";
    private static final String DEPENDENCIES_FIELD = "dependencies";
    private static final String OPTIONS_FIELD = "options";
    private final String name;
    private final String description;
    private final String homepage;
    private final String author;
    private final String repositoryURL;
    private final String bugsURL;
    private final String helpURL;
    private final Collection<String> dependencies;
    private final Collection<TernModuleMetadataOption> options;

    public TernModuleMetadata(JsonObject json) {
        this.name = JsonHelper.getString(json, NAME_FIELD);
        this.description = JsonHelper.getString(json, DESCRIPTION_FIELD);
        this.homepage = JsonHelper.getString(json, HOMEPAGE_FIELD);
        this.author = JsonHelper.getString(json, AUTHOR_FIELD);
        this.repositoryURL = this.getURL(json, REPOSITORY_FIELD);
        this.bugsURL = this.getURL(json, BUGS_FIELD);
        this.helpURL = this.getURL(json, HELP_FIELD);
        JsonValue dependencies = json.get(DEPENDENCIES_FIELD);
        this.dependencies = dependencies != null && dependencies instanceof JsonArray ? this.parseDependencies((JsonArray)dependencies) : Collections.emptyList();
        JsonValue options = json.get(OPTIONS_FIELD);
        this.options = options != null && options instanceof JsonArray ? this.parseOptions((JsonArray)options) : Collections.emptyList();
    }

    public String getURL(JsonObject json, String name) {
        JsonValue value = json.get(name);
        if (value != null) {
            return JsonHelper.getString((JsonObject)value, URL_FIELD);
        }
        return null;
    }

    private Collection<String> parseDependencies(JsonArray jsonDependencies) {
        ArrayList<String> dependencies = new ArrayList<String>();
        for (JsonValue jsonDependency : jsonDependencies) {
            dependencies.add(JsonHelper.getString(jsonDependency));
        }
        return dependencies;
    }

    private Collection<TernModuleMetadataOption> parseOptions(JsonArray jsonOptions) {
        ArrayList<TernModuleMetadataOption> options = new ArrayList<TernModuleMetadataOption>();
        for (JsonValue jsonOption : jsonOptions) {
            options.add(new TernModuleMetadataOption((JsonObject)jsonOption));
        }
        return options;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHomePage() {
        return this.homepage;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    public String getBugsURL() {
        return this.bugsURL;
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    public Collection<TernModuleMetadataOption> getOptions() {
        return this.options;
    }

    public Collection<String> getDependencies() {
        return this.dependencies;
    }
}

