/*
 * Decompiled with CFR 0.152.
 */
package tern.angular.modules;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tern.angular.modules.Directive;
import tern.angular.modules.DirectivesByTagName;
import tern.angular.modules.IDirectiveCollector;
import tern.angular.modules.IDirectiveSyntax;
import tern.angular.modules.Restriction;

public class Module {
    private final String name;
    private final DirectivesByTagName allDirectives;
    private final Map<String, DirectivesByTagName> directivesByTagName;

    public Module(String name) {
        this.name = name;
        this.directivesByTagName = new HashMap<String, DirectivesByTagName>();
        this.allDirectives = new DirectivesByTagName();
    }

    public String getName() {
        return this.name;
    }

    void addDirective(Directive directive) {
        Collection<String> tagNames = directive.getTagNames();
        if (tagNames.size() > 0) {
            for (String tagName : tagNames) {
                this.addDirective(tagName, directive);
            }
        } else {
            this.addDirective("any", directive);
        }
        this.allDirectives.addDirective(directive);
    }

    private void addDirective(String tagName, Directive directive) {
        DirectivesByTagName directives = this.getDirectivesByTagName(tagName, true);
        directives.addDirective(directive);
    }

    private DirectivesByTagName getDirectivesByTagName(String tagName, boolean createIfNotExists) {
        if (tagName == null) {
            return this.allDirectives;
        }
        DirectivesByTagName result = this.directivesByTagName.get(tagName);
        if (result == null && createIfNotExists) {
            result = new DirectivesByTagName();
            this.directivesByTagName.put(tagName, result);
        }
        return result;
    }

    public Directive getDirective(String tagName, String name, Restriction restriction) {
        DirectivesByTagName result = this.getDirectivesByTagName(tagName, false);
        Directive directive = null;
        if (result != null) {
            directive = result.getDirective(name, restriction);
        }
        if (directive == null) {
            return this.getDirectivesByTagName("any", false).getDirective(name, restriction);
        }
        return directive;
    }

    public void collectDirectives(String tagName, String directiveName, IDirectiveSyntax syntax, List<Directive> existingDirectives, Restriction restriction, IDirectiveCollector collector) {
        DirectivesByTagName container = this.getDirectivesByTagName(tagName, false);
        this.collectDirectives(directiveName, syntax, existingDirectives, restriction, collector, container);
        if (!"any".equals(tagName)) {
            container = this.getDirectivesByTagName("any", false);
            this.collectDirectives(directiveName, syntax, existingDirectives, restriction, collector, container);
        }
    }

    private void collectDirectives(String directiveName, IDirectiveSyntax syntax, List<Directive> ignoreDirectives, Restriction restriction, IDirectiveCollector collector, DirectivesByTagName container) {
        if (container != null) {
            container.collectDirectives(directiveName, syntax, ignoreDirectives, restriction, collector);
        }
    }

    protected static boolean isMatch(List<Directive> ignoreDirectives, Restriction restriction, Directive directive) {
        if (directive == null) {
            return false;
        }
        if (Module.isIgnore(directive, ignoreDirectives)) {
            return false;
        }
        return directive.isMatch(restriction);
    }

    private static boolean isIgnore(Directive directive, List<Directive> ignoreDirectives) {
        if (ignoreDirectives == null) {
            return false;
        }
        return ignoreDirectives.contains(directive);
    }
}

