/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.server.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.ILaunchConfigConfigurator;

public abstract class LaunchConfiguratorWithOverrides
implements ILaunchConfigConfigurator {
    private static final String DEFAULTS_SET = "DEFAULTS_SET";
    protected IServer server;
    protected IRuntime runtime;

    public LaunchConfiguratorWithOverrides(IServer server) throws CoreException {
        this.server = server;
        this.runtime = server.getRuntime();
    }

    @Override
    public void configure(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        if (!this.areDefaultsSet(launchConfig)) {
            this.doConfigure(launchConfig);
            this.setDefaultsSet(launchConfig);
        }
        if (this.shouldUpdateLaunch(launchConfig)) {
            this.doOverrides(launchConfig);
        }
    }

    protected abstract void doConfigure(ILaunchConfigurationWorkingCopy var1) throws CoreException;

    protected abstract void doOverrides(ILaunchConfigurationWorkingCopy var1) throws CoreException;

    protected String getServerId(IServer server) {
        return server.getId();
    }

    private boolean areDefaultsSet(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        boolean b = launchConfig.hasAttribute(DEFAULTS_SET);
        return b;
    }

    private void setDefaultsSet(ILaunchConfigurationWorkingCopy launchConfig) {
        launchConfig.setAttribute(DEFAULTS_SET, true);
    }

    private boolean shouldUpdateLaunch(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        return launchConfig.getAttribute("org.jboss.ide.eclipse.as.core.server.internal.AUTOMATICALLY_UPDATE_LAUNCH", true);
    }
}

