/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.archives.scanner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.jboss.tools.archives.scanner.ITreeNode;
import org.jboss.tools.archives.scanner.VirtualDirectoryScanner;
import org.jboss.tools.archives.scanner.internal.TreeNodeFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesystemDirectoryScanner
extends VirtualDirectoryScanner<TreeNodeFile> {
    private boolean followSymlinks = true;

    @Override
    public void setBasedir(File basedir) {
        super.setBasedir(new TreeNodeFile(basedir));
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    @Override
    public ITreeNode[] trimInapplicableEntries(ITreeNode[] newfiles, ITreeNode dir, String vpath) {
        if (!this.followSymlinks) {
            return this.trimSymLinkFiles(newfiles, dir, vpath);
        }
        return newfiles;
    }

    private ITreeNode[] trimSymLinkFiles(ITreeNode[] newfiles, ITreeNode dir, String vpath) {
        ArrayList<ITreeNode> noLinks = new ArrayList<ITreeNode>();
        ITreeNode[] iTreeNodeArray = newfiles;
        int n = newfiles.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode newfile = iTreeNodeArray[n2];
            try {
                if (this.isSymbolicLink(dir, newfile)) {
                    String name = String.valueOf(vpath) + newfile;
                    ITreeNode file = newfile;
                    if (this.isDirectory(file)) {
                        this.dirsExcluded.addElement(name);
                    } else {
                        this.filesExcluded.addElement(name);
                    }
                } else {
                    noLinks.add(newfile);
                }
            }
            catch (IOException iOException) {
                String msg = "IOException caught while checking for links, couldn't get cannonical path!";
                System.err.println(msg);
                noLinks.add(newfile);
            }
            ++n2;
        }
        newfiles = noLinks.toArray(new ITreeNode[noLinks.size()]);
        return newfiles;
    }

    protected boolean isSymbolicLink(ITreeNode parent, ITreeNode name) throws IOException {
        File resolvedParent = new File(((File)((Object)parent)).getCanonicalPath());
        File toTest = new File(resolvedParent, name.getName());
        return !toTest.getAbsolutePath().equals(toTest.getCanonicalPath());
    }
}

