/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.ui.vrules.wizard.runtime2;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.wizards.query.AbstractQueryWizardView;
import org.jboss.tools.common.verification.ui.Messages;
import org.jboss.tools.common.verification.ui.vrules.wizard.runtime.VTaskListenerSafeImpl;
import org.jboss.tools.common.verification.ui.vrules.wizard.runtime2.VTaskListenerImpl;
import org.jboss.tools.common.verification.vrules.VHelper;
import org.jboss.tools.common.verification.vrules.VManager;
import org.jboss.tools.common.verification.vrules.VModel;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VTask;
import org.jboss.tools.common.verification.vrules.VTaskListener;
import org.jboss.tools.common.verification.vrules.layer.VModelFactory;
import org.jboss.tools.common.verification.vrules.layer.VObjectImpl;

public class VerifyWizardView
extends AbstractQueryWizardView {
    static final String COMMAND_CANCEL = Messages.VerifyWizardView_Cancel;
    static final String COMMAND_RUN = Messages.VerifyWizardView_Run;
    static final String COMMAND_CLOSE = Messages.VerifyWizardView_Close;
    protected XModel model;
    protected VObject vobject;
    protected VTask task = null;
    protected VTaskListenerImpl taskListener = new VTaskListenerImpl(this);
    protected VTaskListener listener = new VTaskListenerSafeImpl((VTaskListener)this.taskListener);
    ProgressMonitorPart progressMonitorPart;
    static int PROGRESS_INIT_SIZE = 40;
    static int PROGRESS_MAIN_SIZE = 160;
    static int PROGRESS_FIN_SIZE = 40;
    static int PROGRESS_TOTAL_SIZE = PROGRESS_INIT_SIZE + PROGRESS_MAIN_SIZE + PROGRESS_FIN_SIZE;
    protected int ruleCount = 1;
    int ruleIndex = 0;

    public VerifyWizardView() {
        this.setMessage(WizardKeys.getString((String)"VerifyWizardView.Message"));
        this.setTitle(WizardKeys.getString((String)"VerifyWizardView.Title"));
        this.setWindowTitle(WizardKeys.getString((String)"VerifyWizardView.WindowTitle"));
    }

    private VManager getRulesManager() {
        return VHelper.getManager();
    }

    public void setDialog(Dialog d) {
        super.setDialog(d);
        d.getShell().addShellListener((ShellListener)new CL());
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        GridLayout pmlayout = new GridLayout();
        pmlayout.numColumns = 1;
        pmlayout.marginWidth = 20;
        this.progressMonitorPart = new ProgressMonitorPart(composite, (Layout)pmlayout, -1);
        this.progressMonitorPart.setLayoutData((Object)new GridData(768));
        this.progressMonitorPart.setVisible(true);
        return composite;
    }

    public void setObject(Object data) {
        Properties p = this.findProperties(data);
        if (p != null) {
            String key = p.getProperty("help");
            this.setHelpKey(key);
        }
        Object[] os = (Object[])data;
        XModelObject object = (XModelObject)os[0];
        this.model = object.getModel();
        this.ruleCount = 0;
        VModel vmodel = VModelFactory.getModel((XModel)object.getModel());
        this.vobject = vmodel.getObjectByPath(object.getPath());
        VRule[] rules = VHelper.getRules((VManager)this.getRulesManager(), (VObject)this.vobject);
        this.ruleCount = rules == null ? 0 : rules.length;
    }

    public void action(String command) {
        if (COMMAND_RUN.equals(command)) {
            if (this.task != null) {
                this.task.removeTaskListener(this.listener);
            }
            this.taskListener.setModel(this.model);
            this.task = this.getRulesManager().createTask(this.vobject);
            this.taskListener.setTask(this.task);
            this.task.addTaskListener(this.listener);
            this.progressMonitorPart.beginTask(MessageFormat.format(Messages.VerifyWizardView_VerifyTask, ((VObjectImpl)this.vobject).getModelObject().getPresentationString()), PROGRESS_TOTAL_SIZE);
            this.progressMonitorPart.worked(PROGRESS_INIT_SIZE);
            this.task.start();
        } else if (COMMAND_CANCEL.equals(command)) {
            if (this.task != null) {
                this.task.removeTaskListener(this.listener);
                this.task.stop();
                this.task = null;
            }
            this.setCode(0);
            this.dispose();
        } else if (COMMAND_CLOSE.equals(command)) {
            this.setCode(0);
            this.dispose();
        }
    }

    public String[] getCommands() {
        return new String[]{CANCEL};
    }

    void onRuleFinished(VObject object) {
        if (this.vobject != object || this.ruleIndex >= this.ruleCount) {
            return;
        }
        ++this.ruleIndex;
        this.progressMonitorPart.worked(PROGRESS_MAIN_SIZE / this.ruleCount);
    }

    void onFinish() {
        this.progressMonitorPart.worked(PROGRESS_FIN_SIZE);
    }

    class CL
    extends ShellAdapter {
        boolean activated = false;

        CL() {
        }

        public void shellActivated(ShellEvent e) {
            if (this.activated) {
                return;
            }
            this.activated = true;
            VerifyWizardView.this.action(COMMAND_RUN);
        }
    }
}

