/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.model.Build;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.jboss.forge.arquillian.container.Container;
import org.jboss.tools.arquillian.core.ArquillianCoreActivator;
import org.jboss.tools.arquillian.core.internal.archives.IEntry;
import org.jboss.tools.arquillian.core.internal.util.ArquillianSearchEngine;
import org.jboss.tools.arquillian.core.internal.util.ArquillianUtility;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;
import org.jboss.tools.arquillian.ui.internal.launcher.ArquillianProperty;
import org.jboss.tools.arquillian.ui.internal.launcher.AutoResizeTableLayout;
import org.jboss.tools.arquillian.ui.internal.preferences.ContainerEditingSupport;
import org.jboss.tools.arquillian.ui.internal.utils.IDeploymentDescriptor;
import org.jboss.tools.arquillian.ui.internal.wizards.ProjectResource;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ArquillianUIUtil {
    private static final String DEFAULT = "default";
    private static final String JBOSSTOOLS_QUALIFIER = "jbosstools";
    private static final String UNKNOWN = "Unknown";
    private static final String CONFIGURATION = "configuration";
    private static final String ARQ_PREFIX = "arq";
    private static final String CONTAINER = "container";
    private static final String PERIOD = ".";
    private static final String NAME = "name";
    private static final String PROPERTY = "property";
    private static final String QUALIFIER = "qualifier";
    private static final String ARQUILLIAN_XML = "arquillian.xml";
    private static final String ARQUILLIAN_PROPERTIES = "arquillian.properties";
    private static final String ARQUILLIAN_LAUNCH = "arquillian.launch";
    private static final String CREATE_DEPLOYMENT = "createDeployment";
    private static final String ORG_JBOSS_SHRINKWRAP_API_ARCHIVE = "org.jboss.shrinkwrap.api.Archive";
    private static final String ORG_JBOSS_SHRINKWRAP_API_SHRINK_WRAP = "org.jboss.shrinkwrap.api.ShrinkWrap";
    public static final String ADD_AS_MANIFEST_RESOURCE_METHOD = "addAsManifestResource";
    public static final String ADD_AS_WEB_INF_RESOURCE_METHOD = "addAsWebInfResource";
    public static final String ADD_AS_RESOURCE_METHOD = "addAsResource";

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = ArquillianUIActivator.getDefault().getWorkbench();
        if (workbench == null) {
            return null;
        }
        return workbench.getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = ArquillianUIUtil.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    public static IType getActiveType() {
        IWorkbenchPage page = ArquillianUIUtil.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor instanceof CompilationUnitEditor) {
            CompilationUnitEditor cue;
            block7: {
                cue = (CompilationUnitEditor)editor;
                IEditorInput editorInput = cue.getEditorInput();
                if (editorInput == null) {
                    return null;
                }
                IJavaElement javaElement = (IJavaElement)editorInput.getAdapter(IJavaElement.class);
                if (javaElement != null && !javaElement.exists()) {
                    return null;
                }
                IJavaElement element = SelectionConverter.getElementAtOffset((JavaEditor)cue);
                if (element != null) break block7;
                return null;
            }
            try {
                return SelectionConverter.getTypeAtOffset((JavaEditor)cue);
            }
            catch (JavaModelException e) {
                ArquillianUIActivator.log(e);
            }
        }
        return null;
    }

    public static void createDeploymentMethod(ICompilationUnit icu, IType type, NewTypeWizardPage.ImportsManager imports, boolean isAddComments, String delimiter, IDeploymentDescriptor deploymentDescriptor, IJavaElement sibling, boolean force) throws CoreException {
        int n;
        int n2;
        ProjectResource[] projectResourceArray;
        String content = null;
        ImportRewrite importsRewrite = null;
        if (icu != null) {
            importsRewrite = StubUtility.createImportRewrite((ICompilationUnit)icu, (boolean)true);
        }
        String annotation = String.valueOf('@') + ArquillianUIUtil.addImport(imports, importsRewrite, "org.jboss.arquillian.container.test.api.Deployment");
        String methodName = CREATE_DEPLOYMENT;
        ArquillianUIUtil.addImport(imports, importsRewrite, ORG_JBOSS_SHRINKWRAP_API_SHRINK_WRAP);
        ArquillianUIUtil.addImport(imports, importsRewrite, ORG_JBOSS_SHRINKWRAP_API_ARCHIVE);
        JUnitStubUtility.GenStubSettings settings = JUnitStubUtility.getCodeGenerationSettings((IJavaProject)type.getJavaProject());
        settings.createComments = isAddComments;
        StringBuffer buffer = new StringBuffer();
        if (settings.createComments) {
            String retTypeSig = Signature.createTypeSignature((String)ORG_JBOSS_SHRINKWRAP_API_ARCHIVE, (boolean)true);
            String comment = CodeGeneration.getMethodComment((ICompilationUnit)type.getCompilationUnit(), (String)type.getElementName(), (String)methodName, (String[])new String[0], (String[])new String[0], (String)retTypeSig, null, (String)delimiter);
            if (comment != null) {
                buffer.append(comment);
            }
        }
        String archiveType = "jar";
        String archiveName = "";
        String deploymentName = null;
        String deploymentOrder = null;
        boolean addBeansXml = true;
        IType[] types = null;
        ArrayList<String> resources = new ArrayList<String>();
        ArrayList<String> webInfResources = new ArrayList<String>();
        if (deploymentDescriptor != null) {
            ProjectResource[] allResources;
            methodName = deploymentDescriptor.getMethodName();
            archiveType = deploymentDescriptor.getArchiveType();
            archiveName = deploymentDescriptor.getArchiveName();
            addBeansXml = deploymentDescriptor.addBeansXml();
            deploymentName = deploymentDescriptor.getDeploymentName();
            deploymentOrder = deploymentDescriptor.getDeploymentOrder();
            types = deploymentDescriptor.getTypes();
            projectResourceArray = allResources = deploymentDescriptor.getResources();
            n2 = allResources.length;
            n = 0;
            while (n < n2) {
                ProjectResource resource = projectResourceArray[n];
                if ("war".equals(archiveType) && resource.isDeployAsWebInfResource()) {
                    webInfResources.add(resource.getPath().toString());
                } else {
                    resources.add(resource.getPath().toString());
                }
                ++n;
            }
        }
        buffer.append(annotation);
        if (deploymentName != null && !deploymentName.isEmpty() || deploymentOrder != null && !deploymentOrder.isEmpty()) {
            buffer.append("(");
            if (deploymentName != null && !deploymentName.isEmpty()) {
                buffer.append("name = \"");
                buffer.append(deploymentName);
                buffer.append("\"");
                if (deploymentOrder != null && !deploymentOrder.isEmpty()) {
                    buffer.append(" , ");
                }
            }
            if (deploymentOrder != null && !deploymentOrder.isEmpty()) {
                buffer.append("order = ");
                buffer.append(deploymentOrder);
            }
            buffer.append(")");
        }
        buffer.append(delimiter);
        buffer.append("public static Archive<?> ");
        buffer.append(methodName);
        buffer.append("()");
        buffer.append(" {").append(delimiter);
        if ("jar".equals(archiveType)) {
            ArquillianUIUtil.addImport(imports, importsRewrite, "org.jboss.shrinkwrap.api.spec.JavaArchive");
            buffer.append("JavaArchive archive = ShrinkWrap.create(JavaArchive.class");
        }
        if ("war".equals(archiveType)) {
            ArquillianUIUtil.addImport(imports, importsRewrite, "org.jboss.shrinkwrap.api.spec.WebArchive");
            buffer.append("WebArchive archive = ShrinkWrap.create(WebArchive.class");
        }
        if ("ear".equals(archiveType)) {
            ArquillianUIUtil.addImport(imports, importsRewrite, "org.jboss.shrinkwrap.api.spec.EnterpriseArchive");
            buffer.append("EnterpriseArchive archive = ShrinkWrap.create(EnterpriseArchive.class");
        }
        if ("rar".equals(archiveType)) {
            ArquillianUIUtil.addImport(imports, importsRewrite, "org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive");
            buffer.append("ResourceAdapterArchive archive = ShrinkWrap.create(ResourceAdapterArchive.class");
        }
        if (archiveName != null && !archiveName.isEmpty()) {
            if (archiveName.indexOf(PERIOD) == -1) {
                archiveName = String.valueOf(archiveName) + PERIOD + archiveType;
            }
            buffer.append(", ");
            buffer.append("\"");
            buffer.append(archiveName);
            buffer.append("\"");
        }
        buffer.append(")");
        if (types != null && types.length > 0) {
            buffer.append(delimiter);
            buffer.append(".addClasses( ");
            boolean first = true;
            projectResourceArray = types;
            n2 = types.length;
            n = 0;
            while (n < n2) {
                ProjectResource t = projectResourceArray[n];
                if (!first) {
                    buffer.append(" , ");
                } else {
                    first = false;
                }
                String typeName = t.getFullyQualifiedName();
                int lastPeriod = typeName.lastIndexOf(PERIOD);
                String className = typeName;
                if (lastPeriod >= 0 && lastPeriod < typeName.length()) {
                    className = typeName.substring(lastPeriod + 1, typeName.length());
                    ArquillianUIUtil.addImport(imports, importsRewrite, typeName);
                }
                buffer.append(className);
                buffer.append(".class");
                ++n;
            }
            buffer.append(" )");
        }
        for (String resource : resources) {
            buffer.append(delimiter);
            buffer.append(".addAsResource( ");
            buffer.append("\"");
            buffer.append(resource);
            buffer.append("\"");
            buffer.append(" )");
        }
        for (String resource : webInfResources) {
            buffer.append(delimiter);
            buffer.append(".addAsWebInfResource( ");
            buffer.append("\"");
            buffer.append(resource);
            buffer.append("\"");
            buffer.append(" )");
        }
        if (addBeansXml && !"ear".equals(archiveType)) {
            ArquillianUIUtil.addImport(imports, importsRewrite, "org.jboss.shrinkwrap.api.asset.EmptyAsset");
            buffer.append(delimiter);
            if ("war".equals(archiveType)) {
                buffer.append(".addAsWebInfResource(EmptyAsset.INSTANCE, \"beans.xml\")");
            } else {
                buffer.append(".addAsManifestResource(EmptyAsset.INSTANCE, \"beans.xml\")");
            }
        }
        buffer.append(";").append(delimiter);
        buffer.append("// System.out.println(archive.toString(true));").append(delimiter);
        buffer.append("return archive;").append(delimiter);
        buffer.append("}");
        buffer.append(delimiter);
        content = buffer.toString();
        if (icu == null) {
            type.createMethod(content, sibling, force, null);
        } else {
            TextEdit edit = importsRewrite.rewriteImports(null);
            JavaModelUtil.applyEdit((ICompilationUnit)importsRewrite.getCompilationUnit(), (TextEdit)edit, (boolean)false, null);
            IMethod createdMethod = type.createMethod(content, sibling, force, null);
            ISourceRange range = createdMethod.getSourceRange();
            IBuffer buf = icu.getBuffer();
            String originalContent = buf.getText(range.getOffset(), range.getLength());
            int indent = StubUtility.getIndentUsed((IJavaElement)type) + 1;
            String formattedContent = CodeFormatterUtil.format((int)4, (String)originalContent, (int)indent, (String)delimiter, (IJavaProject)type.getJavaProject());
            while (formattedContent.length() > 0) {
                char ch = formattedContent.charAt(0);
                if (!ScannerHelper.isWhitespace((char)ch)) break;
                formattedContent = formattedContent.substring(1);
            }
            buf.replace(range.getOffset(), range.getLength(), formattedContent);
            icu.reconcile(0, false, null, null);
            icu.commitWorkingCopy(false, null);
        }
    }

    private static String addImport(NewTypeWizardPage.ImportsManager imports, ImportRewrite importsRewrite, String qtn) {
        if (imports != null) {
            return imports.addImport(qtn);
        }
        if (importsRewrite != null) {
            return importsRewrite.addImport(qtn);
        }
        return null;
    }

    public static ICompilationUnit getActiveCompilationUnit() {
        IWorkbenchPage page = ArquillianUIUtil.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor instanceof CompilationUnitEditor) {
            CompilationUnitEditor cue = (CompilationUnitEditor)editor;
            return SelectionConverter.getInputAsCompilationUnit((JavaEditor)cue);
        }
        return null;
    }

    public static Set<ArquillianProperty> getArquillianProperties(ILaunchConfiguration configuration) {
        TreeSet<ArquillianProperty> properties = new TreeSet<ArquillianProperty>();
        try {
            IJavaProject javaProject = ArquillianUtility.getJavaProject((ILaunchConfiguration)configuration);
            if (javaProject == null) {
                return properties;
            }
            if (!ArquillianSearchEngine.hasArquillianType((IJavaProject)javaProject)) {
                return properties;
            }
            String arguments = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
            String args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(arguments);
            Properties vmProperties = ArquillianUIUtil.getVMProperties(args);
            String configurationName = vmProperties.getProperty(ARQUILLIAN_LAUNCH);
            Properties arquillianXmlProperties = null;
            try {
                arquillianXmlProperties = ArquillianUIUtil.getArquillianXmlProperties(javaProject, configurationName);
            }
            catch (Exception e) {
                ArquillianUIActivator.log(e);
            }
            String qualifier = arquillianXmlProperties.getProperty(QUALIFIER, null);
            if (qualifier == null) {
                qualifier = UNKNOWN;
            }
            arquillianXmlProperties.remove(QUALIFIER);
            if (UNKNOWN.equals(qualifier)) {
                qualifier = JBOSSTOOLS_QUALIFIER;
                StringBuffer buf = new StringBuffer();
                buf.append(ARQ_PREFIX);
                buf.append(PERIOD);
                buf.append(CONTAINER);
                buf.append(PERIOD);
                buf.append(qualifier);
                buf.append(PERIOD);
                buf.append(DEFAULT);
                ArquillianProperty property = new ArquillianProperty(buf.toString(), "", ARQUILLIAN_PROPERTIES, true);
                property.setChanged(true);
                properties.add(property);
            }
            ArquillianUIUtil.addContainerProperties(javaProject, properties, qualifier);
            Enumeration<Object> keys = arquillianXmlProperties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = arquillianXmlProperties.getProperty(key);
                ArquillianProperty property = new ArquillianProperty(key, value, ARQUILLIAN_XML, false);
                properties.remove(property);
                properties.add(property);
            }
            String fileName = vmProperties.getProperty(ARQUILLIAN_PROPERTIES, ARQUILLIAN_PROPERTIES);
            Properties arquillianProperties = ArquillianUIUtil.getArquillianProperties(javaProject, fileName);
            keys = arquillianProperties.keys();
            while (keys.hasMoreElements()) {
                String[] elements;
                String key = (String)keys.nextElement();
                if (key != null && key.startsWith("arq.container") && key.endsWith(DEFAULT) && (elements = key.split(PERIOD)).length == 4) continue;
                String value = arquillianProperties.getProperty(key);
                ArquillianProperty property = new ArquillianProperty(key, value, ARQUILLIAN_PROPERTIES, false);
                properties.remove(property);
                properties.add(property);
            }
        }
        catch (CoreException e) {
            ArquillianUIActivator.log(e);
        }
        return properties;
    }

    private static void addContainerProperties(IJavaProject javaProject, Set<ArquillianProperty> properties, String qualifier) {
        IStatus status = ArquillianSearchEngine.validateDeployableContainer((IJavaProject)javaProject);
        if (!status.isOK()) {
            return;
        }
        try {
            IType[] subTypes;
            IType type = javaProject.findType("org.jboss.arquillian.container.spi.client.container.DeployableContainer");
            if (type == null) {
                status = new Status(4, "org.jboss.tools.arquillian.ui", "Cannot find 'org.jboss.arquillian.container.spi.client.container.DeployableContainer' on project build path. Arquillian tests can only be run if DeployableContainer is on the build path.");
                ArquillianUIActivator.getDefault().getLog().log(status);
            }
            ITypeHierarchy hierarchy = type.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType[] iTypeArray = subTypes = hierarchy.getAllSubtypes(type);
            int n = subTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType subType = iTypeArray[n2];
                if (ArquillianSearchEngine.isNonAbstractClass((IType)subType)) {
                    Object containerObject = null;
                    try {
                        containerObject = ArquillianUtility.newInstance((IJavaProject)javaProject, (String)subType.getFullyQualifiedName());
                    }
                    catch (ClassNotFoundException e) {
                        ArquillianUIActivator.log(e);
                        return;
                    }
                    catch (InstantiationException e) {
                        ArquillianUIActivator.log(e);
                        return;
                    }
                    catch (IllegalAccessException e) {
                        ArquillianUIActivator.log(e);
                        return;
                    }
                    catch (NoClassDefFoundError e) {
                        ArquillianUIActivator.log(e);
                        return;
                    }
                    ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
                    ClassLoader loader = ArquillianCoreActivator.getDefault().getClassLoader(javaProject);
                    Thread.currentThread().setContextClassLoader(loader);
                    try {
                        try {
                            Method[] methods;
                            Class<?> clazz = containerObject.getClass();
                            Method configurationMethod = clazz.getDeclaredMethod("getConfigurationClass", new Class[0]);
                            Class configuration = (Class)configurationMethod.invoke(containerObject, new Object[0]);
                            Object configurationObject = ArquillianUtility.newInstance((IJavaProject)javaProject, (String)configuration.getName());
                            Method[] methodArray = methods = configuration.getMethods();
                            int n3 = methods.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Method method = methodArray[n4];
                                String methodName = method.getName();
                                if (methodName.matches("^set[A-Z].*") && method.getReturnType().equals(Void.TYPE) && method.getParameterTypes().length == 1) {
                                    method.setAccessible(true);
                                    String name = String.valueOf(methodName.substring(3, 4).toLowerCase()) + methodName.substring(4);
                                    String getterName = "get" + methodName.substring(3);
                                    String value = null;
                                    try {
                                        Method getter = configuration.getMethod(getterName, new Class[0]);
                                        Object valueObject = getter.invoke(configurationObject, new Object[0]);
                                        if (valueObject != null) {
                                            value = valueObject.toString();
                                        }
                                    }
                                    catch (Exception exception) {}
                                    if (value == null) {
                                        value = "";
                                    }
                                    String propertyName = ArquillianUIUtil.getContainerConfigurationPropertyName(qualifier, name);
                                    ArquillianProperty property = new ArquillianProperty(propertyName, value, CONTAINER, true);
                                    properties.add(property);
                                }
                                ++n4;
                            }
                        }
                        catch (Exception e) {
                            ArquillianUIActivator.log(e);
                            Thread.currentThread().setContextClassLoader(currentLoader);
                        }
                        break;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(currentLoader);
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            ArquillianUIActivator.log(e);
        }
    }

    private static Properties getArquillianProperties(IJavaProject javaProject, String fileName) throws JavaModelException {
        IFile file = ArquillianUIUtil.getFile(javaProject, fileName);
        Properties properties = new Properties();
        if (file != null && file.exists()) {
            InputStream input = null;
            try {
                try {
                    input = file.getContents();
                    properties.load(input);
                }
                catch (CoreException e) {
                    ArquillianUIActivator.log(e);
                    ArquillianUIUtil.close(input);
                }
                catch (IOException e) {
                    ArquillianUIActivator.log(e);
                    ArquillianUIUtil.close(input);
                }
            }
            finally {
                ArquillianUIUtil.close(input);
            }
        }
        return properties;
    }

    private static Properties getArquillianXmlProperties(IJavaProject javaProject, String configurationName) throws CoreException, ParserConfigurationException, SAXException, IOException {
        Properties properties;
        block11: {
            properties = new Properties();
            IFile file = ArquillianUIUtil.getFile(javaProject, ARQUILLIAN_XML);
            if (file != null && file.exists()) {
                InputStream input = null;
                try {
                    try {
                        input = file.getContents(true);
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        Document doc = db.parse(input);
                        Element root = doc.getDocumentElement();
                        Element container = ArquillianUIUtil.getDefaultContainer(configurationName, root);
                        if (container != null) {
                            String qualifier = container.getAttribute(QUALIFIER);
                            properties.put(QUALIFIER, qualifier);
                            Element configuration = ArquillianUIUtil.getConfiguration(container);
                            if (configuration != null) {
                                NodeList configurationList = configuration.getChildNodes();
                                int i = 0;
                                while (i < configurationList.getLength()) {
                                    Node node = configurationList.item(i);
                                    if (node instanceof Element && PROPERTY.equals(node.getNodeName())) {
                                        Element property = (Element)node;
                                        String name = property.getAttribute(NAME);
                                        String propertyName = ArquillianUIUtil.getContainerConfigurationPropertyName(qualifier, name);
                                        String value = property.getTextContent();
                                        if (value != null) {
                                            value = value.trim();
                                            properties.put(propertyName, value);
                                        }
                                    }
                                    ++i;
                                }
                            }
                        }
                    }
                    catch (DOMException e) {
                        ArquillianUIActivator.log(e);
                        ArquillianUIUtil.close(input);
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    ArquillianUIUtil.close(input);
                    throw throwable;
                }
                ArquillianUIUtil.close(input);
            }
        }
        return properties;
    }

    private static String getContainerConfigurationPropertyName(String qualifier, String name) {
        StringBuffer buf = new StringBuffer();
        buf.append(ARQ_PREFIX);
        buf.append(PERIOD);
        buf.append(CONTAINER);
        buf.append(PERIOD);
        if (!UNKNOWN.equals(qualifier)) {
            buf.append(qualifier);
            buf.append(PERIOD);
        }
        buf.append(CONFIGURATION);
        buf.append(PERIOD);
        buf.append(name);
        return buf.toString();
    }

    private static IFile getFile(IJavaProject javaProject, String fileName) throws JavaModelException {
        IClasspathEntry[] rawClasspath;
        IClasspathEntry[] iClasspathEntryArray = rawClasspath = javaProject.getRawClasspath();
        int n = rawClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot[] roots;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && (roots = javaProject.findPackageFragmentRoots(entry)) != null) {
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                int n3 = roots.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                    Object[] resources = root.getNonJavaResources();
                    int segments = root.getPath().segmentCount();
                    Object[] objectArray = resources;
                    int n5 = resources.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IFile file;
                        IPath filePath;
                        IPath relativePath;
                        Object resource = objectArray[n6];
                        if (resource instanceof IFile && fileName.equals((relativePath = (filePath = (file = (IFile)resource).getProjectRelativePath()).removeFirstSegments(segments - 1)).toString())) {
                            return file;
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    private static void close(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void close(OutputStream output) {
        if (output != null) {
            try {
                output.close();
            }
            catch (Exception exception) {}
        }
    }

    private static Element getConfiguration(Element container) {
        Element configuration = null;
        NodeList containerList = container.getChildNodes();
        int i = 0;
        while (i < containerList.getLength()) {
            Element element;
            Node node = containerList.item(i);
            if (node.getNodeType() == 1 && CONFIGURATION.equals((element = (Element)node).getNodeName())) {
                configuration = element;
                break;
            }
            ++i;
        }
        return configuration;
    }

    private static Element getDefaultContainer(String configurationName, Element root) {
        NodeList containers = root.getElementsByTagName(CONTAINER);
        int i = 0;
        while (i < containers.getLength()) {
            Node containerNode = containers.item(i);
            if (containerNode instanceof Element) {
                String defaultString;
                String qualifier;
                Element container = (Element)containerNode;
                if (configurationName != null && !configurationName.isEmpty() ? configurationName.equals(qualifier = container.getAttribute(QUALIFIER)) : "true".equals(defaultString = container.getAttribute(DEFAULT))) {
                    return container;
                }
            }
            ++i;
        }
        return null;
    }

    private static Properties getVMProperties(String vmArgs) {
        String[] arguments;
        Properties properties = new Properties();
        if (vmArgs != null && (arguments = vmArgs.split(" ")) != null) {
            String[] stringArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                String[] props;
                String arg = stringArray[n2];
                if ((arg = arg.trim()).startsWith("-Darq") && (props = arg.split("=")) != null && props.length == 2) {
                    String name = props[0].substring(2);
                    String value = props[1];
                    properties.put(name, value);
                }
                ++n2;
            }
        }
        return properties;
    }

    public static void save(Set<ArquillianProperty> arquillianProperties, ILaunchConfiguration configuration) throws CoreException {
        if (arquillianProperties == null || configuration == null) {
            return;
        }
        IJavaProject javaProject = ArquillianUtility.getJavaProject((ILaunchConfiguration)configuration);
        if (javaProject == null) {
            return;
        }
        IFile file = ArquillianUIUtil.getFile(javaProject, ARQUILLIAN_PROPERTIES);
        if (file == null) {
            file = ArquillianUIUtil.getNewFile(javaProject, ARQUILLIAN_PROPERTIES);
        }
        if (!file.exists()) {
            ArquillianUIUtil.createEmptyFile(file);
        }
        InputStream input = null;
        Properties properties = new Properties();
        input = file.getContents();
        try {
            try {
                properties.load(input);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.arquillian.ui", e.getMessage(), (Throwable)e));
            }
        }
        finally {
            if (input != null) {
                ArquillianUIUtil.close(input);
            }
        }
        boolean changed = false;
        for (ArquillianProperty arquillianProperty : arquillianProperties) {
            if (!arquillianProperty.isChanged() || !ARQUILLIAN_PROPERTIES.equals(arquillianProperty.getSource())) continue;
            properties.put(arquillianProperty.getName(), arquillianProperty.getValue());
            changed = true;
        }
        if (changed) {
            ByteArrayOutputStream out = null;
            ByteArrayInputStream in = null;
            try {
                try {
                    out = new ByteArrayOutputStream();
                    properties.store(out, "Created by JBoss Tools");
                    out.toString();
                    in = new ByteArrayInputStream(out.toByteArray());
                    file.setContents((InputStream)in, true, true, null);
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.jboss.tools.arquillian.ui", e.getMessage(), (Throwable)e));
                }
            }
            catch (Throwable throwable) {
                ArquillianUIUtil.close(in);
                ArquillianUIUtil.close(out);
                throw throwable;
            }
            ArquillianUIUtil.close(in);
            ArquillianUIUtil.close(out);
        }
    }

    private static IFile getNewFile(IJavaProject javaProject, String arquillianProperties) throws CoreException {
        IClasspathEntry[] rawClasspath;
        IProject project = javaProject.getProject();
        if (project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
            IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(project, (IProgressMonitor)new NullProgressMonitor());
            MavenProject mavenProject = facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
            Build build = mavenProject.getBuild();
            String testDirectory = null;
            List testResources = build.getTestResources();
            testDirectory = testResources != null && testResources.size() > 0 ? ((Resource)testResources.get(0)).getDirectory() : build.getTestSourceDirectory();
            File testDir = new File(testDirectory);
            if (testDir.isDirectory()) {
                File arquillianFile = new File(testDir, arquillianProperties);
                Path path = new Path(arquillianFile.getAbsolutePath());
                IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                if (!iFile.getParent().exists()) {
                    IPath projectPath = javaProject.getProject().getLocation();
                    IPath iFilePath = iFile.getLocation();
                    if (iFilePath.toString().startsWith(projectPath.toString())) {
                        String s = iFilePath.toString().substring(projectPath.toString().length());
                        path = new Path(s);
                        return javaProject.getProject().getFile((IPath)path);
                    }
                }
                return iFile;
            }
        }
        IPath path = null;
        IClasspathEntry[] iClasspathEntryArray = rawClasspath = javaProject.getRawClasspath();
        int n = rawClasspath.length;
        int testDirectory = 0;
        while (testDirectory < n) {
            IPackageFragmentRoot[] roots;
            IClasspathEntry entry = iClasspathEntryArray[testDirectory];
            if (entry.getEntryKind() == 3 && (roots = javaProject.findPackageFragmentRoots(entry)) != null) {
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                if (roots.length != 0) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[0];
                    path = root.getPath();
                }
            }
            ++testDirectory;
        }
        if (path == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.arquillian.ui", "Invalid project"));
        }
        IFolder folder = javaProject.getProject().getFolder(path);
        if (!folder.exists()) {
            IPath projectPath = javaProject.getPath();
            path = path.makeRelativeTo(projectPath);
            folder = javaProject.getProject().getFolder(path);
        }
        return folder.getFile(arquillianProperties);
    }

    private static void createEmptyFile(IFile file) throws CoreException {
        ByteArrayInputStream input = null;
        try {
            try {
                input = new ByteArrayInputStream("".getBytes());
                file.create((InputStream)input, true, null);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.arquillian.ui", e.getMessage(), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                ArquillianUIUtil.close(input);
            }
            throw throwable;
        }
        if (input != null) {
            ArquillianUIUtil.close(input);
        }
    }

    public static CheckboxTableViewer createProfilesViewer(Composite parent, List<Container> containers, int heightHint) {
        CheckboxTableViewer viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)68356);
        GridData gd = new GridData(4, 4, true, false);
        gd.heightHint = heightHint;
        viewer.getTable().setLayoutData((Object)gd);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(parent.getFont());
        viewer.setContentProvider((IContentProvider)new ContainerContentProvider(containers));
        String[] columnHeaders = new String[]{"ID", "Name"};
        int i = 0;
        while (i < columnHeaders.length) {
            TableViewerColumn column = new TableViewerColumn((TableViewer)viewer, 0);
            column.setLabelProvider((CellLabelProvider)new ContainerLabelProvider(i));
            column.getColumn().setText(columnHeaders[i]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(true);
            column.setEditingSupport((EditingSupport)new ContainerEditingSupport((ColumnViewer)viewer, i));
            ++i;
        }
        ColumnLayoutData[] containersLayouts = new ColumnLayoutData[]{new ColumnWeightData(200, 200), new ColumnWeightData(150, 150)};
        AutoResizeTableLayout layout = new AutoResizeTableLayout(table);
        int i2 = 0;
        while (i2 < containersLayouts.length) {
            layout.addColumnData(containersLayouts[i2]);
            ++i2;
        }
        viewer.getTable().setLayout((Layout)layout);
        ArquillianUIUtil.configureViewer(viewer);
        viewer.setInput(containers);
        return viewer;
    }

    public static void initializeViewer(CheckboxTableViewer viewer, List<Container> containers) {
        List selectedProfiles = ArquillianUtility.getProfilesFromPreferences((String)"selectedArquillianProfiles");
        List activatedProfiles = ArquillianUtility.getProfilesFromPreferences((String)"activatedArquillianProfiles");
        for (Container container : containers) {
            container.setActivate(activatedProfiles.contains(container.getId()));
            viewer.setChecked((Object)container, selectedProfiles.contains(container.getId()));
        }
        viewer.refresh();
    }

    private static void configureViewer(final CheckboxTableViewer viewer) {
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager((TableViewer)viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)viewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                ViewerCell cell = viewer.getColumnViewerEditor().getFocusCell();
                if (cell != null && cell.getColumnIndex() == 1) {
                    return super.isEditorActivationEvent(event);
                }
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)viewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
    }

    public static IProject getSelectedProject(ISelection selection) {
        ICompilationUnit cu;
        IProject selected = null;
        if (selection instanceof IStructuredSelection) {
            IResource resource;
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (object instanceof IResource) {
                return ((IResource)object).getProject();
            }
            if (object instanceof IAdaptable && (resource = (IResource)((IAdaptable)object).getAdapter(IResource.class)) != null) {
                return resource.getProject();
            }
            if (object instanceof IEntry) {
                return ((IEntry)object).getJavaProject().getProject();
            }
        }
        if (selection instanceof ITextSelection && (cu = ArquillianUIUtil.getActiveCompilationUnit()) != null) {
            selected = cu.getJavaProject().getProject();
        }
        return selected;
    }

    static class ContainerContentProvider
    implements IStructuredContentProvider {
        private List<Container> containers;

        public ContainerContentProvider(List<Container> containers) {
            this.containers = containers;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.containers.toArray();
        }

        public void dispose() {
        }
    }

    static class ContainerLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        public ContainerLabelProvider(int i) {
            this.columnIndex = i;
        }

        public String getText(Object element) {
            if (element instanceof Container) {
                Container container = (Container)element;
                switch (this.columnIndex) {
                    case 0: {
                        return container.getId();
                    }
                    case 1: {
                        String name = container.getName();
                        if (name == null) {
                            return null;
                        }
                        return name.replace("Arquillian Container ", "");
                    }
                }
            }
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }
    }
}

