/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.core.validation;

import java.io.IOException;
import org.eclipse.angularjs.core.AngularProject;
import org.eclipse.angularjs.core.utils.AngularDOMUtils;
import org.eclipse.angularjs.core.utils.AngularScopeHelper;
import org.eclipse.angularjs.core.utils.DOMUtils;
import org.eclipse.angularjs.core.validation.LocalizedMessage;
import org.eclipse.angularjs.internal.core.AngularCoreMessages;
import org.eclipse.angularjs.internal.core.Trace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.validate.ErrorInfo;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import tern.angular.AngularType;
import tern.angular.modules.AngularModulesManager;
import tern.angular.modules.Directive;
import tern.angular.modules.Restriction;
import tern.angular.protocol.TernAngularQuery;
import tern.angular.protocol.type.TernAngularTypeQuery;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.scriptpath.ITernScriptPath;
import tern.server.protocol.TernQuery;
import tern.server.protocol.type.ITernTypeCollector;
import tern.server.protocol.type.ValidationTernTypeCollector;

public class ValidatorUtils {
    public static boolean isIgnoreError(ErrorInfo info, IProject project) {
        String name;
        short targetType = info.getTargetType();
        return (targetType == 2 || targetType == 1) && info.getState() == 11 && ValidatorUtils.isDirective(project, name = info.getHint(), targetType);
    }

    private static boolean isDirective(IProject project, String name, int targetType) {
        try {
            if (AngularProject.hasAngularNature(project)) {
                AngularProject angularProject = AngularProject.getAngularProject(project);
                return AngularModulesManager.getInstance().getDirective((Object)angularProject, null, name, ValidatorUtils.getRestriction(targetType)) != null;
            }
        }
        catch (CoreException e) {
            Trace.trace((byte)2, "Error while getting angular project", e);
        }
        return false;
    }

    private static Restriction getRestriction(int targetType) {
        switch (targetType) {
            case 2: {
                return Restriction.A;
            }
            case 1: {
                return Restriction.E;
            }
        }
        return null;
    }

    static boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && (resource.getName().charAt(0) != '.' || resource.getType() != 2)) continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    public static void validateFile(IReporter reporter, IFile file, ValidationResult result, IValidator origin) {
        if (AngularProject.hasAngularNature(file.getProject())) {
            if (reporter != null && reporter.isCancelled()) {
                throw new OperationCanceledException();
            }
            if (!ValidatorUtils.shouldValidate(file)) {
                return;
            }
            IDOMModel model = DOMUtils.getModel(file.getProject(), file);
            if (model == null) {
                return;
            }
            IStructuredDocumentRegion[] regions = model.getStructuredDocument().getStructuredDocumentRegions();
            ValidatorUtils.validate(reporter, file, model, regions, origin);
        }
    }

    private static void validate(IReporter reporter, IFile file, IDOMModel model, IStructuredDocumentRegion[] regions, IValidator origin) {
        int i = 0;
        while (i < regions.length) {
            ValidatorUtils.validate(regions[i], reporter, file, (IStructuredModel)model, origin);
            ++i;
        }
    }

    public static void validate(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter, IFile file, IStructuredModel model, IValidator origin) {
        IProject project = file.getProject();
        if (ValidatorUtils.isStartTag(structuredDocumentRegion)) {
            IDOMNode node = DOMUtils.getNodeByOffset(model, structuredDocumentRegion.getStartOffset());
            if (node == null || node.getNodeType() != 1) {
                return;
            }
            IDOMElement element = (IDOMElement)node;
            NamedNodeMap map = element.getAttributes();
            int i = 0;
            while (i < map.getLength()) {
                Directive directive;
                IDOMAttr attr = (IDOMAttr)map.item(i);
                if (attr.getValueRegionStartOffset() != 0 && (directive = AngularDOMUtils.getAngularDirective(project, (Attr)attr)) != null) {
                    switch (directive.getType()) {
                        case module: 
                        case controller: {
                            try {
                                IIDETernProject ternProject = AngularProject.getTernProject(project);
                                boolean exists = ValidatorUtils.isAngularElementExists(attr, file, (IDocument)structuredDocumentRegion.getParentDocument(), ternProject, directive.getType());
                                if (exists) break;
                                reporter.addMessage(origin, (IMessage)ValidatorUtils.createMessage(attr, directive.getType(), (IResource)file));
                                break;
                            }
                            catch (Exception e) {
                                Trace.trace((byte)3, "Error while tern validator.", e);
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    private static boolean isStartTag(IStructuredDocumentRegion structuredDocumentRegion) {
        if (structuredDocumentRegion == null || structuredDocumentRegion.isDeleted()) {
            return false;
        }
        return structuredDocumentRegion.getFirstRegion().getType() == "XML_TAG_OPEN";
    }

    private static boolean isAngularElementExists(IDOMAttr attr, IFile file, IDocument document, IIDETernProject ternProject, AngularType angularType) throws CoreException, IOException, Exception {
        TernAngularTypeQuery query = new TernAngularTypeQuery(angularType);
        query.setExpression(AngularScopeHelper.getAngularValue(attr, angularType));
        ITernScriptPath scriptPath = AngularScopeHelper.populateScope(attr.getOwnerElement(), file, angularType, (TernAngularQuery)query);
        ValidationTernTypeCollector collector = new ValidationTernTypeCollector();
        if (scriptPath != null) {
            ternProject.request((TernQuery)query, query.getFiles(), scriptPath, (ITernTypeCollector)collector);
        } else {
            ternProject.request((TernQuery)query, query.getFiles(), (Node)attr, file, document, (ITernTypeCollector)collector);
        }
        return collector.isExists();
    }

    private static LocalizedMessage createMessage(IDOMAttr attr, AngularType type, IResource resource) {
        String textContent = AngularScopeHelper.getAngularValue(attr, type);
        int start = attr.getValueRegionStartOffset();
        return ValidatorUtils.createMessage(attr, start, textContent, type, resource);
    }

    public static LocalizedMessage createMessage(IDOMAttr node, int start, String textContent, AngularType type, IResource resource) {
        int length = textContent.trim().length() + 2;
        String messageText = NLS.bind((String)AngularCoreMessages.Validation_AngularElementNotFound, (Object)type.name(), (Object)textContent);
        int severity = 1;
        return ValidatorUtils.createMessage(start, length, messageText, severity, node.getStructuredDocument(), resource);
    }

    public static LocalizedMessage createMessage(int start, int length, String messageText, int severity, IStructuredDocument structuredDocument, IResource resource) {
        int lineNo = ValidatorUtils.getLineNumber(start, (IDocument)structuredDocument);
        LocalizedMessage message = new LocalizedMessage(severity, messageText, resource);
        message.setOffset(start);
        message.setLength(length);
        message.setLineNo(lineNo);
        return message;
    }

    private static int getLineNumber(int start, IDocument document) {
        int lineNo = -1;
        try {
            lineNo = document.getLineOfOffset(start);
        }
        catch (BadLocationException e) {
            Trace.trace((byte)3, e.getMessage(), e);
        }
        return lineNo;
    }
}

