/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.core.utils;

import org.eclipse.angularjs.core.AngularProject;
import org.eclipse.angularjs.core.utils.AngularELRegion;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public class AngularRegionUtils {
    public static AngularELRegion getAngularELRegion(IStructuredDocumentRegion documentRegion, int documentPosition, IProject project) {
        String startSymbol = "{{";
        String endSymbol = "}}";
        try {
            AngularProject angularProject = AngularProject.getAngularProject(project);
            startSymbol = angularProject.getStartSymbol();
            endSymbol = angularProject.getEndSymbol();
        }
        catch (CoreException coreException) {}
        String regionType = documentRegion.getType();
        String regionText = documentRegion.getText();
        int regionStartOffset = documentRegion.getStartOffset();
        return AngularRegionUtils.getAngularELRegion(regionType, regionText, regionStartOffset, documentPosition, startSymbol, endSymbol);
    }

    public static AngularELRegion getAngularELRegion(String regionType, String regionText, int regionStartOffset, int documentPosition, IProject project) {
        String startSymbol = "{{";
        String endSymbol = "}}";
        try {
            AngularProject angularProject = AngularProject.getAngularProject(project);
            startSymbol = angularProject.getStartSymbol();
            endSymbol = angularProject.getEndSymbol();
        }
        catch (CoreException coreException) {}
        return AngularRegionUtils.getAngularELRegion(regionType, regionText, regionStartOffset, documentPosition, startSymbol, endSymbol);
    }

    public static AngularELRegion getAngularELRegion(String regionType, String regionText, int regionStartOffset, int documentPosition, String startSymbol, String endSymbol) {
        int startOffset = documentPosition - regionStartOffset;
        if (startOffset < 0) {
            return null;
        }
        if (regionType == "XML_CONTENT" || regionType == "XML_TAG_ATTRIBUTE_VALUE") {
            int endExprIndex;
            String expression = null;
            String text = regionText.substring(0, startOffset);
            int startExprIndex = text.lastIndexOf(startSymbol);
            if (startExprIndex != -1 && startExprIndex < (endExprIndex = regionText.indexOf(endSymbol, startOffset))) {
                expression = regionText.substring(startExprIndex + startSymbol.length(), endExprIndex);
            }
            if (expression != null) {
                int expressionOffset = startOffset - startExprIndex - startSymbol.length();
                return new AngularELRegion(expression, expressionOffset);
            }
        }
        return null;
    }
}

