/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.core.link;

import org.eclipse.angularjs.core.link.AngularLink;
import org.eclipse.angularjs.core.link.AngularLinkResource;
import org.eclipse.angularjs.core.utils.StringUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import tern.eclipse.ide.core.scriptpath.ITernScriptPath;

public class AngularLinkHelper {
    static final QualifiedName CONTROLLER_INFO = new QualifiedName("tern.eclipse.ide.core.resourceprops", "ControllerInfo");

    public static void setController(ITernScriptPath scriptPath, String module, String controller, IResource resource, String elementId) throws Exception {
        AngularLinkResource linkResource = AngularLinkHelper.getControllerInfo(resource);
        if (linkResource == null) {
            linkResource = new AngularLinkResource(resource, null);
        }
        linkResource.addLink(scriptPath, module, controller, elementId);
        linkResource.save();
    }

    public static AngularLinkResource getControllerInfo(IResource resource) throws Exception {
        String resourceInfo;
        AngularLinkResource info = (AngularLinkResource)resource.getSessionProperty(CONTROLLER_INFO);
        if (info == null && !StringUtils.isEmpty(resourceInfo = resource.getPersistentProperty(CONTROLLER_INFO))) {
            info = new AngularLinkResource(resource, resourceInfo);
            info.save();
        }
        return info;
    }

    public static void removeController(IResource resource, ITernScriptPath scriptPath, String module, String controller, String elementId) throws CoreException {
        resource.setSessionProperty(CONTROLLER_INFO, null);
        resource.setPersistentProperty(CONTROLLER_INFO, null);
    }

    public static boolean hasController(IResource resource) {
        try {
            return AngularLinkHelper.getControllerInfo(resource) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSameController(IResource resource, ITernScriptPath scriptPath, String module, String controller, String elementId) {
        try {
            AngularLinkResource info = AngularLinkHelper.getControllerInfo(resource);
            if (info != null) {
                if (elementId != null && info.getElementLinks() != null) {
                    for (AngularLink elementLink : info.getElementLinks()) {
                        if (!AngularLinkHelper.isSameController(elementLink, scriptPath, module, controller, elementId)) continue;
                        return true;
                    }
                }
                if (info.getResourceLink() != null) {
                    return AngularLinkHelper.isSameController(info.getResourceLink(), scriptPath, module, controller, elementId);
                }
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isSameController(AngularLink link, ITernScriptPath scriptPath, String module, String controller, String elementId) {
        if (!link.getScriptPath().getResource().getProject().equals((Object)scriptPath.getResource().getProject())) {
            return false;
        }
        if (!link.getModule().equals(module)) {
            return false;
        }
        if (!StringUtils.isEmpty(link.getController()) ? !link.getController().equals(controller) : controller != null) {
            return false;
        }
        return !(!StringUtils.isEmpty(link.getElementId()) ? !link.getElementId().equals(elementId) : elementId != null);
    }
}

