/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.core;

import org.eclipse.angularjs.core.AngularProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import tern.angular.protocol.completions.TernAngularCompletionsQuery;
import tern.angular.protocol.definition.TernAngularDefinitionQuery;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.scriptpath.ITernScriptPath;
import tern.server.protocol.TernQuery;
import tern.server.protocol.completions.ITernCompletionCollector;
import tern.server.protocol.definition.ITernDefinitionCollector;

public class BaseModel {
    private final String name;
    private final Type type;
    private final ITernScriptPath scriptPath;

    public BaseModel(String name, Type type, ITernScriptPath scriptPath) {
        this.type = type;
        this.name = name;
        this.scriptPath = scriptPath;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public ITernScriptPath getScriptPath() {
        return this.scriptPath;
    }

    protected IIDETernProject getTernProject() throws CoreException {
        IProject project = this.getProject();
        return AngularProject.getTernProject(project);
    }

    public IProject getProject() {
        return this.scriptPath.getOwnerProject();
    }

    protected void execute(TernAngularCompletionsQuery query, ITernCompletionCollector collector) {
        try {
            IIDETernProject ternProject = this.getTernProject();
            ternProject.request((TernQuery)query, query.getFiles(), this.scriptPath, collector);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void execute(TernAngularDefinitionQuery query, ITernDefinitionCollector collector) {
        try {
            IIDETernProject ternProject = this.getTernProject();
            ternProject.request((TernQuery)query, query.getFiles(), this.scriptPath, collector);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum Type {
        ScriptsFolder,
        ModulesFolder,
        Module,
        AngularElement;

    }
}

