/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.Set;
import org.eclipse.sapphire.util.SetFactory;

public final class FileName
implements Comparable<FileName> {
    private static final boolean WINDOWS = System.getProperties().getProperty("os.name").startsWith("Windows");
    private static final Set<Character> INVALID_CHARACTERS;
    private static final Set<String> INVALID_BASENAMES;
    private static final Set<String> INVALID_FULLNAMES;
    private final String full;
    private final String base;
    private final String extension;

    static {
        SetFactory<Character> invalidCharactersSetFactory = SetFactory.start();
        SetFactory<String> invalidBaseNameSetFactory = SetFactory.start();
        SetFactory<String> invalidFullNameSetFactory = SetFactory.start();
        int i = 0;
        while (i <= 31) {
            invalidCharactersSetFactory.add(Character.valueOf((char)i));
            ++i;
        }
        if (WINDOWS) {
            invalidCharactersSetFactory.add(Character.valueOf('\\'));
            invalidCharactersSetFactory.add(Character.valueOf('/'));
            invalidCharactersSetFactory.add(Character.valueOf(':'));
            invalidCharactersSetFactory.add(Character.valueOf('*'));
            invalidCharactersSetFactory.add(Character.valueOf('?'));
            invalidCharactersSetFactory.add(Character.valueOf('\"'));
            invalidCharactersSetFactory.add(Character.valueOf('<'));
            invalidCharactersSetFactory.add(Character.valueOf('>'));
            invalidCharactersSetFactory.add(Character.valueOf('|'));
            invalidBaseNameSetFactory.add("aux");
            invalidBaseNameSetFactory.add("com1");
            invalidBaseNameSetFactory.add("com2");
            invalidBaseNameSetFactory.add("com3");
            invalidBaseNameSetFactory.add("com4");
            invalidBaseNameSetFactory.add("com5");
            invalidBaseNameSetFactory.add("com6");
            invalidBaseNameSetFactory.add("com7");
            invalidBaseNameSetFactory.add("com8");
            invalidBaseNameSetFactory.add("com9");
            invalidBaseNameSetFactory.add("con");
            invalidBaseNameSetFactory.add("lpt1");
            invalidBaseNameSetFactory.add("lpt2");
            invalidBaseNameSetFactory.add("lpt3");
            invalidBaseNameSetFactory.add("lpt4");
            invalidBaseNameSetFactory.add("lpt5");
            invalidBaseNameSetFactory.add("lpt6");
            invalidBaseNameSetFactory.add("lpt7");
            invalidBaseNameSetFactory.add("lpt8");
            invalidBaseNameSetFactory.add("lpt9");
            invalidBaseNameSetFactory.add("nul");
            invalidBaseNameSetFactory.add("prn");
            invalidFullNameSetFactory.add("clock$");
        } else {
            invalidCharactersSetFactory.add(Character.valueOf('/'));
        }
        INVALID_CHARACTERS = invalidCharactersSetFactory.result();
        INVALID_BASENAMES = invalidBaseNameSetFactory.result();
        INVALID_FULLNAMES = invalidFullNameSetFactory.result();
    }

    public FileName(String name) {
        if (!FileName.valid(name)) {
            throw new IllegalArgumentException(name);
        }
        this.full = name;
        int segments = 0;
        String[] stringArray = name.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (segment.trim().length() > 0 && ++segments > 1) break;
            ++n2;
        }
        if (segments == 1) {
            this.base = name;
            this.extension = null;
        } else {
            int lastDot = name.lastIndexOf(46);
            this.base = name.substring(0, lastDot);
            this.extension = name.substring(lastDot + 1);
        }
    }

    public String full() {
        return this.full;
    }

    public String base() {
        return this.base;
    }

    public String extension() {
        return this.extension;
    }

    public int hashCode() {
        return this.full.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileName) {
            return this.full.equals(((FileName)obj).full);
        }
        return false;
    }

    @Override
    public int compareTo(FileName fname) {
        return this.full.compareToIgnoreCase(fname.full);
    }

    public String toString() {
        return this.full;
    }

    public static boolean valid(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        int length = name.length();
        if (length == 0) {
            return false;
        }
        if (name.equals(".") || name.equals("..")) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (INVALID_CHARACTERS.contains(Character.valueOf(name.charAt(i)))) {
                return false;
            }
            ++i;
        }
        if (WINDOWS) {
            String basename;
            char lastChar = name.charAt(name.length() - 1);
            if (lastChar == '.' || Character.isWhitespace(lastChar)) {
                return false;
            }
            int dot = name.indexOf(46);
            String string = basename = dot == -1 ? name : name.substring(0, dot);
            if (INVALID_BASENAMES.contains(basename.toLowerCase())) {
                return false;
            }
            if (INVALID_FULLNAMES.contains(name.toLowerCase())) {
                return false;
            }
        }
        return true;
    }
}

