/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.ui.containers.custom;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntimeType;
import org.jboss.ide.eclipse.archives.webtools.filesets.Fileset;
import org.jboss.ide.eclipse.archives.webtools.filesets.FilesetComposite;
import org.jboss.ide.eclipse.as.classpath.core.runtime.path.internal.RuntimePathProviderFileset;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.tools.foundation.ui.xpl.taskwizard.IWizardHandle;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;

public class FilesetClasspathProviderFragment
extends WizardFragment
implements FilesetComposite.IFilesetCompositeErrorDisplay {
    private IWizardHandle handle;
    private FilesetComposite composite;

    public boolean hasComposite() {
        return true;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        handle.setTitle("Create a fileset classpath entry.");
        handle.setDescription("Create a new classpath fileset which can be added to all projects targeting this runtime-type");
        IRuntimeType rtt = (IRuntimeType)this.getTaskModel().getObject("rtType");
        ServerExtendedProperties props = rtt == null ? null : (ServerExtendedProperties)Platform.getAdapterManager().getAdapter((Object)rtt, ServerExtendedProperties.class);
        String defaultLocation = props == null ? "" : props.getNewClasspathFilesetDefaultRootFolder();
        Fileset fs = new Fileset();
        fs.setFolder(defaultLocation);
        fs.setIncludesPattern("**/*.jar");
        this.composite = new FilesetComposite(parent, fs, false, false);
        this.composite.setErrorDisplay((FilesetComposite.IFilesetCompositeErrorDisplay)this);
        return this.composite;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        Fileset fs = this.composite.getFileset();
        RuntimePathProviderFileset rppf = new RuntimePathProviderFileset(fs);
        this.getTaskModel().putObject("createdProvider", (Object)rppf);
    }

    public void updateError(String msg) {
        this.handle.setMessage(msg, 3);
    }
}

