/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.core.internal.dependencies;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.arquillian.core.ArquillianCoreActivator;
import org.jboss.tools.arquillian.core.internal.dependencies.DependencyType;
import org.jboss.tools.arquillian.core.internal.dependencies.DependencyVisitor;

public class DependencyCache {
    private static Map<ICompilationUnit, Set<DependencyType>> dependencies = new HashMap<ICompilationUnit, Set<DependencyType>>();

    public static Map<ICompilationUnit, Set<DependencyType>> getDependencies() {
        return dependencies;
    }

    private static void collectDependencies(ICompilationUnit unit, boolean excludeSuperclass) {
        if (unit == null || DependencyCache.getDependencies().get(unit) != null) {
            return;
        }
        CompilationUnit cu = DependencyCache.getAST(unit);
        IType primaryType = unit.findPrimaryType();
        if (primaryType == null) {
            return;
        }
        HashSet<String> excludeSet = new HashSet<String>();
        String name = primaryType.getFullyQualifiedName();
        if (excludeSuperclass) {
            try {
                IType[] superInterfaces;
                ITypeHierarchy hierarchy = primaryType.newSupertypeHierarchy(null);
                IType superclass = hierarchy.getSuperclass(primaryType);
                if (superclass != null) {
                    excludeSet.add(superclass.getFullyQualifiedName());
                }
                IType[] iTypeArray = superInterfaces = hierarchy.getAllSuperInterfaces(primaryType);
                int n = superInterfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    IType superInterface = iTypeArray[n2];
                    excludeSet.add(superInterface.getFullyQualifiedName());
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                ArquillianCoreActivator.logWarning(e.getLocalizedMessage());
            }
        }
        DependencyVisitor visitor = new DependencyVisitor(cu, name, excludeSet, unit.getJavaProject());
        cu.accept((ASTVisitor)visitor);
        DependencyCache.getDependencies().put(unit, visitor.getTypes());
        IJavaProject javaProject = unit.getJavaProject();
        for (DependencyType dependencyType : visitor.getTypes()) {
            String typeName = dependencyType.getName();
            try {
                IType type = javaProject.findType(typeName);
                if (type == null) continue;
                ICompilationUnit compilationUnit = type.getCompilationUnit();
                DependencyCache.collectDependencies(compilationUnit, false);
            }
            catch (JavaModelException e) {
                ArquillianCoreActivator.log(e);
            }
        }
    }

    public static Set<DependencyType> getDependentTypes(ICompilationUnit unit) {
        HashSet<DependencyType> types = new HashSet<DependencyType>();
        if (unit == null) {
            return types;
        }
        IJavaProject javaProject = unit.getJavaProject();
        DependencyCache.collectDependencies(unit, true);
        HashSet toVisit = new HashSet();
        toVisit.addAll(DependencyCache.getDependencies().get(unit));
        types.addAll(toVisit);
        HashSet<DependencyType> visited = new HashSet<DependencyType>();
        HashSet add = new HashSet();
        while (!toVisit.isEmpty()) {
            Iterator iter = toVisit.iterator();
            add.clear();
            while (iter.hasNext()) {
                DependencyType type = (DependencyType)iter.next();
                if (visited.contains(type)) {
                    iter.remove();
                    continue;
                }
                try {
                    ICompilationUnit cu;
                    IType javaType = javaProject.findType(type.getName());
                    if (javaType != null && (cu = javaType.getCompilationUnit()) != null && DependencyCache.getDependencies().get(cu) != null) {
                        add.addAll(DependencyCache.getDependencies().get(cu));
                        types.addAll((Collection<DependencyType>)DependencyCache.getDependencies().get(cu));
                    }
                }
                catch (JavaModelException e) {
                    ArquillianCoreActivator.log(e);
                }
                visited.add(type);
            }
            toVisit.addAll(add);
        }
        return types;
    }

    private static CompilationUnit getAST(ICompilationUnit cu) {
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setSource(cu);
        parser.setResolveBindings(true);
        parser.setKind(8);
        parser.setProject(cu.getJavaProject());
        return (CompilationUnit)parser.createAST(null);
    }

    public static void removeDependencies(IResource resource) {
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            Set<ICompilationUnit> keySet = DependencyCache.getDependencies().keySet();
            Iterator<ICompilationUnit> iter = keySet.iterator();
            while (iter.hasNext()) {
                ICompilationUnit unit = iter.next();
                if (!project.equals((Object)unit.getJavaProject().getProject())) continue;
                iter.remove();
            }
        } else if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            IJavaElement element = JavaCore.create((IFile)file);
            if (!(element instanceof ICompilationUnit)) {
                return;
            }
            ICompilationUnit unit = (ICompilationUnit)element;
            DependencyCache.getDependencies().remove(unit);
        }
    }
}

