/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.core.internal.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.ExternalFoldersManager;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.jboss.tools.arquillian.core.ArquillianCoreActivator;
import org.jboss.tools.arquillian.core.internal.ArquillianConstants;
import org.jboss.tools.arquillian.core.internal.archives.Archive;
import org.jboss.tools.arquillian.core.internal.archives.ArchiveContainer;
import org.jboss.tools.arquillian.core.internal.dependencies.DependencyCache;
import org.jboss.tools.arquillian.core.internal.dependencies.DependencyType;
import org.jboss.tools.arquillian.core.internal.dependencies.TypeLocation;
import org.jboss.tools.arquillian.core.internal.util.ArquillianSearchEngine;
import org.jboss.tools.arquillian.core.internal.util.ArquillianUtility;

public class ArquillianBuilder
extends IncrementalProjectBuilder {
    private IProject currentProject;
    static final IProject[] NO_PROJECTS = new IProject[0];

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        block14: {
            this.currentProject = this.getProject();
            if (this.currentProject == null || !this.currentProject.isAccessible()) {
                return NO_PROJECTS;
            }
            if (!this.currentProject.hasNature("org.jboss.tools.arquillian.core.arquillianNature") || this.hasErrors(this.currentProject) || !ArquillianUtility.isValidatorEnabled(this.currentProject)) {
                this.cleanupMarkers((IResource)this.currentProject);
                return NO_PROJECTS;
            }
            try {
                try {
                    if (kind == 6 || DependencyCache.getDependencies().size() == 0) {
                        this.buildAll(monitor);
                    } else {
                        IResourceDelta delta = this.getDelta(this.currentProject);
                        if (delta == null) {
                            this.buildAll(monitor);
                        } else {
                            this.buildDelta(delta, monitor);
                        }
                    }
                }
                catch (CoreException e) {
                    ArquillianCoreActivator.log(e);
                    if (monitor != null) {
                        monitor.done();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (monitor != null) {
                    monitor.done();
                }
                throw throwable;
            }
            if (monitor != null) {
                monitor.done();
            }
        }
        IProject[] requiredProjects = this.getRequiredProjects(true);
        return requiredProjects;
    }

    private void buildDelta(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        final ArrayList<ICompilationUnit> units = new ArrayList<ICompilationUnit>();
        delta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                IResource res = delta.getResource();
                switch (res.getType()) {
                    case 8: {
                        return true;
                    }
                    case 4: {
                        return true;
                    }
                    case 2: {
                        return true;
                    }
                    case 1: {
                        IJavaElement element = JavaCore.create((IResource)res);
                        ICompilationUnit cu = null;
                        if (element instanceof IClassFile) {
                            cu = this.getCompilationUnit((IClassFile)element);
                        }
                        if (element instanceof ICompilationUnit) {
                            cu = (ICompilationUnit)element;
                        }
                        if (cu != null) {
                            ArquillianBuilder.this.cleanupMarkers(cu.getUnderlyingResource());
                            if (units.contains(cu)) {
                                DependencyCache.getDependencies().remove(cu);
                                return false;
                            }
                            if (ArquillianSearchEngine.isArquillianJUnitTest(element, false, false)) {
                                units.add(cu);
                            } else {
                                Set<ICompilationUnit> cus = DependencyCache.getDependencies().keySet();
                                IType primaryType = cu == null ? null : cu.findPrimaryType();
                                String fqn = primaryType == null ? null : primaryType.getFullyQualifiedName();
                                Iterator<Object> iterator = cus.iterator();
                                HashSet<ICompilationUnit> toRemove = new HashSet<ICompilationUnit>();
                                toRemove.add(cu);
                                while (iterator.hasNext()) {
                                    ICompilationUnit unit = iterator.next();
                                    Set<DependencyType> types = DependencyCache.getDependentTypes(unit);
                                    for (DependencyType type : types) {
                                        if (type.getName() == null || !type.getName().equals(fqn)) continue;
                                        if (ArquillianSearchEngine.isArquillianJUnitTest((IJavaElement)unit, false, false)) {
                                            units.add(unit);
                                        }
                                        toRemove.add(unit);
                                    }
                                }
                                iterator = toRemove.iterator();
                                while (iterator.hasNext()) {
                                    DependencyCache.getDependencies().remove(iterator.next());
                                }
                            }
                        }
                        return false;
                    }
                }
                return false;
            }

            public ICompilationUnit getCompilationUnit(IClassFile classFile) {
                char[] className;
                IClassFileReader classFileReader = ToolFactory.createDefaultClassFileReader((IClassFile)classFile, (int)17);
                if (classFileReader != null && (className = classFileReader.getClassName()) != null) {
                    String fqn = new String(classFileReader.getClassName()).replace("/", ".");
                    IJavaProject javaProject = classFile.getJavaProject();
                    IType sourceType = null;
                    try {
                        sourceType = javaProject.findType(fqn);
                        if (sourceType != null) {
                            return sourceType.getCompilationUnit();
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
                return null;
            }
        });
        if (units.size() > 0) {
            ArquillianCoreActivator.getDefault().removeProjectLoader(this.currentProject);
            this.build(units, monitor);
        }
    }

    public void checkCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void buildAll(IProgressMonitor monitor) throws CoreException {
        this.checkCancel(monitor);
        this.cleanProject();
        List<ICompilationUnit> units = this.getCompilationUnits();
        this.build(units, monitor);
    }

    public void cleanProject() {
        DependencyCache.removeDependencies((IResource)this.currentProject);
        ArchiveContainer.remove((IResource)this.currentProject);
        ArquillianCoreActivator.getDefault().removeProjectLoader(this.currentProject);
    }

    private void build(List<ICompilationUnit> units, IProgressMonitor monitor) throws JavaModelException {
        IProject project = this.currentProject;
        Iterator<ICompilationUnit> iterator = units.iterator();
        monitor.beginTask("Arquillian validator", units.size());
        while (iterator.hasNext()) {
            Integer severity;
            ICompilationUnit unit = iterator.next();
            this.checkCancel(monitor);
            if (unit == null || !(unit.getUnderlyingResource() instanceof IFile) || unit.findPrimaryType() == null) continue;
            if (monitor != null) {
                monitor.subTask("Validating " + unit.getElementName());
                monitor.worked(1);
            }
            this.cleanupMarkers(unit.getUnderlyingResource());
            this.checkCancel(monitor);
            IType primaryType = unit.findPrimaryType();
            String preference = ArquillianUtility.getPreference("org.jboss.tools.arquillian.core.missingDeploymentMethod", project);
            if (!"ignore".equals(preference) && !ArquillianSearchEngine.hasDeploymentMethod(primaryType)) {
                try {
                    severity = ArquillianUtility.getSeverity(preference);
                    this.storeProblem(unit, "Arquillian test requires at least one method annotated with @Deployment", severity, "org.jboss.tools.arquillian.core.problem.missingDeploymentMethod");
                }
                catch (CoreException e) {
                    ArquillianCoreActivator.log(e);
                }
            }
            this.checkCancel(monitor);
            preference = ArquillianUtility.getPreference("org.jboss.tools.arquillian.core.missingTestMethod", project.getProject());
            if (!"ignore".equals(preference) && !ArquillianSearchEngine.hasTestMethod(primaryType)) {
                try {
                    severity = ArquillianUtility.getSeverity(preference);
                    this.storeProblem(unit, "Arquillian test requires at least one method annotated with @Test", severity);
                }
                catch (CoreException e) {
                    ArquillianCoreActivator.log(e);
                }
            }
            this.checkCancel(monitor);
            preference = ArquillianUtility.getPreference("org.jboss.tools.arquillian.core.invalidArchiveName", project.getProject());
            if (!"ignore".equals(preference)) {
                try {
                    severity = ArquillianUtility.getSeverity(preference);
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    this.validateArchiveName(unit, javaProject, severity);
                }
                catch (CoreException e) {
                    ArquillianCoreActivator.log(e);
                }
            }
            this.checkCancel(monitor);
            preference = ArquillianUtility.getPreference("org.jboss.tools.arquillian.core.typeIsNotIncludedInAnyDeployment", project.getProject());
            if ("ignore".equals(preference)) continue;
            DependencyCache.getDependencies().remove(unit);
            ArchiveContainer.remove(unit.getUnderlyingResource());
            List<Archive> archives = ArquillianSearchEngine.getDeploymentArchives(primaryType, true);
            if (archives == null) continue;
            Set<DependencyType> dependencies = DependencyCache.getDependentTypes(unit);
            Integer severity2 = ArquillianUtility.getSeverity(preference);
            this.checkCancel(monitor);
            Set<DependencyType> unitDependencies = DependencyCache.getDependencies().get(unit);
            for (DependencyType type : dependencies) {
                String message;
                boolean direct;
                this.checkCancel(monitor);
                if (this.getDeployment(type, archives)) continue;
                this.checkCancel(monitor);
                boolean bl = direct = unitDependencies != null && unitDependencies.contains(type);
                if (direct) {
                    message = "The " + type.getName() + " type is not included in any deployment.";
                    for (TypeLocation location : type.getLocations()) {
                        try {
                            IMarker marker = this.storeProblem(unit, message, severity2, "org.jboss.tools.arquillian.core.problem.class");
                            if (marker == null) continue;
                            marker.setAttribute("charStart", location.getCharStart());
                            marker.setAttribute("charEnd", location.getCharEnd());
                            marker.setAttribute("lineNumber", location.getLineNumber());
                            marker.setAttribute("markerClassName", (Object)type.getName());
                        }
                        catch (CoreException e) {
                            ArquillianCoreActivator.log(e);
                        }
                    }
                    continue;
                }
                message = "The " + type.getName() + " type is not included in any deployment. It is indirectly referenced from required .class files";
                try {
                    IMarker marker = this.storeProblem(unit, message, severity2, "org.jboss.tools.arquillian.core.problem.class");
                    if (marker == null) continue;
                    marker.setAttribute("charStart", 0);
                    marker.setAttribute("charEnd", 0);
                    marker.setAttribute("lineNumber", 0);
                    marker.setAttribute("markerClassName", (Object)type.getName());
                }
                catch (CoreException e) {
                    ArquillianCoreActivator.log(e);
                }
            }
        }
    }

    private boolean getDeployment(DependencyType type, List<Archive> archives) {
        if (type == null || archives == null || archives.size() <= 0) {
            return false;
        }
        for (Archive archive : archives) {
            String name = type.getName();
            if (name == null || archive == null) {
                return false;
            }
            archive.getChildren();
            if (!archive.getFullyQuallifiedNames().contains(name)) continue;
            return true;
        }
        return false;
    }

    private List<ICompilationUnit> getCompilationUnits() throws JavaModelException {
        ArrayList<ICompilationUnit> units = new ArrayList<ICompilationUnit>();
        IJavaProject javaProject = JavaCore.create((IProject)this.currentProject);
        if (ArquillianSearchEngine.hasArquillianType(javaProject)) {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    IPackageFragmentRoot[] roots;
                    IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.findPackageFragmentRoots(entry);
                    int n3 = roots.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                        if (!root.isArchive()) {
                            IJavaElement[] children;
                            IJavaElement[] iJavaElementArray = children = root.getChildren();
                            int n5 = children.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IJavaElement child = iJavaElementArray[n6];
                                if (child instanceof IPackageFragment) {
                                    ICompilationUnit[] cus;
                                    IPackageFragment packageFragment = (IPackageFragment)child;
                                    ICompilationUnit[] iCompilationUnitArray = cus = packageFragment.getCompilationUnits();
                                    int n7 = cus.length;
                                    int n8 = 0;
                                    while (n8 < n7) {
                                        ICompilationUnit cu = iCompilationUnitArray[n8];
                                        if (!units.contains(cu) && ArquillianSearchEngine.isArquillianJUnitTest((IJavaElement)cu, false, false)) {
                                            units.add(cu);
                                        }
                                        ++n8;
                                    }
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return units;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasErrors(IProject project) {
        try {
            IMarker[] markers = project.findMarkers("org.eclipse.jdt.core.buildpath_problem", true, 2);
            if (markers != null && markers.length > 0) {
                return true;
            }
            IMarker[] iMarkerArray = markers = project.findMarkers("org.eclipse.jdt.core.problem", true, 2);
            int n = markers.length;
            int n2 = 0;
            while (true) {
                Integer id;
                Object object;
                if (n2 >= n) {
                    return false;
                }
                IMarker marker = iMarkerArray[n2];
                if (marker != null && marker.getAttribute("severity", 2) == 2 && (object = marker.getAttribute("id")) instanceof Integer && (id = (Integer)object) == 0x10000181) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            ArquillianCoreActivator.log(e);
            return true;
        }
    }

    private void cleanupMarkers(IResource resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.deleteMarkers("org.jboss.tools.arquillian.core.problem.class", false, 2);
            resource.deleteMarkers("org.jboss.tools.arquillian.core.problem.resource", false, 2);
            resource.deleteMarkers("org.jboss.tools.arquillian.core.problem.missingDeploymentMethod", false, 2);
            resource.deleteMarkers("org.jboss.tools.arquillian.core.problem.invalidArchiveName", false, 2);
        }
        catch (CoreException e) {
            ArquillianCoreActivator.log(e);
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.currentProject = this.getProject();
        if (this.currentProject == null || !this.currentProject.isAccessible()) {
            return;
        }
        this.cleanupMarkers((IResource)this.currentProject);
        this.cleanProject();
    }

    private IProject[] getRequiredProjects(boolean includeBinaryPrerequisites) {
        JavaProject javaProject = (JavaProject)JavaCore.create((IProject)this.currentProject);
        IWorkspaceRoot workspaceRoot = this.currentProject.getWorkspace().getRoot();
        if (javaProject == null || workspaceRoot == null) {
            return NO_PROJECTS;
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        ExternalFoldersManager externalFoldersManager = JavaModelManager.getExternalManager();
        try {
            IClasspathEntry[] entries = javaProject.getExpandedClasspath();
            int i = 0;
            int l = entries.length;
            while (i < l) {
                IClasspathEntry entry = entries[i];
                IPath path = entry.getPath();
                IProject p = null;
                switch (entry.getEntryKind()) {
                    case 2: {
                        p = workspaceRoot.getProject(path.lastSegment());
                        if (!((ClasspathEntry)entry).isOptional() || JavaProject.hasJavaNature((IProject)p)) break;
                        p = null;
                        break;
                    }
                    case 1: {
                        if (!includeBinaryPrerequisites || path.segmentCount() <= 0) break;
                        IResource resource = workspaceRoot.findMember(path.segment(0));
                        if (resource instanceof IProject) {
                            p = (IProject)resource;
                            break;
                        }
                        resource = externalFoldersManager.getFolder(path);
                        if (resource == null) break;
                        p = resource.getProject();
                    }
                }
                if (p != null && !projects.contains(p)) {
                    projects.add(p);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            return NO_PROJECTS;
        }
        IProject[] result = new IProject[projects.size()];
        projects.toArray(result);
        return result;
    }

    private void storeProblem(ICompilationUnit unit, String message, Integer severity) throws CoreException {
        this.storeProblem(unit, message, severity, "org.jboss.tools.arquillian.core.problem.class");
    }

    private IMarker storeProblem(ICompilationUnit unit, String message, Integer severity, String type) throws CoreException {
        IType javaElement;
        ISourceRange range;
        Object[] allValues;
        String[] allNames;
        IMarker marker;
        block6: {
            String[] attributeNames;
            if (severity == null || unit == null || unit.getUnderlyingResource() == null) {
                return null;
            }
            marker = unit.getUnderlyingResource().createMarker(type);
            allNames = attributeNames = ArquillianConstants.ARQUILLIAN_PROBLEM_MARKER_ATTRIBUTE_NAMES;
            allValues = new Object[allNames.length];
            int index = 0;
            StringBuffer sb = new StringBuffer();
            sb.append("Arquillian: ");
            sb.append(message);
            allValues[index++] = sb.toString();
            allValues[index++] = severity;
            range = null;
            javaElement = unit.findPrimaryType();
            if (javaElement != null) {
                try {
                    range = javaElement.getNameRange();
                }
                catch (JavaModelException e) {
                    if (e.getJavaModelStatus().getCode() != 969) {
                        throw e;
                    }
                    if (CharOperation.equals((char[])javaElement.getElementName().toCharArray(), (char[])TypeConstants.PACKAGE_INFO_NAME)) break block6;
                    throw e;
                }
            }
        }
        int start = range == null ? 0 : range.getOffset();
        int end = range == null ? 1 : start + range.getLength();
        allValues[index++] = new Integer(1);
        allValues[index++] = new Integer(start);
        allValues[index++] = new Integer(end > 0 ? end + 1 : end);
        allValues[index++] = new Integer(40);
        allValues[index++] = ArquillianConstants.SOURCE_ID;
        if (javaElement != null) {
            allValues[index++] = javaElement.getFullyQualifiedName();
        }
        marker.setAttributes(allNames, allValues);
        return marker;
    }

    private CompilationUnit getAST(ICompilationUnit unit, IJavaProject project) {
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setSource(unit);
        parser.setResolveBindings(true);
        parser.setKind(8);
        parser.setProject(project);
        return (CompilationUnit)parser.createAST(null);
    }

    private void validateArchiveName(final ICompilationUnit unit, IJavaProject project, final Integer severity) throws CoreException {
        CompilationUnit rootAst = this.getAST(unit, project);
        final ArrayList deploymentMethods = new ArrayList();
        final CompilationUnit root = rootAst;
        rootAst.accept(new ASTVisitor(){

            public boolean visit(MethodDeclaration node) {
                IMethodBinding binding = node.resolveBinding();
                if (ArquillianSearchEngine.isDeploymentMethod(binding)) {
                    deploymentMethods.add(node);
                }
                return false;
            }
        });
        for (MethodDeclaration methodDeclaration : deploymentMethods) {
            methodDeclaration.accept(new ASTVisitor(){

                public boolean visit(MethodInvocation node) {
                    ITypeBinding archiveType;
                    IMethodBinding binding;
                    ITypeBinding[] types;
                    boolean isCreateMethod = false;
                    StringLiteral archiveName = null;
                    if (node.getName() != null && "create".equals(node.getName().getIdentifier())) {
                        Expression expression;
                        Object o;
                        List arguments = node.arguments();
                        if (arguments.size() == 2 && (o = arguments.get(1)) instanceof StringLiteral) {
                            archiveName = (StringLiteral)o;
                        }
                        if ((expression = node.getExpression()) instanceof SimpleName && "ShrinkWrap".equals(((SimpleName)expression).getIdentifier())) {
                            isCreateMethod = true;
                        }
                        if (expression instanceof QualifiedName && "org.jboss.shrinkwrap.api.ShrinkWrap".equals(((QualifiedName)expression).getName().getIdentifier())) {
                            isCreateMethod = true;
                        }
                    }
                    if (isCreateMethod && archiveName != null && (types = (binding = node.resolveMethodBinding()).getParameterTypes()).length == 2 && (archiveType = types[0]).isClass()) {
                        String extension = null;
                        ITypeBinding[] typeArguments = archiveType.getTypeArguments();
                        if (typeArguments.length == 1) {
                            ITypeBinding typeArgument = typeArguments[0];
                            if ("org.jboss.shrinkwrap.api.spec.WebArchive".equals(typeArgument.getBinaryName())) {
                                extension = ".war";
                            }
                            if ("org.jboss.shrinkwrap.api.spec.JavaArchive".equals(typeArgument.getBinaryName())) {
                                extension = ".jar";
                            }
                            if ("org.jboss.shrinkwrap.api.spec.EnterpriseArchive".equals(typeArgument.getBinaryName())) {
                                extension = ".ear";
                            }
                            if ("org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive".equals(typeArgument.getBinaryName())) {
                                extension = ".rar";
                            }
                        }
                        String value = archiveName.getLiteralValue();
                        if (!(extension == null || value == null || value.endsWith(extension) && value.trim().length() > 4)) {
                            try {
                                IMarker marker = ArquillianBuilder.this.storeProblem(unit, "Archive name is invalid. A name with the " + extension + " extension is expected.", severity, "org.jboss.tools.arquillian.core.problem.invalidArchiveName");
                                if (marker != null) {
                                    int start = archiveName.getStartPosition();
                                    int end = start + archiveName.getLength();
                                    int lineNumber = root.getLineNumber(start);
                                    marker.setAttribute("charStart", start + 1);
                                    marker.setAttribute("charEnd", end - 1);
                                    marker.setAttribute("lineNumber", lineNumber);
                                    marker.setAttribute("oldArchiveName", (Object)value);
                                    marker.setAttribute("archiveExtension", (Object)extension);
                                }
                            }
                            catch (CoreException e) {
                                ArquillianCoreActivator.log(e);
                            }
                        }
                    }
                    return true;
                }
            });
        }
    }
}

