/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.jboss.tools.common.core.CommonCorePlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class HttpUtil {
    private static IProxyService proxyService;

    public static InputStream getInputStreamFromUrlByGetMethod(String url) throws IOException {
        return HttpUtil.getInputStreamFromUrlByGetMethod(url, false);
    }

    public static InputStream getInputStreamFromUrlByGetMethod(String url, boolean checkStatusCode) throws IOException {
        InputStream is = null;
        GetMethod method = HttpUtil.executeGetMethod(url);
        if (!checkStatusCode || method.getStatusCode() == 200) {
            is = method.getResponseBodyAsStream();
        }
        return is;
    }

    public static InputStream getInputStreamFromUrlByGetMethod(String url, IProxyService proxyService) throws IOException {
        InputStream is = HttpUtil.executeGetMethod(url, proxyService).getResponseBodyAsStream();
        return is;
    }

    public static int getStatusCodeFromUrlByGetMethod(String url, IProxyService proxyService) throws IOException {
        int code = HttpUtil.executeGetMethod(url, proxyService).getStatusCode();
        return code;
    }

    public static int getStatusCodeFromUrlByGetMethod(String url) throws IOException {
        int code = HttpUtil.executeGetMethod(url).getStatusCode();
        return code;
    }

    public static InputStream getInputStreamFromUrlByPostMethod(String url) throws IOException {
        InputStream is = HttpUtil.executePostMethod(url).getResponseBodyAsStream();
        return is;
    }

    public static int getStatusCodeFromUrlByPostMethod(String url, IProxyService proxyService) throws IOException {
        int code = HttpUtil.executePostMethod(url, proxyService).getStatusCode();
        return code;
    }

    public static int getStatusCodeFromUrlByPostMethod(String url) throws IOException {
        int code = HttpUtil.executePostMethod(url).getStatusCode();
        return code;
    }

    private static GetMethod executeGetMethod(String url) throws IOException {
        IProxyService proxyService = HttpUtil.getProxyService();
        return HttpUtil.executeGetMethod(url, proxyService);
    }

    private static PostMethod executePostMethod(String url) throws IOException {
        IProxyService proxyService = HttpUtil.getProxyService();
        return HttpUtil.executePostMethod(url, proxyService);
    }

    public static GetMethod executeGetMethod(String url, IProxyService proxyService) throws IOException {
        GetMethod httpGet = new GetMethod(url);
        HttpClient httpClient = HttpUtil.createHttpClient(url, proxyService);
        httpClient.executeMethod((HttpMethod)httpGet);
        return httpGet;
    }

    private static PostMethod executePostMethod(String url, IProxyService proxyService) throws IOException {
        PostMethod httpPost = new PostMethod(url);
        HttpClient httpClient = HttpUtil.createHttpClient(url, proxyService);
        httpClient.executeMethod((HttpMethod)httpPost);
        return httpPost;
    }

    public static HttpClient createHttpClient(String url) throws IOException {
        return HttpUtil.createHttpClient(url, HttpUtil.getProxyService());
    }

    public static HttpClient createHttpClient(String url, int connectionTimeout) throws IOException {
        return HttpUtil.createHttpClient(url, HttpUtil.getProxyService(), connectionTimeout);
    }

    private static HttpClient createHttpClient(String url, IProxyService proxyService) throws IOException {
        return HttpUtil.createHttpClient(url, proxyService, 30000);
    }

    private static HttpClient createHttpClient(String url, IProxyService proxyService, int connectionTimeout) throws IOException {
        HttpClient httpClient = new HttpClient();
        if (proxyService.isProxiesEnabled()) {
            IProxyData[] proxyData = proxyService.getProxyData();
            URL netUrl = new URL(url);
            String hostName = netUrl.getHost();
            String[] nonProxiedHosts = proxyService.getNonProxiedHosts();
            boolean nonProxiedHost = false;
            int i = 0;
            while (i < nonProxiedHosts.length) {
                String nonProxiedHostName = nonProxiedHosts[i];
                if (nonProxiedHostName.equalsIgnoreCase(hostName)) {
                    nonProxiedHost = true;
                    break;
                }
                ++i;
            }
            if (!nonProxiedHost) {
                i = 0;
                while (i < proxyData.length) {
                    IProxyData proxy = proxyData[i];
                    if ("HTTP".equals(proxy.getType())) {
                        String userName;
                        String proxyHostName = proxy.getHost();
                        if (proxyHostName == null) break;
                        int portNumber = proxy.getPort();
                        if (portNumber == -1) {
                            portNumber = 80;
                        }
                        httpClient.getHostConfiguration().setProxy(proxyHostName, portNumber);
                        if (!proxy.isRequiresAuthentication() || (userName = proxy.getUserId()) == null) break;
                        String password = proxy.getPassword();
                        httpClient.getState().setProxyCredentials(new AuthScope(null, -1, null, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials(userName, password));
                        break;
                    }
                    ++i;
                }
            }
        }
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(connectionTimeout);
        return httpClient;
    }

    private static IProxyService getProxyService() {
        if (proxyService == null) {
            BundleContext bundleContext = CommonCorePlugin.getInstance().getBundle().getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(IProxyService.class.getName());
            proxyService = (IProxyService)bundleContext.getService(serviceReference);
        }
        return proxyService;
    }
}

