/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.sapphire.Color;
import org.eclipse.sapphire.ui.LineStyle;
import org.eclipse.sapphire.ui.diagram.shape.def.SelectionPresentation;
import org.eclipse.sapphire.ui.swt.gef.figures.FigureUtil;
import org.eclipse.sapphire.ui.swt.gef.figures.IShapeFigure;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.parts.ShapeEditPart;
import org.eclipse.sapphire.ui.swt.gef.utils.SapphireSurroundingHandle;

public class ShapeSelectionEditPolicy
extends NonResizableEditPolicy {
    private IShapeFigure getShapeFigure() {
        ShapeEditPart part;
        if (this.getHost() instanceof ShapeEditPart && (part = (ShapeEditPart)this.getHost()).getFigure() instanceof IShapeFigure) {
            return (IShapeFigure)part.getFigure();
        }
        return null;
    }

    protected List<?> createSelectionHandles() {
        ArrayList<SapphireSurroundingHandle> list = new ArrayList<SapphireSurroundingHandle>();
        GraphicalEditPart owner = (GraphicalEditPart)this.getHost();
        ShapeEditPart shapeEditPart = (ShapeEditPart)owner;
        SelectionPresentation selectionPresentation = shapeEditPart.getShapePresentation().getSelectionPresentation();
        DiagramResourceCache resourceCache = shapeEditPart.getNodeEditPart().getCastedModel().getDiagramModel().getResourceCache();
        SapphireSurroundingHandle selectionHandle = new SapphireSurroundingHandle(owner, shapeEditPart.getConfigurationManager(), resourceCache, this.isDragAllowed());
        if (selectionPresentation != null) {
            selectionHandle.setLineOffset((Integer)selectionPresentation.getOffset().content());
            selectionHandle.setLineWidth((Integer)selectionPresentation.getWeight().content());
            selectionHandle.setLineStyle(FigureUtil.convertLineStyle((LineStyle)selectionPresentation.getStyle().content()));
            selectionHandle.setLineColor((Color)selectionPresentation.getColor().content());
        }
        list.add(selectionHandle);
        return list;
    }

    protected void hideFocus() {
        IShapeFigure f = this.getShapeFigure();
        if (f != null) {
            f.setFocus(false);
        }
    }

    protected void hideSelection() {
        IShapeFigure f = this.getShapeFigure();
        if (f != null) {
            f.setSelected(false);
            f.setFocus(false);
            this.removeSelectionHandles();
        }
    }

    protected void showFocus() {
        IShapeFigure f = this.getShapeFigure();
        if (f != null) {
            f.setFocus(true);
        }
    }

    protected void showPrimarySelection() {
        IShapeFigure f = this.getShapeFigure();
        if (f != null) {
            f.setSelected(true);
            f.setFocus(true);
            this.addSelectionHandles();
        }
    }

    protected void showSelection() {
        IShapeFigure f = this.getShapeFigure();
        if (f != null) {
            f.setSelected(true);
            f.setFocus(false);
            this.addSelectionHandles();
        }
    }
}

