/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.internal;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.forms.swt.ActionBridge;
import org.eclipse.sapphire.ui.forms.swt.ActionHandlerBridge;
import org.eclipse.sapphire.ui.forms.swt.ActionSystemPartBridge;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramConnectionEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramConnectionLabelEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramNodeEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.SapphireDiagramEditorPageEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.ShapeEditPart;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPresentation;

public final class DiagramEditorContextMenuProvider
extends ContextMenuProvider {
    private static final String DIAGRAM_NODE_DEFAULT_ACTION = "Sapphire.Diagram.Node.Default";
    private static final String DIAGRAM_DEFAULT_GROUP = "Diagram.Default";
    private static final String DIAGRAM_DELETE_ALL_BEND_POINTS = "Sapphire.Diagram.DeleteAllBendPoints";
    private SapphireDiagramEditor editor;
    private Map<SapphireActionSystemPart, ActionSystemPartBridge> cache = Collections.emptyMap();

    public DiagramEditorContextMenuProvider(SapphireDiagramEditor editor) {
        super((EditPartViewer)editor.getGraphicalViewer());
        this.editor = editor;
    }

    public void buildContextMenu(IMenuManager menuManager) {
        SapphireDiagramEditorPagePart part;
        DiagramPresentation presentation;
        String context;
        List<GraphicalEditPart> selection = this.editor.getSelectedEditParts();
        if (selection.size() == 1) {
            GraphicalEditPart editPart = selection.get(0);
            if (editPart instanceof SapphireDiagramEditorPageEditPart) {
                context = "Sapphire.Diagram.Editor";
                presentation = ((SapphireDiagramEditorPageEditPart)editPart).getPresentation();
            } else if (editPart instanceof DiagramNodeEditPart) {
                context = "Sapphire.Diagram.Node";
                presentation = ((DiagramNodeEditPart)editPart).getPresentation();
            } else if (editPart instanceof ShapeEditPart) {
                context = "Sapphire.Diagram.Node.Shape";
                presentation = ((ShapeEditPart)editPart).getShapePresentation();
            } else if (editPart instanceof DiagramConnectionEditPart) {
                context = "Sapphire.Diagram.Connection";
                presentation = ((DiagramConnectionEditPart)editPart).getPresentation();
            } else {
                if (editPart instanceof DiagramConnectionLabelEditPart) {
                    return;
                }
                throw new IllegalStateException();
            }
            part = presentation.part();
        } else if (selection.size() > 1) {
            presentation = this.editor.getDiagramPresentation();
            part = this.editor.getPart();
            context = "Sapphire.Diagram.MultipleParts";
        } else {
            throw new IllegalStateException();
        }
        IdentityHashMap<SapphireActionSystemPart, ActionSystemPartBridge> updatedCache = new IdentityHashMap<SapphireActionSystemPart, ActionSystemPartBridge>();
        String currentGroupId = null;
        for (SapphireAction sapphireAction : part.getActions(context).getActions()) {
            List handlers;
            int count;
            if (sapphireAction.getId().equals(DIAGRAM_NODE_DEFAULT_ACTION) || this.skipMultipleConnectionAction(this.editor.getSelectedParts(), context, sapphireAction)) continue;
            String groupId = sapphireAction.getGroup();
            if (currentGroupId != null && groupId == null || currentGroupId == null && groupId != null || currentGroupId != null && groupId != null && !currentGroupId.equals(groupId)) {
                currentGroupId = groupId;
                menuManager.add((IContributionItem)new Separator(currentGroupId == null ? DIAGRAM_DEFAULT_GROUP : currentGroupId));
            }
            if ((count = (handlers = sapphireAction.getActiveHandlers()).size()) == 1) {
                ActionSystemPartBridge bridge = this.cache.get(sapphireAction);
                if (bridge == null) {
                    bridge = new ActionBridge((Presentation)presentation, sapphireAction);
                }
                updatedCache.put((SapphireActionSystemPart)sapphireAction, bridge);
                menuManager.add((IAction)bridge);
                continue;
            }
            if (count <= 1) continue;
            String childMenuText = LabelTransformer.transform((String)sapphireAction.getLabel(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)true);
            ImageDescriptor childMenuImage = SwtUtil.toImageDescriptor((ImageData)sapphireAction.getImage(16));
            MenuManager childMenuManager = new MenuManager(childMenuText, childMenuImage, sapphireAction.getId());
            childMenuManager.setParent((IContributionManager)menuManager);
            menuManager.add((IContributionItem)childMenuManager);
            for (SapphireActionHandler handler : sapphireAction.getActiveHandlers()) {
                ActionSystemPartBridge bridge = this.cache.get(handler);
                if (bridge == null) {
                    bridge = new ActionHandlerBridge((Presentation)presentation, handler);
                }
                updatedCache.put((SapphireActionSystemPart)handler, bridge);
                childMenuManager.add((IAction)bridge);
            }
        }
        for (Map.Entry entry : this.cache.entrySet()) {
            if (updatedCache.containsKey(entry.getKey())) continue;
            ((ActionSystemPartBridge)entry.getValue()).dispose();
        }
        this.cache = updatedCache;
    }

    private boolean skipMultipleConnectionAction(List<ISapphirePart> selection, String context, SapphireAction action) {
        if ("Sapphire.Diagram.MultipleParts".equals(context) && DIAGRAM_DELETE_ALL_BEND_POINTS.equals(action.getId())) {
            for (ISapphirePart part : selection) {
                if (!(part instanceof DiagramConnectionPart)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        super.dispose();
        for (ActionSystemPartBridge bridge : this.cache.values()) {
            bridge.dispose();
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        super.menuAboutToShow(menu);
        this.editor.getContextButtonManager().hideContextButtonsInstantly();
    }
}

