/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.server.controllable.subsystems.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.exports.PluginExportOperation;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.publishers.PublishUtil;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPrimaryPublishController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishControllerDelegate;

public class OSGiPublishController
extends AbstractSubsystemController
implements IPublishControllerDelegate {
    protected IStatus scheduleExportJob(IProject project, String destFolder, String name, IProgressMonitor monitor) {
        FeatureExportInfo info = new FeatureExportInfo();
        info.toDirectory = true;
        info.useJarFormat = true;
        info.exportSource = false;
        info.exportSourceBundle = true;
        info.allowBinaryCycles = true;
        info.useWorkspaceCompiledClasses = false;
        info.destinationDirectory = destFolder;
        info.zipFileName = name;
        info.items = new Object[]{PluginRegistry.findModel((IProject)project)};
        info.signingInfo = null;
        info.qualifier = null;
        CustomPluginExportOperation job = new CustomPluginExportOperation(info, "Exporting Plugin: " + project.getName());
        IStatus s = job.run2(monitor);
        return s;
    }

    private IPath getMetadataTemporaryLocation(IServer server) {
        IPath deployRoot = JBossServerCorePlugin.getServerStateLocation(server).append("tempRemoteDeploy").makeAbsolute();
        deployRoot.toFile().mkdirs();
        return deployRoot;
    }

    public int publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        String[] plugins;
        IDeployableServer server2 = ServerConverter.getDeployableServer((IServerAttributes)this.getServer());
        IPath metadataLoc = this.getMetadataTemporaryLocation(this.getServer());
        if (metadataLoc.toFile().exists()) {
            metadataLoc.toFile().mkdirs();
        }
        IPath presumedSourcePath = PublishUtil.getModuleNestedDeployPath(module, metadataLoc.toOSString(), server2);
        String name = presumedSourcePath.lastSegment();
        IPath realSourcePathFolder = presumedSourcePath.removeLastSegments(1).append("plugins");
        IProject project = module[module.length - 1].getProject();
        IStatus result = this.scheduleExportJob(project, metadataLoc.toOSString(), name, monitor);
        if (result.isOK() && (plugins = realSourcePathFolder.toFile().list()).length > 0) {
            IPath src = realSourcePathFolder.append(plugins[0]);
            int ret = this.transferBuiltModule(module, src, monitor);
            src.toFile().delete();
            return ret;
        }
        return 0;
    }

    private int transferBuiltModule(IModule[] module, IPath srcFile, IProgressMonitor monitor) throws CoreException {
        IPublishController pc;
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)this.getServer());
        if (beh != null && (pc = (IPublishController)beh.getController("publish")) instanceof IPrimaryPublishController) {
            return ((IPrimaryPublishController)pc).transferBuiltModule(module, srcFile, monitor);
        }
        return 0;
    }

    private class CustomPluginExportOperation
    extends PluginExportOperation {
        public CustomPluginExportOperation(FeatureExportInfo info, String name) {
            super(info, name);
        }

        public IStatus run2(IProgressMonitor monitor) {
            return super.run(monitor);
        }
    }
}

