/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.launch.configuration;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.launch.configuration.AbstractStartLaunchConfigurator;
import org.jboss.ide.eclipse.as.core.util.LaunchCommandPreferences;
import org.jboss.ide.eclipse.as.core.util.LaunchConfigUtils;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;

public class LocalJBossStartLaunchConfigurator
extends AbstractStartLaunchConfigurator {
    public LocalJBossStartLaunchConfigurator(IServer server) throws CoreException {
        super(server);
    }

    @Override
    protected String getMainType() {
        return "org.jboss.Main";
    }

    @Override
    protected String getWorkingDirectory() throws CoreException {
        return String.valueOf(ServerUtil.checkedGetServerHome(this.getJBossServer())) + '/' + "bin";
    }

    @Override
    protected List<String> getClasspath(List<String> currentClasspath) throws CoreException {
        try {
            String jreEntry;
            boolean replaced = this.replaceRunJarContainer(this.getJBossServer(), currentClasspath);
            if (!replaced) {
                String runJarEntry = LaunchConfigUtils.getRunJarRuntimeCPEntry(this.server).getMemento();
                currentClasspath.add(runJarEntry);
            }
            IVMInstall vmInstall = this.getJBossRuntime().getVM();
            ArrayList<IRuntimeClasspathEntry> classpath = new ArrayList<IRuntimeClasspathEntry>();
            LaunchConfigUtils.addJREEntry(vmInstall, classpath);
            List<String> runtimeClassPaths = LaunchConfigUtils.toStrings(classpath);
            if (runtimeClassPaths != null && runtimeClassPaths.size() == 1 && !currentClasspath.contains(jreEntry = runtimeClassPaths.get(0))) {
                currentClasspath.add(jreEntry);
            }
            return currentClasspath;
        }
        catch (CoreException coreException) {
            return currentClasspath;
        }
    }

    private boolean replaceRunJarContainer(JBossServer server, List<String> classpath) throws CoreException {
        boolean replaced = false;
        int i = 0;
        while (i < classpath.size()) {
            String classPathEntry = classpath.get(0);
            if (classPathEntry.contains("org.jboss.ide.eclipse.as.core.server.launch.runJarContainer")) {
                replaced = true;
                classpath.set(i, LaunchConfigUtils.getRunJarRuntimeCPEntry(server.getServer()).getMemento());
            }
            ++i;
        }
        return replaced;
    }

    @Override
    protected String getHost(JBossServer server, IJBossServerRuntime runtime) {
        if (LaunchCommandPreferences.listensOnAllHosts((IServerAttributes)server.getServer())) {
            return "0.0.0.0";
        }
        return server.getHost();
    }

    @Override
    protected String getServerHome(IJBossServerRuntime runtime) {
        try {
            return runtime.getConfigLocationFullPath().toFile().toURI().toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    protected String getServerConfig(IJBossServerRuntime runtime) {
        return runtime.getJBossConfiguration();
    }

    @Override
    protected String getEndorsedDir(IJBossServerRuntime runtime) {
        return runtime.getRuntime().getLocation().append("lib").append("endorsed").toOSString();
    }

    @Override
    protected String getDefaultProgramArguments() {
        return this.getExtendedProperties().getDefaultLaunchArguments().getStartDefaultProgramArgs();
    }

    @Override
    protected String getDefaultVMArguments(IJBossServerRuntime runtime) {
        return this.getExtendedProperties().getDefaultLaunchArguments().getStartDefaultVMArgs();
    }

    @Override
    protected String getJavaLibraryPath(IJBossServerRuntime runtime) {
        IPath serverHome = runtime.getRuntime().getLocation();
        IPath p = serverHome.append("bin").append("native");
        if (p.toFile().exists()) {
            return p.toString();
        }
        return null;
    }
}

