/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.launch;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.StandardClasspathProvider;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.server.internal.AbstractLocalJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.launch.configuration.JBossLaunchConfigProperties;
import org.jboss.ide.eclipse.as.core.util.LaunchConfigUtils;

public class JBossServerDefaultClasspathProvider
extends StandardClasspathProvider {
    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        if (new JBossLaunchConfigProperties().isUseDefaultClasspath(configuration)) {
            return this.defaultEntries(configuration);
        }
        return super.computeUnresolvedClasspath(configuration);
    }

    protected IRuntimeClasspathEntry[] defaultEntries(ILaunchConfiguration config) {
        try {
            String server = new JBossLaunchConfigProperties().getServerId(config);
            IServer s = ServerCore.findServer((String)server);
            AbstractLocalJBossServerRuntime ibjsrt = (AbstractLocalJBossServerRuntime)((Object)s.getRuntime().loadAdapter(AbstractLocalJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor()));
            IVMInstall install = ibjsrt.getVM();
            ArrayList<IRuntimeClasspathEntry> list = new ArrayList<IRuntimeClasspathEntry>();
            LaunchConfigUtils.addJREEntry(install, list);
            list.add(LaunchConfigUtils.getRunJarRuntimeCPEntry(s));
            return list.toArray(new IRuntimeClasspathEntry[list.size()]);
        }
        catch (CoreException ce) {
            JBossServerCorePlugin.log(ce.getStatus());
            try {
                return super.computeUnresolvedClasspath(config);
            }
            catch (CoreException ce2) {
                JBossServerCorePlugin.log(ce2.getStatus());
                return new IRuntimeClasspathEntry[0];
            }
        }
    }
}

