/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.AbstractLocalJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;

public class LocalJBossServerRuntime
extends AbstractLocalJBossServerRuntime
implements IJBossServerRuntime {
    public JBossExtendedProperties getExtendedProperties() {
        return (JBossExtendedProperties)this.getRuntime().getAdapter(JBossExtendedProperties.class);
    }

    @Override
    public void setDefaults(IProgressMonitor monitor) {
        super.setDefaults(monitor);
        this.setAttribute("org.jboss.ide.eclipse.as.core.runtime.configurationName", "default");
    }

    @Override
    protected String getRuntimeNameBase() {
        JBossExtendedProperties props = this.getExtendedProperties();
        String prefix = RuntimeUtils.isEAP((IRuntimeType)this.getRuntimeType()) ? String.valueOf(Messages.jboss) + " EAP" : Messages.jboss;
        String rtVersion = props.getRuntimeTypeVersionString();
        String base = String.valueOf(prefix) + " " + rtVersion + " " + Messages.runtime;
        return base;
    }

    @Deprecated
    public boolean isEAP() {
        return RuntimeUtils.isEAP((IRuntimeType)this.getRuntimeType());
    }

    protected IRuntimeType getRuntimeType() {
        IRuntime rt = this.getRuntime();
        return rt == null ? this.getRuntimeWorkingCopy().getRuntimeType() : rt.getRuntimeType();
    }

    public IStatus validate() {
        IStatus s = super.validate();
        if (!s.isOK()) {
            return s;
        }
        if (this.getJBossConfiguration().equals("")) {
            return new Status(4, "org.jboss.ide.eclipse.as.core", 0, NLS.bind((String)Messages.ServerRuntimeConfigNotFound, (Object)this.getRuntime().getName()), null);
        }
        return Status.OK_STATUS;
    }

    public String getJBossConfiguration() {
        return this.getAttribute("org.jboss.ide.eclipse.as.core.runtime.configurationName", "");
    }

    public void setJBossConfiguration(String config) {
        this.setAttribute("org.jboss.ide.eclipse.as.core.runtime.configurationName", config);
    }

    @Override
    @Deprecated
    public String getDefaultRunArgs() {
        return this.getExtendedProperties().getDefaultLaunchArguments().getStartDefaultProgramArgs();
    }

    @Deprecated
    public String getDefaultRunArgs(IPath serverHome) {
        return this.getDefaultRunArgs();
    }

    @Override
    @Deprecated
    public String getDefaultRunVMArgs() {
        return this.getDefaultRunVMArgs(this.getRuntime().getLocation());
    }

    @Deprecated
    public String getDefaultRunVMArgs(IPath serverHome) {
        JBossExtendedProperties props = this.getExtendedProperties();
        return props.getDefaultLaunchArguments().getStartDefaultVMArgs();
    }

    @Deprecated
    public HashMap<String, String> getDefaultRunEnvVars() {
        JBossExtendedProperties props = this.getExtendedProperties();
        return props.getDefaultLaunchArguments().getDefaultRunEnvVars();
    }

    public String getConfigLocation() {
        return this.getAttribute("org.jboss.ide.eclipse.as.core.runtime.configurationLocation", "server");
    }

    public void setConfigLocation(String configLocation) {
        this.setAttribute("org.jboss.ide.eclipse.as.core.runtime.configurationLocation", configLocation);
    }

    public IPath getConfigurationFullPath() {
        return this.getConfigLocationFullPath().append(this.getJBossConfiguration());
    }

    public IPath getConfigLocationFullPath() {
        String cl = this.getConfigLocation();
        if (new Path(cl).isAbsolute()) {
            return new Path(cl);
        }
        return this.getRuntime().getLocation().append(cl);
    }
}

