/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.server.IDeploymentScannerModifier;
import org.jboss.ide.eclipse.as.core.server.IServerModeDetails;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentOptionsController;

public abstract class AbstractDeploymentScannerAdditions
implements IDeploymentScannerModifier {
    public abstract boolean accepts(IServer var1);

    protected boolean acceptsSetting(IServer server, String setting, boolean defaultVal) {
        return this.accepts(server) && server.getAttribute(setting, defaultVal);
    }

    protected abstract void ensureScannersAdded(IServer var1, String[] var2);

    protected String getJobName(IServer server) {
        return Messages.bind((String)Messages.UpdateDeploymentScannerJobName, (Object)server.getName());
    }

    public void updateDeploymentScanners(IServer server) {
        if (this.acceptsSetting(server, "org.jboss.ide.eclipse.as.core.server.addDeploymentScanner", true)) {
            try {
                String[] folders = this.getDeployLocationFolders(server);
                this.ensureScannersAdded(server, folders);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Job getUpdateDeploymentScannerJob(final IServer server) {
        if (!this.acceptsSetting(server, "org.jboss.ide.eclipse.as.core.server.addDeploymentScanner", true)) {
            return null;
        }
        return new Job(this.getJobName(server)){

            protected IStatus run(IProgressMonitor monitor) {
                AbstractDeploymentScannerAdditions.this.updateDeploymentScanners(server);
                return Status.OK_STATUS;
            }
        };
    }

    public void removeAddedDeploymentScanners(IServer server) {
        if (this.acceptsSetting(server, "org.jboss.ide.eclipse.as.core.server.removeDeploymentScanner", true)) {
            String[] folders = this.getDeployLocationFolders(server);
            this.ensureScannersRemoved(server, folders);
        }
    }

    public Job getRemoveDeploymentScannerJob(final IServer server) {
        if (!this.acceptsSetting(server, "org.jboss.ide.eclipse.as.core.server.removeDeploymentScanner", true)) {
            return null;
        }
        return new Job(this.getJobName(server)){

            protected IStatus run(IProgressMonitor monitor) {
                AbstractDeploymentScannerAdditions.this.removeAddedDeploymentScanners(server);
                return Status.OK_STATUS;
            }
        };
    }

    protected void ensureScannersRemoved(IServer server, String[] folders) {
    }

    protected String getServerMode(IServer server) {
        return ServerProfileModel.getProfile((IServerAttributes)server);
    }

    protected char getSeparatorCharacter(IServer server) {
        char sep = File.separatorChar;
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        if (beh != null) {
            try {
                IDeploymentOptionsController cont = (IDeploymentOptionsController)beh.getController("deploymentOptions");
                if (cont != null) {
                    sep = cont.getPathSeparatorCharacter();
                }
            }
            catch (CoreException coreException) {}
        }
        return sep;
    }

    public String[] getDeployLocationFolders(IServer server) {
        IRuntimeType rtt;
        IModule[] modules2;
        JBossServer ds = (JBossServer)ServerConverter.getJBossServer((IServer)server);
        char sep = this.getSeparatorCharacter(server);
        ArrayList<String> folders = new ArrayList<String>();
        String type = ds.getDeployLocationType();
        String insideServer = this.getInsideServerDeployFolder(server);
        insideServer = new RemotePath(insideServer, sep).removeTrailingSeparator().toOSString();
        folders.add(insideServer);
        if (type.equals("metadata")) {
            String metadata = JBossServer.getDeployFolder(ds, "metadata");
            if (!folders.contains(metadata = new RemotePath(metadata, sep).removeTrailingSeparator().toOSString())) {
                folders.add(metadata);
            }
        }
        if (type.equals("custom")) {
            IServerModeDetails det = (IServerModeDetails)Platform.getAdapterManager().getAdapter((Object)server, IServerModeDetails.class);
            String serverHome = det.getProperty("PROP_SERVER_HOME");
            String custom1 = server.getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", null);
            if (custom1 != null && !new RemotePath(custom1, sep).isAbsolute()) {
                custom1 = new RemotePath(serverHome, sep).append(custom1).removeTrailingSeparator().toOSString();
            }
            if (custom1 != null && !folders.contains(custom1) && !serverHome.equals(custom1)) {
                folders.add(custom1);
            }
        }
        IModule[] iModuleArray = modules2 = (rtt = server.getServerType().getRuntimeType()) == null ? null : ServerUtil.getModules((IModuleType[])rtt.getModuleTypes());
        if (modules2 != null) {
            int size = modules2.length;
            int i = 0;
            while (i < size) {
                IPath moduleDeployPath;
                IModule[] module = new IModule[]{modules2[i]};
                IStatus status = server.canModifyModules(module, null, null);
                if (status != null && status.getSeverity() != 4 && (moduleDeployPath = ds.getDeploymentLocation(module, false)) != null) {
                    String moduleDeploy = moduleDeployPath.toString();
                    if (!folders.contains(moduleDeploy = new RemotePath(moduleDeploy, sep).removeLastSegments(1).removeTrailingSeparator().toOSString())) {
                        folders.add(moduleDeploy);
                    }
                }
                ++i;
            }
        }
        folders.remove(insideServer);
        String[] folders2 = folders.toArray(new String[folders.size()]);
        return folders2;
    }

    protected String getInsideServerDeployFolder(IServer server) {
        IServerModeDetails det = (IServerModeDetails)Platform.getAdapterManager().getAdapter((Object)server, IServerModeDetails.class);
        return det.getProperty("PROP_SERVER_DEPLOYMENTS_FOLDER_ABSOLUTE");
    }

    public boolean persistsScannerChanges() {
        return false;
    }

    public boolean canCustomizeInterval() {
        return false;
    }

    public boolean canCustomizeTimeout() {
        return false;
    }
}

