/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug.ui.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.common.jdt.debug.RemoteDebugActivator;
import org.jboss.tools.common.jdt.debug.ui.RemoteDebugUIActivator;

public class RemoteDebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String ADD_ALL = " Add All>> ";
    private static final String ADD = " Add>> ";
    private static final String REMOVE_ALL = " <<Remove All ";
    private static final String REMOVE = " <Remove ";
    private Button autoConnectButton;
    private Button removeButton;
    private Button removeAllButton;
    private Button addButton;
    private Button addAllButton;
    private ListViewer eclipseConfigurationsViewer;
    private ListViewer jbossConfigurationsViewer;
    private Set<ILaunchConfiguration> jbossConfigurations = new HashSet<ILaunchConfiguration>();
    private Set<ILaunchConfiguration> eclipseConfigurations = new HashSet<ILaunchConfiguration>();
    private Set<ILaunchConfiguration> selectedEclipseConfigurations = new HashSet<ILaunchConfiguration>();
    private Set<ILaunchConfiguration> selectedJBossConfigurations = new HashSet<ILaunchConfiguration>();
    private ILaunchConfigurationListener launchConfigurationListener = new ILaunchConfigurationListener(){

        private void updateLaunchConfiguration(ILaunchConfiguration configuration) {
            try {
                if (!RemoteDebugActivator.REMOTE_JAVA_APPLICATION_ID.equals(configuration.getType().getIdentifier())) {
                    return;
                }
                RemoteDebugPreferencePage.this.refreshConfigurations();
                RemoteDebugPreferencePage.this.eclipseConfigurationsViewer.setInput((Object)RemoteDebugPreferencePage.this.eclipseConfigurations.toArray(new ILaunchConfiguration[0]));
                RemoteDebugPreferencePage.this.jbossConfigurationsViewer.setInput((Object)RemoteDebugPreferencePage.this.jbossConfigurations.toArray(new ILaunchConfiguration[0]));
            }
            catch (CoreException e) {
                RemoteDebugUIActivator.log(e);
            }
        }

        public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
            this.updateLaunchConfiguration(configuration);
        }

        public void launchConfigurationChanged(ILaunchConfiguration configuration) {
            this.updateLaunchConfiguration(configuration);
        }

        public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            this.updateLaunchConfiguration(configuration);
        }
    };

    public void init(IWorkbench workbench) {
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener(this.launchConfigurationListener);
    }

    protected void refreshConfigurations() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(RemoteDebugActivator.REMOTE_JAVA_APPLICATION_ID);
        this.jbossConfigurations.clear();
        this.eclipseConfigurations.clear();
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = manager.getLaunchConfigurations(type);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getAttribute("JBossRemoteJavaApplication", false)) {
                    this.jbossConfigurations.add(config);
                } else {
                    this.eclipseConfigurations.add(config);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            RemoteDebugUIActivator.log(e);
        }
        this.eclipseConfigurationsViewer.setInput((Object)this.eclipseConfigurations.toArray(new ILaunchConfiguration[0]));
        this.jbossConfigurationsViewer.setInput((Object)this.jbossConfigurations.toArray(new ILaunchConfiguration[0]));
        this.selectedJBossConfigurations.clear();
        this.selectedEclipseConfigurations.clear();
        this.eclipseConfigurationsViewer.setSelection((ISelection)new StructuredSelection(this.selectedEclipseConfigurations));
        this.jbossConfigurationsViewer.setSelection((ISelection)new StructuredSelection(this.selectedJBossConfigurations));
        this.configureButtons();
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)layout);
        this.autoConnectButton = new Button(composite, 32);
        this.autoConnectButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.autoConnectButton.setSelection(RemoteDebugUIActivator.getDefault().isAutoConnect());
        this.autoConnectButton.setText("Automatically connect if only one application found");
        Group remoteConfigurationsGroup = new Group(composite, 0);
        GridData gd = new GridData(4, 4, true, false);
        layout = new GridLayout(3, false);
        remoteConfigurationsGroup.setLayout((Layout)layout);
        remoteConfigurationsGroup.setLayoutData((Object)gd);
        remoteConfigurationsGroup.setText("Remote Configurations");
        Composite eclipseConfigurationsComposite = new Composite((Composite)remoteConfigurationsGroup, 0);
        gd = new GridData(4, 4, true, false);
        eclipseConfigurationsComposite.setLayoutData((Object)gd);
        eclipseConfigurationsComposite.setLayout((Layout)new GridLayout(1, false));
        Label eclipseConfigurationLabel = new Label(eclipseConfigurationsComposite, 0);
        gd = new GridData(4, 4, true, false);
        eclipseConfigurationLabel.setLayoutData((Object)gd);
        eclipseConfigurationLabel.setText("Eclipse Remote Java Configurations:");
        this.eclipseConfigurationsViewer = new ListViewer(eclipseConfigurationsComposite, 2050);
        gd = new GridData(4, 4, true, false);
        gd.heightHint = 300;
        this.eclipseConfigurationsViewer.getList().setLayoutData((Object)gd);
        this.eclipseConfigurationsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.eclipseConfigurationsViewer.setLabelProvider((IBaseLabelProvider)new RemoteConfigurationsLabelProvider());
        Composite buttonsComposite = new Composite((Composite)remoteConfigurationsGroup, 0);
        gd = new GridData(4, 4, true, false);
        buttonsComposite.setLayoutData((Object)gd);
        buttonsComposite.setLayout((Layout)new GridLayout(1, false));
        Label buttonsLabel = new Label(buttonsComposite, 0);
        gd = new GridData(4, 4, true, false);
        buttonsLabel.setLayoutData((Object)gd);
        Composite buttonsComp = new Composite(buttonsComposite, 0);
        gd = new GridData(4, 4, false, true);
        buttonsComp.setLayoutData((Object)gd);
        buttonsComp.setLayout((Layout)new GridLayout());
        GC gc = new GC((Drawable)buttonsComp);
        int maxAddRemoveButtonsWidth = this.computeMaxAddRemoveButtonsWidth(gc);
        gc.dispose();
        this.removeButton = this.createButton(buttonsComp, maxAddRemoveButtonsWidth, REMOVE);
        this.removeAllButton = this.createButton(buttonsComp, maxAddRemoveButtonsWidth, REMOVE_ALL);
        this.addButton = this.createButton(buttonsComp, maxAddRemoveButtonsWidth, ADD);
        this.addAllButton = this.createButton(buttonsComp, maxAddRemoveButtonsWidth, ADD_ALL);
        Composite jbossConfigurationsComposite = new Composite((Composite)remoteConfigurationsGroup, 0);
        gd = new GridData(4, 4, true, false);
        jbossConfigurationsComposite.setLayoutData((Object)gd);
        jbossConfigurationsComposite.setLayout((Layout)new GridLayout());
        Label jbossConfigurationLabel = new Label(jbossConfigurationsComposite, 0);
        gd = new GridData(4, 4, true, false);
        jbossConfigurationLabel.setLayoutData((Object)gd);
        jbossConfigurationLabel.setText("JBoss Remote Java Configurations:");
        this.jbossConfigurationsViewer = new ListViewer(jbossConfigurationsComposite, 2050);
        gd = new GridData(4, 4, true, false);
        gd.heightHint = 300;
        this.jbossConfigurationsViewer.getList().setLayoutData((Object)gd);
        this.jbossConfigurationsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.jbossConfigurationsViewer.setLabelProvider((IBaseLabelProvider)new RemoteConfigurationsLabelProvider());
        Button remoteConfigurationButton = new Button(composite, 8);
        remoteConfigurationButton.setLayoutData((Object)new GridData(1, 4, true, false));
        remoteConfigurationButton.setText("Configure Remote Java Application...");
        remoteConfigurationButton.setImage(DebugPluginImages.getImage((String)"IMG_ACT_DEBUG"));
        remoteConfigurationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener(RemoteDebugPreferencePage.this.launchConfigurationListener);
                LaunchConfigurationManager lcManager = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
                LaunchGroupExtension group = lcManager.getLaunchGroup("org.eclipse.debug.ui.launchGroup.debug");
                LaunchConfigurationsDialog dialog = new LaunchConfigurationsDialog(RemoteDebugPreferencePage.this.getShell(), group);
                ILaunchConfiguration config = null;
                if (RemoteDebugPreferencePage.this.selectedJBossConfigurations.size() > 0) {
                    config = (ILaunchConfiguration)RemoteDebugPreferencePage.this.selectedJBossConfigurations.iterator().next();
                } else if (RemoteDebugPreferencePage.this.selectedEclipseConfigurations.size() > 0) {
                    config = (ILaunchConfiguration)RemoteDebugPreferencePage.this.selectedEclipseConfigurations.iterator().next();
                } else if (RemoteDebugPreferencePage.this.jbossConfigurations.size() > 0) {
                    config = (ILaunchConfiguration)RemoteDebugPreferencePage.this.jbossConfigurations.iterator().next();
                } else if (RemoteDebugPreferencePage.this.eclipseConfigurations.size() > 0) {
                    config = (ILaunchConfiguration)RemoteDebugPreferencePage.this.eclipseConfigurations.iterator().next();
                }
                if (config != null) {
                    StructuredSelection selection = new StructuredSelection((Object)config);
                    dialog.setInitialSelection((IStructuredSelection)selection);
                    dialog.setOpenMode(3);
                } else {
                    dialog.setOpenMode(2);
                }
                dialog.open();
                DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener(RemoteDebugPreferencePage.this.launchConfigurationListener);
                RemoteDebugPreferencePage.this.refreshConfigurations();
            }
        });
        this.eclipseConfigurationsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                RemoteDebugPreferencePage.this.selectedEclipseConfigurations.clear();
                if (sel instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)sel;
                    for (Object object : selection) {
                        if (!(object instanceof ILaunchConfiguration)) continue;
                        RemoteDebugPreferencePage.this.selectedEclipseConfigurations.add((ILaunchConfiguration)object);
                    }
                }
                RemoteDebugPreferencePage.this.configureButtons();
            }
        });
        this.jbossConfigurationsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                RemoteDebugPreferencePage.this.selectedJBossConfigurations.clear();
                if (sel instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)sel;
                    for (Object object : selection) {
                        if (!(object instanceof ILaunchConfiguration)) continue;
                        RemoteDebugPreferencePage.this.selectedJBossConfigurations.add((ILaunchConfiguration)object);
                    }
                }
                RemoteDebugPreferencePage.this.configureButtons();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteDebugPreferencePage.this.changeConfigurations(RemoteDebugPreferencePage.this.selectedJBossConfigurations, false);
            }
        });
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteDebugPreferencePage.this.changeConfigurations(RemoteDebugPreferencePage.this.jbossConfigurations, false);
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteDebugPreferencePage.this.changeConfigurations(RemoteDebugPreferencePage.this.selectedEclipseConfigurations, true);
            }
        });
        this.addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteDebugPreferencePage.this.changeConfigurations(RemoteDebugPreferencePage.this.eclipseConfigurations, true);
            }
        });
        this.refreshConfigurations();
        return composite;
    }

    private void configureButtons() {
        this.removeButton.setEnabled(this.selectedJBossConfigurations.size() > 0);
        this.removeAllButton.setEnabled(this.jbossConfigurations.size() > 0);
        this.addButton.setEnabled(this.selectedEclipseConfigurations.size() > 0);
        this.addAllButton.setEnabled(this.eclipseConfigurations.size() > 0);
    }

    protected Button createButton(Composite buttonsComp, int maxAddRemoveButtonsWidth, String text) {
        Button button = new Button(buttonsComp, 16384);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.widthHint = maxAddRemoveButtonsWidth;
        button.setLayoutData((Object)gd);
        button.setText(text);
        return button;
    }

    private int computeMaxAddRemoveButtonsWidth(GC gc) {
        int maxWidth = 0;
        maxWidth = this.getGreaterWidth(gc, REMOVE, maxWidth);
        maxWidth = this.getGreaterWidth(gc, REMOVE_ALL, maxWidth);
        maxWidth = this.getGreaterWidth(gc, ADD, maxWidth);
        maxWidth = this.getGreaterWidth(gc, ADD_ALL, maxWidth);
        return maxWidth;
    }

    private int getGreaterWidth(GC gc, String str, int compareWidth) {
        int greaterWidth = compareWidth;
        Point strExtentPoint = gc.stringExtent(str);
        int strWidth = strExtentPoint.x;
        if (strWidth > compareWidth) {
            greaterWidth = strWidth;
        }
        return greaterWidth + 5;
    }

    public void dispose() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener(this.launchConfigurationListener);
        super.dispose();
    }

    protected void performApply() {
        IEclipsePreferences preferences = RemoteDebugUIActivator.getDefault().getPreferences();
        preferences.putBoolean("autoConnect", this.autoConnectButton.getSelection());
        RemoteDebugUIActivator.getDefault().savePreferences();
    }

    protected void performDefaults() {
        IEclipsePreferences preferences = RemoteDebugUIActivator.getDefault().getPreferences();
        this.autoConnectButton.setSelection(false);
        preferences.putBoolean("autoConnect", false);
        RemoteDebugUIActivator.getDefault().savePreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void changeConfigurations(Set<ILaunchConfiguration> configurations, boolean value) {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener(this.launchConfigurationListener);
        for (ILaunchConfiguration configuration : configurations) {
            try {
                ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
                wc.setAttribute("JBossRemoteJavaApplication", value);
                wc.doSave();
            }
            catch (CoreException e) {
                RemoteDebugUIActivator.log(e);
            }
        }
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener(this.launchConfigurationListener);
        this.refreshConfigurations();
    }

    class RemoteConfigurationsLabelProvider
    extends LabelProvider {
        RemoteConfigurationsLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ILaunchConfiguration) {
                ILaunchConfiguration configuration = (ILaunchConfiguration)element;
                return configuration.getName();
            }
            return null;
        }
    }
}

