/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.core.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.junit.JUnitMessages;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.jboss.tools.arquillian.core.ArquillianCoreActivator;
import org.jboss.tools.arquillian.core.internal.ArquillianConstants;
import org.jboss.tools.arquillian.core.internal.archives.Archive;
import org.jboss.tools.arquillian.core.internal.archives.ArchiveContainer;
import org.jboss.tools.arquillian.core.internal.archives.ArchiveLocation;
import org.jboss.tools.arquillian.core.internal.util.ArquillianUtility;
import org.jboss.tools.arquillian.core.internal.util.xpl.ArquillianSecurityException;
import org.jboss.tools.arquillian.core.internal.util.xpl.ArquillianSecurityManager;

public class ArquillianSearchEngine {
    private static final String ORG_JBOSS_SHRINKWRAP_API_ARCHIVE = "org.jboss.shrinkwrap.api.Archive";
    private static final String ARCHIVE_WAR = "archive.war";
    private static final String ARCHIVE_JAR = "archive.jar";
    private static final String VALUE = "value";
    public static final String ARQUILLIAN_JUNIT_ARQUILLIAN = "org.jboss.arquillian.junit.Arquillian";
    public static final String CONTAINER_DEPLOYABLE_CONTAINER = "org.jboss.arquillian.container.spi.client.container.DeployableContainer";
    public static final int CONTAINER_DEPLOYABLE_CONTAINER_NOT_EXISTS = 0;

    public static boolean isArquillianJUnitTest(IJavaElement element, boolean checkDeployment, boolean checkTest) {
        return ArquillianSearchEngine.isArquillianJUnitTest(element, checkDeployment, checkTest, true);
    }

    public static boolean isArquillianJUnitTest(IJavaElement element, boolean checkDeployment, boolean checkTest, boolean checkAbstract) {
        if (element == null || element.getJavaProject() == null || !ArquillianUtility.isArquillianProject(element.getJavaProject().getProject())) {
            return false;
        }
        try {
            IType testType = null;
            if (element instanceof ICompilationUnit) {
                testType = ((ICompilationUnit)element).findPrimaryType();
            } else if (element instanceof IClassFile) {
                testType = ((IClassFile)element).getType();
            } else if (element instanceof IType) {
                testType = (IType)element;
            } else if (element instanceof IMember) {
                testType = ((IMember)element).getDeclaringType();
            }
            if (testType != null && testType.exists()) {
                return ArquillianSearchEngine.isArquillianJUnitTest(testType, checkDeployment, checkTest, checkAbstract);
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static boolean isAccessibleClass(IType type) throws JavaModelException {
        if (type == null) {
            return false;
        }
        int flags = type.getFlags();
        if (Flags.isInterface((int)flags)) {
            return false;
        }
        IJavaElement parent = type.getParent();
        while (!(parent instanceof ICompilationUnit) && !(parent instanceof IClassFile)) {
            if (!(parent instanceof IType && Flags.isStatic((int)flags) && Flags.isPublic((int)flags))) {
                return false;
            }
            flags = ((IType)parent).getFlags();
            parent = parent.getParent();
        }
        return true;
    }

    public static boolean hasSuiteMethod(IType type) throws JavaModelException {
        IMethod method = type.getMethod("suite", new String[0]);
        if (!method.exists()) {
            return false;
        }
        if (!Flags.isStatic((int)method.getFlags()) || !Flags.isPublic((int)method.getFlags())) {
            return false;
        }
        return Signature.getSimpleName((String)Signature.toString((String)method.getReturnType())).equals("Test");
    }

    private static boolean isArquillianJUnitTest(IType type, boolean checkDeployment, boolean checkTest, boolean checkAbstract) throws JavaModelException {
        ITypeBinding binding;
        if (type == null || type.getJavaProject() == null || !ArquillianUtility.isArquillianProject(type.getJavaProject().getProject())) {
            return false;
        }
        if (ArquillianSearchEngine.isAccessibleClass(type) && (binding = ArquillianSearchEngine.getTypeBinding(type)) != null) {
            return ArquillianSearchEngine.isTest(binding, checkDeployment, checkTest, checkAbstract);
        }
        return false;
    }

    private static ITypeBinding getTypeBinding(IType type) throws JavaModelException {
        ASTParser parser = ASTParser.newParser((int)8);
        if (type.getCompilationUnit() != null) {
            parser.setSource(type.getCompilationUnit());
        } else {
            if (!ArquillianSearchEngine.isAvailable(type.getSourceRange())) {
                parser.setProject(type.getJavaProject());
                IBinding[] bindings = parser.createBindings(new IJavaElement[]{type}, null);
                if (bindings.length == 1 && bindings[0] instanceof ITypeBinding) {
                    return (ITypeBinding)bindings[0];
                }
                return null;
            }
            parser.setSource(type.getClassFile());
        }
        parser.setFocalPosition(0);
        parser.setResolveBindings(true);
        CompilationUnit root = (CompilationUnit)parser.createAST(null);
        ASTNode node = root.findDeclaringNode(type.getKey());
        if (node instanceof TypeDeclaration) {
            return ((TypeDeclaration)node).resolveBinding();
        }
        return null;
    }

    static boolean isAvailable(ISourceRange range) {
        return range != null && range.getOffset() != -1;
    }

    static boolean isTest(ITypeBinding binding, boolean checkDeployment, boolean checkTest, boolean checkAbstract) {
        if (checkAbstract && Modifier.isAbstract((int)binding.getModifiers())) {
            return false;
        }
        if (Annotation.RUN_WITH.annotatesTypeOrSuperTypes(binding, ARQUILLIAN_JUNIT_ARQUILLIAN)) {
            if (checkDeployment && !Annotation.DEPLOYMENT.annotatesAtLeastOneMethod(binding)) {
                return false;
            }
            return !checkTest || Annotation.TEST.annotatesAtLeastOneMethod(binding);
        }
        return ArquillianSearchEngine.isTestImplementor(binding);
    }

    private static boolean isImplementor(ITypeBinding type, String interfaceName) {
        ITypeBinding superType = type.getSuperclass();
        if (superType != null && ArquillianSearchEngine.isTestImplementor(superType)) {
            return true;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            ITypeBinding curr = interfaces[i];
            if (interfaceName.equals(curr.getQualifiedName()) || ArquillianSearchEngine.isTestImplementor(curr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isTestImplementor(ITypeBinding type) {
        return ArquillianSearchEngine.isImplementor(type, "junit.framework.Test");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IStatus validateDeployableContainer(IJavaProject javaProject) {
        try {
            InputStream is;
            block19: {
                ITypeBinding binding;
                IType loadableExtension;
                String content;
                IType type = javaProject.findType(CONTAINER_DEPLOYABLE_CONTAINER);
                if (type == null) {
                    return new Status(4, "org.jboss.tools.arquillian.core", 0, "Cannot find 'org.jboss.arquillian.container.spi.client.container.DeployableContainer' on the project build path. Do you want to add it?", null);
                }
                ITypeHierarchy hierarchy = type.newTypeHierarchy(javaProject, (IProgressMonitor)new NullProgressMonitor());
                IType[] subTypes = hierarchy.getAllSubtypes(type);
                int count = 0;
                IType[] iTypeArray = subTypes;
                int n = subTypes.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        if (count != 0) break;
                        return new Status(4, "org.jboss.tools.arquillian.core", 1, "Arquillian tests are missing an implementation of DeploymentContainer on the project build path. Do you want to configure it?", null);
                    }
                    IType subType = iTypeArray[n2];
                    if (ArquillianSearchEngine.isNonAbstractClass(subType)) {
                        ++count;
                    }
                    ++n2;
                }
                if (count == 1) {
                    return Status.OK_STATUS;
                }
                IFile file = ArquillianSearchEngine.getFile(javaProject, "META-INF/services/org.jboss.arquillian.core.spi.LoadableExtension");
                if (file == null) return new Status(4, "org.jboss.tools.arquillian.core", 1, "Arquillian tests require exactly one implementation of DeploymentContainer on the project build path but several were found. Do you want to configure it?", null);
                is = null;
                is = file.getContents();
                if (is == null || (content = IOUtil.toString((InputStream)is)) == null || content.isEmpty() || (loadableExtension = javaProject.findType(content = content.trim())) == null || !loadableExtension.exists() || !ArquillianSearchEngine.isImplementor(binding = ArquillianSearchEngine.getTypeBinding(loadableExtension), "org.jboss.arquillian.core.spi.LoadableExtension")) break block19;
                IStatus iStatus = Status.OK_STATUS;
                if (is == null) return iStatus;
                try {
                    is.close();
                    return iStatus;
                }
                catch (IOException iOException) {}
                return iStatus;
                catch (Exception e) {
                    try {
                        ArquillianCoreActivator.log(e);
                        if (is == null) return new Status(4, "org.jboss.tools.arquillian.core", 1, "Arquillian tests require exactly one implementation of DeploymentContainer on the project build path but several were found. Do you want to configure it?", null);
                    }
                    catch (Throwable throwable) {
                        if (is == null) throw throwable;
                        try {
                            is.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        is.close();
                        return new Status(4, "org.jboss.tools.arquillian.core", 1, "Arquillian tests require exactly one implementation of DeploymentContainer on the project build path but several were found. Do you want to configure it?", null);
                    }
                    catch (IOException iOException) {
                        return new Status(4, "org.jboss.tools.arquillian.core", 1, "Arquillian tests require exactly one implementation of DeploymentContainer on the project build path but several were found. Do you want to configure it?", null);
                    }
                }
            }
            if (is == null) return new Status(4, "org.jboss.tools.arquillian.core", 1, "Arquillian tests require exactly one implementation of DeploymentContainer on the project build path but several were found. Do you want to configure it?", null);
            try {
                is.close();
                return new Status(4, "org.jboss.tools.arquillian.core", 1, "Arquillian tests require exactly one implementation of DeploymentContainer on the project build path but several were found. Do you want to configure it?", null);
            }
            catch (IOException iOException) {
                return new Status(4, "org.jboss.tools.arquillian.core", 1, "Arquillian tests require exactly one implementation of DeploymentContainer on the project build path but several were found. Do you want to configure it?", null);
            }
        }
        catch (JavaModelException e) {
            return new Status(4, "org.jboss.tools.arquillian.core", e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static IFile getFile(IJavaProject javaProject, String fileName) throws JavaModelException {
        IClasspathEntry[] rawClasspath;
        IClasspathEntry[] iClasspathEntryArray = rawClasspath = javaProject.getRawClasspath();
        int n = rawClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot[] roots;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && (roots = javaProject.findPackageFragmentRoots(entry)) != null) {
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                int n3 = roots.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                    IPath path = root.getPath();
                    path = path.append(fileName);
                    IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IFile file = wsRoot.getFile(path);
                    if (file != null && file.exists()) {
                        return file;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public static boolean isNonAbstractClass(IType type) throws JavaModelException {
        int flags = type.getFlags();
        if (Flags.isInterface((int)flags)) {
            return false;
        }
        return !Flags.isAbstract((int)flags);
    }

    public static IType[] findTests(IRunnableContext context, final IJavaElement element, ITestKind testKind) throws InvocationTargetException, InterruptedException {
        final HashSet result = new HashSet();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InterruptedException, InvocationTargetException {
                try {
                    ArquillianSearchEngine.findTestsInContainer(element, result, pm);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        context.run(true, true, runnable);
        return result.toArray(new IType[result.size()]);
    }

    public static void findTestsInContainer(IJavaElement element, Set result, IProgressMonitor pm) throws CoreException {
        ArquillianSearchEngine.findTestsInContainer(element, result, pm, true, true, true);
    }

    public static void findTestsInContainer(IJavaElement element, Set result, IProgressMonitor pm, boolean checkDeployment, boolean checkTest, boolean checkSuite) throws CoreException {
        if (element == null || result == null) {
            throw new IllegalArgumentException();
        }
        if (element instanceof IType && ArquillianSearchEngine.isArquillianJUnitTest((IType)element, checkDeployment, checkTest, true)) {
            result.add(element);
            return;
        }
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        try {
            SearchPattern runWithPattern;
            pm.beginTask(JUnitMessages.JUnit4TestFinder_searching_description, 4);
            IRegion region = CoreTestSearchEngine.getRegion((IJavaElement)element);
            ITypeHierarchy hierarchy = JavaCore.newTypeHierarchy((IRegion)region, null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            IType[] allClasses = hierarchy.getAllClasses();
            HashSet candidates = new HashSet(allClasses.length);
            AnnotationSearchRequestor requestor = new AnnotationSearchRequestor(hierarchy, candidates);
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])allClasses, (int)1);
            int matchRule = 8;
            SearchPattern annotationsPattern = runWithPattern = SearchPattern.createPattern((String)Annotation.RUN_WITH.getName(), (int)8, (int)65536, (int)matchRule);
            SearchParticipant[] searchParticipants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            new SearchEngine().search(annotationsPattern, searchParticipants, scope, (SearchRequestor)requestor, (IProgressMonitor)new SubProgressMonitor(pm, 2));
            for (IType curr : candidates) {
                ITypeBinding binding;
                if (!ArquillianSearchEngine.isAccessibleClass(curr) || Flags.isAbstract((int)curr.getFlags()) || !region.contains((IJavaElement)curr) || (binding = ArquillianSearchEngine.getTypeBinding(curr)) == null || !ArquillianSearchEngine.isTest(binding, true, true, true)) continue;
                result.add(curr);
            }
            if (checkSuite) {
                CoreTestSearchEngine.findSuiteMethods((IJavaElement)element, (Set)result, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
        }
        finally {
            pm.done();
        }
    }

    public static boolean hasArquillianType(IJavaProject javaProject) {
        if (javaProject == null) {
            return false;
        }
        try {
            IType type = javaProject.findType(ARQUILLIAN_JUNIT_ARQUILLIAN);
            return type != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public static boolean isArquillianJUnitTest(IResourceProxy proxy, IJavaProject project) {
        IType type;
        block7: {
            if (proxy == null || project == null || !(proxy.requestResource() instanceof IFile)) {
                return false;
            }
            IFile file = (IFile)proxy.requestResource();
            IJavaElement element = JavaCore.create((IFile)file);
            if (!(element instanceof ICompilationUnit)) {
                return false;
            }
            ICompilationUnit cu = (ICompilationUnit)element;
            type = cu.findPrimaryType();
            try {
                if (ArquillianSearchEngine.isAccessibleClass(type)) break block7;
                return false;
            }
            catch (JavaModelException e) {
                ArquillianCoreActivator.log(e);
                return false;
            }
        }
        ITypeBinding binding = ArquillianSearchEngine.getTypeBinding(type);
        if (binding == null) {
            return false;
        }
        if (Modifier.isAbstract((int)binding.getModifiers())) {
            return false;
        }
        return Annotation.RUN_WITH.annotatesTypeOrSuperTypes(binding, ARQUILLIAN_JUNIT_ARQUILLIAN);
    }

    public static boolean hasDeploymentMethod(IType type) {
        if (type == null) {
            return false;
        }
        try {
            return ArquillianSearchEngine.getDeploymentMethods(type).size() > 0;
        }
        catch (JavaModelException e) {
            ArquillianCoreActivator.log(e);
            return false;
        }
    }

    public static boolean hasInvalidDeploymentMethod(IType type) {
        if (type == null) {
            return false;
        }
        try {
            return ArquillianSearchEngine.getDeploymentMethods(type).size() > 0;
        }
        catch (JavaModelException e) {
            ArquillianCoreActivator.log(e);
            return false;
        }
    }

    public static boolean hasTestMethod(IType type) {
        try {
            ITypeBinding binding = ArquillianSearchEngine.getTypeBinding(type);
            return Annotation.TEST.annotatesAtLeastOneMethod(binding);
        }
        catch (JavaModelException e) {
            ArquillianCoreActivator.log(e);
            return false;
        }
    }

    public static boolean annotates(IAnnotationBinding[] annotations, String fName, String val) {
        int i = 0;
        while (i < annotations.length) {
            ITypeBinding annotationType = annotations[i].getAnnotationType();
            if (annotationType != null && annotationType.getQualifiedName().equals(fName)) {
                if (val == null) {
                    return true;
                }
                IMemberValuePairBinding[] pairs = annotations[i].getAllMemberValuePairs();
                if (pairs != null) {
                    IMemberValuePairBinding[] iMemberValuePairBindingArray = pairs;
                    int n = pairs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITypeBinding value;
                        Object object;
                        IMemberValuePairBinding pair = iMemberValuePairBindingArray[n2];
                        if (VALUE.equals(pair.getName()) && (object = pair.getValue()) instanceof ITypeBinding && val.equals((value = (ITypeBinding)object).getQualifiedName())) {
                            return true;
                        }
                        ++n2;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public static List<Archive> getDeploymentArchives(IType type, boolean create) {
        IProject project;
        IResource resource;
        ArrayList<Archive> archives = new ArrayList<Archive>();
        if (type == null || !ArquillianSearchEngine.hasDeploymentMethod(type)) {
            return archives;
        }
        String projectName = null;
        ICompilationUnit cu = type.getCompilationUnit();
        IJavaProject javaProject = null;
        if (cu != null && (resource = cu.getResource()) != null && (project = resource.getProject()) != null) {
            projectName = project.getName();
            javaProject = JavaCore.create((IProject)project);
        }
        if (projectName == null) {
            ArquillianCoreActivator.logWarning("Cannot find any project for the " + type.getElementName() + "type.");
            return archives;
        }
        String fqn = type.getFullyQualifiedName();
        try {
            List<IMethodBinding> deploymentMethods = ArquillianSearchEngine.getDeploymentMethods(type);
            for (IMethodBinding deploymentMethod : deploymentMethods) {
                Archive archive;
                block14: {
                    String name = deploymentMethod.getName();
                    ArchiveLocation location = new ArchiveLocation(projectName, fqn, name);
                    archive = ArchiveContainer.getArchive(location);
                    if (archive == null || create && archive != null && archive.getDescription() == null) {
                        SecurityManager orig = System.getSecurityManager();
                        try {
                            try {
                                System.setSecurityManager(new ArquillianSecurityManager(orig, Thread.currentThread()));
                                archive = ArquillianSearchEngine.createArchive(javaProject, type, deploymentMethod, location);
                                if (archive != null) {
                                    ArchiveContainer.putArchive(location, archive);
                                } else {
                                    archive = new Archive(null, location, null);
                                    ArchiveContainer.putArchive(location, archive);
                                }
                            }
                            catch (ArquillianSecurityException e) {
                                ArquillianCoreActivator.log(e);
                                System.setSecurityManager(orig);
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            System.setSecurityManager(orig);
                            throw throwable;
                        }
                        System.setSecurityManager(orig);
                    }
                }
                if (archive == null) continue;
                archives.add(archive);
            }
        }
        catch (JavaModelException e) {
            ArquillianCoreActivator.log(e);
        }
        return archives;
    }

    /*
     * Unable to fully structure code
     */
    private static Archive createArchive(IJavaProject javaProject, IType type, IMethodBinding deploymentMethod, ArchiveLocation location) {
        block14: {
            className = type.getFullyQualifiedName();
            methodName = deploymentMethod.getName();
            loader = ArquillianCoreActivator.getDefault().getClassLoader(javaProject);
            oldLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(loader);
                clazz = Class.forName(className, true, loader);
                object = clazz.newInstance();
                method = clazz.getMethod(methodName, new Class[0]);
                archiveObject = method.invoke(object, new Object[0]);
                archiveClass = archiveObject.getClass();
                formatterClass = Class.forName("org.jboss.arquillian.container.test.impl.client.deployment.tool.ToolingDeploymentFormatter", true, loader);
                constructor = formatterClass.getDeclaredConstructor(new Class[]{Class.class});
                formatterObject = constructor.newInstance(new Object[]{clazz});
                formatter = Class.forName("org.jboss.shrinkwrap.api.formatter.Formatter", true, loader);
                toStringMethod = archiveClass.getMethod("toString", new Class[]{formatter});
                toStringObject = toStringMethod.invoke(archiveObject, new Object[]{formatterObject});
                if (toStringObject instanceof String) {
                    description = (String)toStringObject;
                    var22_31 = archive = new Archive(description, location, javaProject);
                    return var22_31;
                }
                break block14;
            }
            catch (OutOfMemoryError e) {
                throw new OutOfMemoryError(e.getLocalizedMessage());
            }
            catch (InternalError e) {
                throw new InternalError(e.getLocalizedMessage());
            }
            catch (StackOverflowError e) {
                throw new StackOverflowError(e.getLocalizedMessage());
            }
            catch (UnknownError e) {
                throw new UnknownError(e.getLocalizedMessage());
            }
            catch (Throwable e) {
                message = String.valueOf(ArquillianSearchEngine.getText(e)) + "(project=" + javaProject.getProject().getName() + ")";
                cause = e.getCause();
                i = 0;
                ** while (cause != null && i++ < 5)
            }
lbl-1000:
            // 1 sources

            {
                message = String.valueOf(ArquillianSearchEngine.getText(cause)) + "(project=" + javaProject.getProject().getName() + ")";
                cause = cause.getCause();
                continue;
            }
lbl39:
            // 1 sources

            ArquillianCoreActivator.logWarning(message);
            if (Platform.inDebugMode()) {
                ArquillianCoreActivator.log(e);
            }
            try {
                severity = ArquillianUtility.getSeverity(ArquillianUtility.getPreference("org.jboss.tools.arquillian.core.deploymentArchiveCannotBeCreated"));
                ArquillianSearchEngine.createProblem(message, type, deploymentMethod, severity);
            }
            catch (CoreException e1) {
                ArquillianCoreActivator.log(e1);
            }
            break block14;
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
        return null;
    }

    private static String getText(Throwable e) {
        String text = e.getLocalizedMessage() == null || e.getLocalizedMessage().isEmpty() ? String.valueOf(e.getClass().getName()) + ": " : e.getLocalizedMessage();
        return text;
    }

    private static void createProblem(String message, IType type, IMethodBinding deploymentMethod, Integer severity) throws CoreException {
        ISourceRange range;
        Object[] allValues;
        String[] allNames;
        IMarker marker;
        block9: {
            if (severity == null || type == null || type.getJavaProject() == null) {
                return;
            }
            boolean enable = ArquillianUtility.isValidatorEnabled(type.getJavaProject().getProject());
            if (!enable) {
                return;
            }
            ICompilationUnit cu = type.getCompilationUnit();
            if (cu == null) {
                return;
            }
            IResource resource = cu.getResource();
            if (resource == null) {
                return;
            }
            marker = resource.createMarker("org.jboss.tools.arquillian.core.problem.resource");
            allNames = new String[]{"message", "severity", "id", "charStart", "charEnd", "sourceId"};
            allValues = new Object[allNames.length];
            int index = 0;
            allValues[index++] = message;
            allValues[index++] = severity;
            allValues[index++] = 1;
            IJavaElement javaElement = deploymentMethod.getJavaElement();
            range = null;
            if (javaElement instanceof IMember) {
                IMember member = (IMember)javaElement;
                if (javaElement != null) {
                    try {
                        range = member.getNameRange();
                    }
                    catch (JavaModelException e) {
                        if (e.getJavaModelStatus().getCode() != 969) {
                            throw e;
                        }
                        if (CharOperation.equals((char[])javaElement.getElementName().toCharArray(), (char[])TypeConstants.PACKAGE_INFO_NAME)) break block9;
                        throw e;
                    }
                }
            }
        }
        int start = range == null ? 0 : range.getOffset();
        int end = range == null ? 1 : start + range.getLength();
        allValues[index++] = new Integer(start);
        allValues[index++] = new Integer(end > 0 ? end + 1 : end);
        allValues[index++] = ArquillianConstants.SOURCE_ID;
        marker.setAttributes(allNames, allValues);
    }

    public static List<IMethodBinding> getDeploymentMethods(IType type) throws JavaModelException {
        ArrayList<IMethodBinding> methodBindings = new ArrayList<IMethodBinding>();
        if (type == null) {
            return methodBindings;
        }
        ITypeBinding binding = ArquillianSearchEngine.getTypeBinding(type);
        while (binding != null) {
            IMethodBinding[] declaredMethods;
            IMethodBinding[] iMethodBindingArray = declaredMethods = binding.getDeclaredMethods();
            int n = declaredMethods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding curr = iMethodBindingArray[n2];
                if (ArquillianSearchEngine.isDeploymentMethod(curr)) {
                    methodBindings.add(curr);
                }
                ++n2;
            }
            binding = binding.getSuperclass();
        }
        return methodBindings;
    }

    public static List<IMethodBinding> getInvalidDeploymentMethods(IType type) throws JavaModelException {
        ArrayList<IMethodBinding> methodBindings = new ArrayList<IMethodBinding>();
        if (type == null) {
            return methodBindings;
        }
        ITypeBinding binding = ArquillianSearchEngine.getTypeBinding(type);
        while (binding != null) {
            IMethodBinding[] declaredMethods;
            IMethodBinding[] iMethodBindingArray = declaredMethods = binding.getDeclaredMethods();
            int n = declaredMethods.length;
            int n2 = 0;
            while (n2 < n) {
                int modifiers;
                IMethodBinding curr = iMethodBindingArray[n2];
                if (ArquillianSearchEngine.isDeploymentMethod(curr, false) && (((modifiers = curr.getModifiers()) & 1) == 0 || (modifiers & 8) == 0)) {
                    methodBindings.add(curr);
                }
                ++n2;
            }
            binding = binding.getSuperclass();
        }
        return methodBindings;
    }

    public static boolean isDeploymentMethod(IMethodBinding methodBinding, boolean testModifiers) {
        if (methodBinding == null) {
            return false;
        }
        if (ArquillianSearchEngine.annotates(methodBinding.getAnnotations(), "org.jboss.arquillian.container.test.api.Deployment", null)) {
            ITypeBinding returnType;
            boolean condition;
            int modifiers = methodBinding.getModifiers();
            if (testModifiers) {
                condition = (modifiers & 1) != 0 && (modifiers & 8) != 0 && methodBinding.getParameterTypes().length == 0;
            } else {
                boolean bl = condition = methodBinding.getParameterTypes().length == 0;
            }
            if (condition && ArquillianSearchEngine.isArchiveType(returnType = methodBinding.getReturnType())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isDeploymentMethod(IMethodBinding methodBinding) {
        return ArquillianSearchEngine.isDeploymentMethod(methodBinding, true);
    }

    public static boolean isArchiveType(ITypeBinding returnType) {
        ITypeBinding[] interfaces;
        if (returnType == null) {
            return false;
        }
        if (ORG_JBOSS_SHRINKWRAP_API_ARCHIVE.equals(returnType.getBinaryName())) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = interfaces = returnType.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding t = iTypeBindingArray[n2];
            if (ArquillianSearchEngine.isArchiveType(t)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isDeploymentMethod(IMethod method) {
        block10: {
            String type;
            block9: {
                block8: {
                    block7: {
                        if (method == null || !method.exists()) {
                            return false;
                        }
                        try {
                            if (Flags.isStatic((int)method.getFlags()) && Flags.isPublic((int)method.getFlags())) break block7;
                            return false;
                        }
                        catch (JavaModelException e) {
                            ArquillianCoreActivator.log(e);
                            return false;
                        }
                    }
                    if (method.getParameters().length <= 0) break block8;
                    return false;
                }
                type = method.getReturnType();
                if (type != null) break block9;
                return false;
            }
            String typeSig = Signature.toString((String)type);
            if ("Archive<?>".equals(typeSig)) break block10;
            return false;
        }
        IAnnotation deployment = method.getAnnotation("Deployment");
        return deployment != null && deployment.exists();
    }

    private static class Annotation {
        private static final Annotation RUN_WITH = new Annotation("org.junit.runner.RunWith");
        private static final Annotation TEST = new Annotation("org.junit.Test");
        private static final Annotation DEPLOYMENT = new Annotation("org.jboss.arquillian.container.test.api.Deployment");
        private final String fName;

        private Annotation(String name) {
            this.fName = name;
        }

        private String getName() {
            return this.fName;
        }

        public boolean annotatesTypeOrSuperTypes(ITypeBinding type, String value) {
            while (type != null) {
                if (ArquillianSearchEngine.annotates(type.getAnnotations(), this.fName, value)) {
                    return true;
                }
                type = type.getSuperclass();
            }
            return false;
        }

        public boolean annotatesAtLeastOneMethod(ITypeBinding type) {
            while (type != null) {
                IMethodBinding[] declaredMethods = type.getDeclaredMethods();
                int i = 0;
                while (i < declaredMethods.length) {
                    IMethodBinding curr = declaredMethods[i];
                    if (ArquillianSearchEngine.annotates(curr.getAnnotations(), this.fName, null)) {
                        return true;
                    }
                    ++i;
                }
                type = type.getSuperclass();
            }
            return false;
        }

        public boolean annotatesAtLeastOneMethod(ITypeBinding type, String value) {
            while (type != null) {
                IMethodBinding[] declaredMethods = type.getDeclaredMethods();
                int i = 0;
                while (i < declaredMethods.length) {
                    IMethodBinding curr = declaredMethods[i];
                    if (ArquillianSearchEngine.annotates(curr.getAnnotations(), this.fName, value)) {
                        return true;
                    }
                    ++i;
                }
                type = type.getSuperclass();
            }
            return false;
        }
    }

    private static class AnnotationSearchRequestor
    extends SearchRequestor {
        private final Collection fResult;
        private final ITypeHierarchy fHierarchy;

        public AnnotationSearchRequestor(ITypeHierarchy hierarchy, Collection result) {
            this.fHierarchy = hierarchy;
            this.fResult = result;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object element;
            if (match.getAccuracy() == 0 && !match.isInsideDocComment() && ((element = match.getElement()) instanceof IType || element instanceof IMethod)) {
                IMember member = (IMember)element;
                IType type = member.getElementType() == 7 ? (IType)member : member.getDeclaringType();
                this.addTypeAndSubtypes(type);
            }
        }

        private void addTypeAndSubtypes(IType type) {
            if (this.fResult.add(type)) {
                IType[] subclasses = this.fHierarchy.getSubclasses(type);
                int i = 0;
                while (i < subclasses.length) {
                    this.addTypeAndSubtypes(subclasses[i]);
                    ++i;
                }
            }
        }
    }
}

