/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.core.internal.launcher;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.ClasspathFixProcessor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jboss.tools.arquillian.core.ArquillianCoreActivator;
import org.jboss.tools.arquillian.core.internal.util.ArquillianSearchEngine;
import org.jboss.tools.arquillian.core.internal.util.ArquillianUtility;

public class ArquillianLaunchConfigurationDelegate
extends JUnitLaunchConfigurationDelegate {
    private static final String ADD_ARQUILLIAN_SUPPORT = "Add Arquillian Support...";
    public static final String ID = "org.jboss.tools.arquillian.core.launchconfig";

    protected IMember[] evaluateTests(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IMember[] tests = super.evaluateTests(configuration, monitor);
        String testMethodName = configuration.getAttribute("org.eclipse.jdt.junit.TESTNAME", "");
        if (testMethodName.length() > 0) {
            return tests;
        }
        ArrayList<IMember> filteredTests = new ArrayList<IMember>();
        IMember[] iMemberArray = tests;
        int n = tests.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member = iMemberArray[n2];
            if (member instanceof IType && ArquillianSearchEngine.isArquillianJUnitTest((IJavaElement)member, true, true)) {
                filteredTests.add(member);
            }
            ++n2;
        }
        return filteredTests.toArray(new IMember[0]);
    }

    protected void preLaunchCheck(final ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        super.preLaunchCheck(configuration, launch, monitor);
        final IStatus[] statuses = new IStatus[2];
        statuses[0] = ArquillianSearchEngine.validateDeployableContainer(this.getJavaProject(configuration));
        if (!statuses[0].isOK()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        statuses[1] = ArquillianLaunchConfigurationDelegate.this.fixArquillianLaunch(configuration, statuses[0]);
                    }
                    catch (CoreException e) {
                        ArquillianCoreActivator.log(e);
                    }
                }
            });
            if (statuses[1].getSeverity() == 8) {
                monitor.setCanceled(true);
            }
            return;
        }
    }

    private IStatus fixArquillianLaunch(ILaunchConfiguration configuration, IStatus status) throws CoreException {
        ClasspathFixProcessor.ClasspathFixProposal[] fixProposals = status.getCode() == 0 ? new ClasspathFixProcessor.ClasspathFixProposal[]{new ArquillianLaunchFixProposal(configuration, "org.jboss.tools.arquillian.ui.action.addArquillianSupport", "Add Arquillian Support", true, 15)} : new ClasspathFixProcessor.ClasspathFixProposal[]{new ArquillianLaunchFixProposal(configuration, "org.jboss.tools.arquillian.ui.action.addArquillianProfiles", "Add Arquillian Profiles", true, 15), new ArquillianLaunchFixProposal(configuration, "org.eclipse.m2e.profiles.ui.commands.selectMavenProfileCommand", "Select Maven Profiles", true, 15)};
        LaunchFixSelectionDialog dialog = new LaunchFixSelectionDialog(ArquillianUtility.getShell(), configuration, ArquillianUtility.getJavaProject(configuration), status.getMessage(), fixProposals);
        if (dialog.open() == 1) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public static void openLaunchConfiguration(ILaunchConfiguration configuration) {
        LaunchConfigurationManager lcManager = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        LaunchGroupExtension group = lcManager.getLaunchGroup("org.eclipse.debug.ui.launchGroup.debug");
        LaunchConfigurationsDialog dialog = new LaunchConfigurationsDialog(ArquillianUtility.getShell(), group);
        if (configuration != null) {
            StructuredSelection selection = new StructuredSelection((Object)configuration);
            dialog.setInitialSelection((IStructuredSelection)selection);
            dialog.setOpenMode(3);
        } else {
            dialog.setOpenMode(2);
        }
        dialog.open();
    }

    private static class ArquillianLaunchFixProposal
    extends ClasspathFixProcessor.ClasspathFixProposal {
        private int relevance;
        private ILaunchConfiguration configuration;
        private String actionId;
        private boolean select;
        private String message;

        public ArquillianLaunchFixProposal(ILaunchConfiguration configuration, String actionId, String message, boolean select, int relevance) {
            this.configuration = configuration;
            this.relevance = relevance;
            this.actionId = actionId;
            this.select = select;
            this.message = message;
        }

        public String getAdditionalProposalInfo() {
            return this.message;
        }

        public Change createChange(IProgressMonitor monitor) throws CoreException {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            ArquillianUtility.runAction(this.configuration, this.actionId, this.select);
            return new NullChange();
        }

        public String getDisplayString() {
            return this.message;
        }

        public Image getImage() {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
        }

        public int getRelevance() {
            return this.relevance;
        }

        public String getActionId() {
            return this.actionId;
        }
    }

    private static class LaunchFixSelectionDialog
    extends MessageDialog
    implements SelectionListener,
    IDoubleClickListener {
        private final ClasspathFixProcessor.ClasspathFixProposal[] fixProposals;
        private final IJavaProject fProject;
        private TableViewer fFixSelectionTable;
        private Button fNoActionRadio;
        private Button fOpenBuildPathRadio;
        private Button fOpenLaunchConfiguration;
        private Button fPerformFix;
        private ArquillianLaunchFixProposal selectedFix;
        private IResourceChangeListener resourceChangeListener;
        private ILaunchConfiguration fConfiguration;
        private static final String BUILD_PATH_PAGE_ID = "org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage";
        private static final String BUILD_PATH_BLOCK = "block_until_buildpath_applied";

        public LaunchFixSelectionDialog(Shell parent, ILaunchConfiguration configuration, IJavaProject project, String message, ClasspathFixProcessor.ClasspathFixProposal[] fixProposals) {
            super(parent, "Arquillian JUnit test", null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.fConfiguration = configuration;
            this.fProject = project;
            this.fixProposals = fixProposals;
            this.selectedFix = null;
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createCustomArea(Composite composite) {
            this.fNoActionRadio = new Button(composite, 16);
            this.fNoActionRadio.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.fNoActionRadio.setText("&Not now");
            this.fNoActionRadio.addSelectionListener((SelectionListener)this);
            this.fOpenBuildPathRadio = new Button(composite, 16);
            this.fOpenBuildPathRadio.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.fOpenBuildPathRadio.setText("&Open the build path property page");
            this.fOpenBuildPathRadio.addSelectionListener((SelectionListener)this);
            this.fOpenLaunchConfiguration = new Button(composite, 16);
            this.fOpenLaunchConfiguration.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.fOpenLaunchConfiguration.setText("Open the &Launch Configuration");
            this.fOpenLaunchConfiguration.addSelectionListener((SelectionListener)this);
            if (this.fixProposals.length > 0) {
                this.fPerformFix = new Button(composite, 16);
                this.fPerformFix.setLayoutData((Object)new GridData(16384, 128, false, false));
                this.fPerformFix.setText("&Perform the following action:");
                this.fPerformFix.addSelectionListener((SelectionListener)this);
                this.fFixSelectionTable = new TableViewer(composite, 2052);
                this.fFixSelectionTable.setContentProvider((IContentProvider)new ArrayContentProvider());
                this.fFixSelectionTable.setLabelProvider((IBaseLabelProvider)new LaunchFixLabelProvider());
                this.fFixSelectionTable.setComparator(new ViewerComparator());
                this.fFixSelectionTable.addDoubleClickListener((IDoubleClickListener)this);
                this.fFixSelectionTable.setInput((Object)this.fixProposals);
                this.fFixSelectionTable.setSelection((ISelection)new StructuredSelection((Object)this.fixProposals[0]));
                GridData gridData = new GridData(4, 4, true, true);
                gridData.heightHint = this.convertHeightInCharsToPixels(4);
                gridData.horizontalIndent = this.convertWidthInCharsToPixels(2);
                this.fFixSelectionTable.getControl().setLayoutData((Object)gridData);
                this.fNoActionRadio.setSelection(false);
                this.fOpenBuildPathRadio.setSelection(false);
                this.fOpenLaunchConfiguration.setSelection(false);
                this.fPerformFix.setSelection(true);
            } else {
                this.fNoActionRadio.setSelection(true);
                this.fOpenBuildPathRadio.setSelection(false);
                this.fOpenLaunchConfiguration.setSelection(false);
            }
            this.updateEnableStates();
            this.resourceChangeListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    IStatus status = ArquillianSearchEngine.validateDeployableContainer(LaunchFixSelectionDialog.this.fProject);
                    if (status.isOK()) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                LaunchFixSelectionDialog.this.setReturnCode(0);
                                LaunchFixSelectionDialog.this.close();
                            }
                        });
                    }
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 16);
            return composite;
        }

        private void updateEnableStates() {
            if (this.fPerformFix != null) {
                this.fFixSelectionTable.getTable().setEnabled(this.fPerformFix.getSelection());
            }
        }

        public boolean close() {
            if (this.resourceChangeListener != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
                this.resourceChangeListener = null;
            }
            return super.close();
        }

        protected void buttonPressed(int buttonId) {
            ArquillianLaunchFixProposal fix;
            if (buttonId == 1) {
                super.buttonPressed(buttonId);
                return;
            }
            this.selectedFix = null;
            if (buttonId == 0) {
                IStructuredSelection selection;
                Object firstElement;
                if (this.fNoActionRadio.getSelection()) {
                    super.buttonPressed(buttonId);
                } else if (this.fOpenBuildPathRadio.getSelection()) {
                    String id = BUILD_PATH_PAGE_ID;
                    HashMap<String, Boolean> input = new HashMap<String, Boolean>();
                    input.put(BUILD_PATH_BLOCK, Boolean.TRUE);
                    if (PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)this.fProject, (String)id, (String[])new String[]{id}, input).open() != 0) {
                        return;
                    }
                } else if (this.fOpenLaunchConfiguration.getSelection()) {
                    ArquillianLaunchConfigurationDelegate.openLaunchConfiguration(this.fConfiguration);
                    this.setReturnCode(1);
                    this.close();
                } else if (this.fFixSelectionTable != null && (firstElement = (selection = (IStructuredSelection)this.fFixSelectionTable.getSelection()).getFirstElement()) instanceof ArquillianLaunchFixProposal) {
                    this.selectedFix = (ArquillianLaunchFixProposal)((Object)firstElement);
                }
            }
            if ((fix = this.getSelectedClasspathFix()) != null) {
                try {
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    Change change = fix.createChange((IProgressMonitor)monitor);
                    new PerformChangeOperation(change).run((IProgressMonitor)monitor);
                    IStatus status = ArquillianSearchEngine.validateDeployableContainer(this.fProject);
                    if (status.isOK()) {
                        super.okPressed();
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.cancelPressed();
                }
                catch (Exception e) {
                    ArquillianCoreActivator.log(e);
                }
            }
        }

        public ArquillianLaunchFixProposal getSelectedClasspathFix() {
            return this.selectedFix;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.updateEnableStates();
        }

        public void widgetSelected(SelectionEvent e) {
            this.updateEnableStates();
        }

        public void doubleClick(DoubleClickEvent event) {
            this.okPressed();
        }

        static class LaunchFixLabelProvider
        extends LabelProvider {
            LaunchFixLabelProvider() {
            }

            public Image getImage(Object element) {
                if (element instanceof ClasspathFixProcessor.ClasspathFixProposal) {
                    ClasspathFixProcessor.ClasspathFixProposal classpathFixProposal = (ClasspathFixProcessor.ClasspathFixProposal)element;
                    return classpathFixProposal.getImage();
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof ClasspathFixProcessor.ClasspathFixProposal) {
                    ClasspathFixProcessor.ClasspathFixProposal classpathFixProposal = (ClasspathFixProcessor.ClasspathFixProposal)element;
                    return classpathFixProposal.getDisplayString();
                }
                return null;
            }
        }
    }
}

