/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.jboss.tools.arquillian.core.internal.archives.ArchiveContainer;
import org.jboss.tools.arquillian.core.internal.classpath.ArquillianClassLoader;
import org.jboss.tools.arquillian.core.internal.dependencies.DependencyCache;
import org.jboss.tools.arquillian.core.internal.util.ArquillianUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ArquillianCoreActivator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.jboss.tools.arquillian.core";
    private static Map<String, ArquillianClassLoader> loaders = new HashMap<String, ArquillianClassLoader>();
    private static ArquillianCoreActivator plugin;
    private static BundleContext context;
    private ServiceTracker parserTracker = null;
    private ScopedPreferenceStore preferenceStore;
    private IElementChangedListener elementChangedListener = new IElementChangedListener(){

        public void elementChanged(ElementChangedEvent event) {
            IJavaElementDelta delta = event.getDelta();
            this.processDelta(delta);
        }

        private boolean processDelta(IJavaElementDelta delta) {
            IJavaElementDelta[] affectedChildren;
            int kind = delta.getKind();
            int flags = delta.getFlags();
            IJavaElement element = delta.getElement();
            int elementType = element.getElementType();
            if (this.isClassPathChange(delta)) {
                this.cleanup(element.getJavaProject());
                return true;
            }
            if (elementType == 2) {
                if ((flags & 0x600) != 0) {
                    this.cleanup(element.getJavaProject());
                    return true;
                }
                if ((flags & 0x200000) != 0) {
                    this.cleanup(element.getJavaProject());
                    return true;
                }
                if (kind == 1) {
                    this.cleanup(element.getJavaProject());
                    return true;
                }
            }
            IJavaElementDelta[] iJavaElementDeltaArray = affectedChildren = delta.getAffectedChildren();
            int n = affectedChildren.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta d = iJavaElementDeltaArray[n2];
                if (this.processDelta(d)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void cleanup(IJavaProject javaProject) {
            ArquillianCoreActivator.this.removeProjectLoader(javaProject.getProject());
            ArchiveContainer.remove((IResource)javaProject.getProject());
            DependencyCache.removeDependencies((IResource)javaProject.getProject());
        }

        private boolean isClassPathChange(IJavaElementDelta delta) {
            if (delta.getElement().getElementType() != 3) {
                return false;
            }
            int flags = delta.getFlags();
            return delta.getKind() == 4 && (flags & 0x40) != 0 || (flags & 0x80) != 0 || (flags & 0x100) != 0;
        }
    };
    private IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() != 1) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource instanceof IWorkspaceRoot) {
                            return true;
                        }
                        if (resource instanceof IProject) {
                            IProject project;
                            if ((delta.getFlags() & 0x4000) != 0 && (project = (IProject)resource).isOpen() && project.hasNature("org.jboss.tools.arquillian.core.arquillianNature")) {
                                ArquillianCoreActivator.this.fixProject(project);
                            }
                            return false;
                        }
                        return false;
                    }
                });
            }
            catch (CoreException e) {
                ArquillianCoreActivator.log(e);
            }
        }
    };
    private ILaunchConfigurationListener launchConfigurationListener = new ILaunchConfigurationListener(){

        public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        }

        public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        }

        public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            if (configuration.getName() != null && configuration.getName().startsWith("jbossTempJavaApplication")) {
                return;
            }
            IPreferenceStore prefs = ArquillianCoreActivator.getDefault().getPreferenceStore();
            boolean enabled = prefs.getBoolean("enableDefaultVMArguments");
            if (!enabled) {
                return;
            }
            try {
                String arguments;
                boolean add;
                String typeId = configuration.getType().getIdentifier();
                boolean bl = add = prefs.getBoolean("addDefaultVMArgumentstoJUnitTestNG") && ("org.eclipse.jdt.junit.launchconfig".equals(typeId) || "org.testng.eclipse.launchconfig".equals(typeId));
                if ((add || "org.jboss.tools.arquillian.core.launchconfig".equals(typeId)) && (arguments = prefs.getString("defaultVMArguments")) != null && !arguments.isEmpty()) {
                    arguments = arguments.trim();
                    ArquillianUtility.addArguments(configuration, arguments, true);
                }
            }
            catch (CoreException e) {
                ArquillianCoreActivator.log(e);
            }
        }
    };

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        plugin = this;
        context = bundleContext;
        JavaCore.addElementChangedListener((IElementChangedListener)this.elementChangedListener);
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener(this.launchConfigurationListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        boolean firstStart = prefs.getBoolean("firstStart", true);
        if (firstStart) {
            this.fixProjects();
        }
    }

    private void fixProjects() {
        WorkspaceJob job = new WorkspaceJob("Fixing projects"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return Status.OK_STATUS;
                }
                try {
                    IProject[] projects;
                    IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (project.isAccessible() && project.isOpen() && project.hasNature("org.jboss.tools.arquillian.core.arquillianNature")) {
                            ArquillianUtility.addBuilder(project);
                        }
                        ++n2;
                    }
                    IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(ArquillianCoreActivator.PLUGIN_ID);
                    prefs.putBoolean("firstStart", false);
                    prefs.flush();
                }
                catch (Exception e) {
                    ArquillianCoreActivator.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void fixProject(final IProject project) {
        if (project == null || !project.isAccessible()) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob("Fixing the '" + project.getName() + "' project"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return Status.OK_STATUS;
                }
                if (project.isAccessible() && project.hasNature("org.jboss.tools.arquillian.core.arquillianNature")) {
                    ArquillianUtility.addBuilder(project);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        context = null;
        JavaCore.removeElementChangedListener((IElementChangedListener)this.elementChangedListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener(this.launchConfigurationListener);
        if (this.preferenceStore != null) {
            this.preferenceStore.save();
        }
    }

    public static ArquillianCoreActivator getDefault() {
        return plugin;
    }

    public static void log(Exception e, String message) {
        Status status = new Status(4, PLUGIN_ID, message, (Throwable)e);
        plugin.getLog().log((IStatus)status);
    }

    public static void log(Throwable e) {
        Status status = new Status(4, PLUGIN_ID, e.getLocalizedMessage(), e);
        plugin.getLog().log((IStatus)status);
    }

    public static void logError(String message) {
        Status status = new Status(4, PLUGIN_ID, message);
        plugin.getLog().log((IStatus)status);
    }

    public static void logWarning(String message) {
        Status status = new Status(2, PLUGIN_ID, message);
        plugin.getLog().log((IStatus)status);
    }

    public ILog getLog() {
        Bundle bundle = context.getBundle();
        return InternalPlatform.getDefault().getLog(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader(IJavaProject javaProject) {
        ArquillianCoreActivator arquillianCoreActivator = this;
        synchronized (arquillianCoreActivator) {
            block5: {
                if (javaProject != null) break block5;
                return null;
            }
            String projectName = javaProject.getProject().getName();
            ArquillianClassLoader loader = loaders.get(projectName);
            if (loader == null) {
                loader = new ArquillianClassLoader(javaProject);
                loaders.put(projectName, loader);
            }
            return loader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectLoader(IProject project) {
        ArquillianCoreActivator arquillianCoreActivator = this;
        synchronized (arquillianCoreActivator) {
            String projectName = project.getName();
            ArquillianClassLoader loader = loaders.get(projectName);
            if (loader != null) {
                try {
                    loader.close();
                }
                catch (IOException e) {
                    ArquillianCoreActivator.log(e);
                }
                loaders.remove(projectName);
            }
        }
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
        }
        return this.preferenceStore;
    }

    public IPath getStateLocation() {
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        return InternalPlatform.getDefault().getStateLocation(bundle, true);
    }

    public SAXParserFactory getFactory() {
        SAXParserFactory theFactory;
        if (this.parserTracker == null) {
            this.parserTracker = new ServiceTracker(ArquillianCoreActivator.getContext(), SAXParserFactory.class.getName(), null);
            this.parserTracker.open();
        }
        if ((theFactory = (SAXParserFactory)this.parserTracker.getService()) != null) {
            theFactory.setNamespaceAware(true);
        }
        return theFactory;
    }
}

