/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.v7;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.server.internal.v7.IJBoss7Deployment;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;

public class DeploymentMarkerUtils {
    public static final String DEPLOYED = ".deployed";
    public static final String FAILED_DEPLOY = ".failed";
    public static final String DO_DEPLOY = ".dodeploy";
    public static final String DEPLOYING = ".isdeploying";
    public static final String UNDEPLOYING = ".isundeploying";
    public static final String UNDEPLOYED = ".undeployed";
    public static final String SKIP_DEPLOY = ".skipdeploy";
    public static final String PENDING = ".pending";

    private static File getOrCreateBlankFile() throws CoreException {
        IPath p = JBossServerCorePlugin.getDefault().getStateLocation().append("BLANK_FILE");
        if (!p.toFile().exists()) {
            try {
                FileOutputStream out = new FileOutputStream(p.toFile());
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException ioe) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", ioe.getMessage(), (Throwable)ioe));
            }
        }
        return p.toFile();
    }

    public static boolean supportsJBoss7MarkerDeployment(IServer server) {
        return server.loadAdapter(IJBoss7Deployment.class, (IProgressMonitor)new NullProgressMonitor()) != null;
    }

    public static String getDeployedMarker(String file) {
        return String.valueOf(file) + DEPLOYED;
    }

    public static String getUndeployedMarker(String file) {
        return String.valueOf(file) + UNDEPLOYED;
    }

    public static String getFailedMarkerName(String file) {
        return String.valueOf(file) + FAILED_DEPLOY;
    }

    public static String getDoDeployMarkerName(String file) {
        return String.valueOf(file) + DO_DEPLOY;
    }

    public static IStatus removedDeployFailedMarker(IPath module, IFilesystemController controller) throws CoreException {
        IPath folder = module.removeLastSegments(1);
        IPath p = folder.append(DeploymentMarkerUtils.getFailedMarkerName(module.lastSegment()));
        return controller.deleteResource(p, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IStatus removedDeployedMarker(IPath module, IFilesystemController controller) throws CoreException {
        IPath folder = module.removeLastSegments(1);
        IPath p = folder.append(DeploymentMarkerUtils.getDeployedMarker(module.lastSegment()));
        return controller.deleteResource(p, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IStatus removedUndeployedMarker(IPath module, IFilesystemController controller) throws CoreException {
        IPath folder = module.removeLastSegments(1);
        IPath p = folder.append(DeploymentMarkerUtils.getUndeployedMarker(module.lastSegment()));
        return controller.deleteResource(p, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IStatus removeDoDeployMarker(IPath module, IFilesystemController controller) throws CoreException {
        IPath folder = module.removeLastSegments(1);
        IPath p = folder.append(DeploymentMarkerUtils.getDoDeployMarkerName(module.lastSegment()));
        return controller.deleteResource(p, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IStatus createDoDeployMarker(IPath module, IFilesystemController controller) throws CoreException {
        IPath folder = module.removeLastSegments(1);
        IPath p = folder.append(DeploymentMarkerUtils.getDoDeployMarkerName(module.lastSegment()));
        return controller.touchResource(p, (IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean markerExists(IPath module, IFilesystemController controller, String markerId) throws CoreException {
        IPath folder = module.removeLastSegments(1);
        IPath p = folder.append(String.valueOf(module.lastSegment()) + markerId);
        return controller.exists(p, (IProgressMonitor)new NullProgressMonitor());
    }
}

