/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.widget.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.ui.CommonUIMessages;
import org.jboss.tools.common.ui.CommonUIPlugin;
import org.jboss.tools.common.ui.IValidator;
import org.jboss.tools.common.ui.ValidatorFactory;
import org.jboss.tools.common.ui.widget.editor.BaseFieldEditor;
import org.jboss.tools.common.ui.widget.editor.ButtonFieldEditor;
import org.jboss.tools.common.ui.widget.editor.CheckBoxFieldEditor;
import org.jboss.tools.common.ui.widget.editor.ComboFieldEditor;
import org.jboss.tools.common.ui.widget.editor.CompositeEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;
import org.jboss.tools.common.ui.widget.editor.ITaggedFieldEditor;
import org.jboss.tools.common.ui.widget.editor.LabelFieldEditor;
import org.jboss.tools.common.ui.widget.editor.LinkFieldEditor;
import org.jboss.tools.common.ui.widget.editor.TaggedComboFieldEditor;
import org.jboss.tools.common.ui.widget.editor.TaggedRadioFieldEditor;
import org.jboss.tools.common.ui.widget.editor.TextFieldEditor;

public class SwtFieldEditorFactory
implements IFieldEditorFactory {
    @Override
    public IFieldEditor createCheckboxEditor(String name, String label, boolean defaultValue) {
        return this.createCheckboxEditor(name, label, defaultValue, null);
    }

    @Override
    public IFieldEditor createCheckboxEditor(String name, String label, boolean defaultValue, String description) {
        CompositeEditor editor = new CompositeEditor(name, label, defaultValue);
        editor.addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, label, description), new CheckBoxFieldEditor(name, label, defaultValue)});
        return editor;
    }

    @Override
    public ITaggedFieldEditor createComboEditor(String name, String label, List values, Object defaultValue) {
        TaggedComboFieldEditor editor = new TaggedComboFieldEditor(name, label, values, defaultValue, false);
        return editor;
    }

    @Override
    public ITaggedFieldEditor createComboEditor(String name, String label, List values, Object defaultValue, boolean editable) {
        TaggedComboFieldEditor editor = new TaggedComboFieldEditor(name, label, values, defaultValue, editable);
        return editor;
    }

    @Override
    public ITaggedFieldEditor createComboEditor(String name, String label, List values, Object defaultValue, boolean editable, String description) {
        TaggedComboFieldEditor editor = new TaggedComboFieldEditor(name, label, values, defaultValue, editable, description);
        return editor;
    }

    @Override
    public ITaggedFieldEditor createRadioEditor(String name, String label, List<String> labels, List values, Object defaultValue) {
        return this.createRadioEditor(name, label, labels, values, defaultValue, null);
    }

    @Override
    public ITaggedFieldEditor createRadioEditor(String name, String label, List<String> labels, List values, Object defaultValue, String description) {
        TaggedRadioFieldEditor editor = new TaggedRadioFieldEditor(name, label, labels, values, defaultValue, description);
        return editor;
    }

    @Override
    public ITaggedFieldEditor createRadioEditor(String name, String label, List<String> labels, List values, Object defaultValue, String description, List<String> valueDescriptions) {
        TaggedRadioFieldEditor editor = new TaggedRadioFieldEditor(name, label, labels, values, defaultValue, description, valueDescriptions);
        return editor;
    }

    @Override
    public IFieldEditor createTextEditor(String name, String label, String defaultValue) {
        return this.createTextEditor(name, label, defaultValue, null);
    }

    @Override
    public IFieldEditor createTextEditor(String name, String label, String defaultValue, String description) {
        CompositeEditor editor = new CompositeEditor(name, label, defaultValue);
        editor.addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, label, description), new TextFieldEditor(name, label, defaultValue)});
        return editor;
    }

    @Override
    public IFieldEditor createUneditableTextEditor(String name, String label, String defaultValue) {
        CompositeEditor editor = new CompositeEditor(name, label, defaultValue);
        editor.addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, label), new TextFieldEditor(name, label, defaultValue, false)});
        return editor;
    }

    @Override
    public IFieldEditor createBrowseFolderEditor(String name, String label, String defaultValue) {
        CompositeEditor editor = new CompositeEditor(name, label, defaultValue);
        editor.addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, label), new TextFieldEditor(name, label, defaultValue), new ButtonFieldEditor(name, this.createSelectFolderAction(CommonUIMessages.SWT_FIELD_EDITOR_FACTORY_BROWS), (Object)defaultValue)});
        return editor;
    }

    @Override
    public IFieldEditor createBrowseWorkspaceFolderEditor(String name, String label, String defaultValue) {
        ButtonFieldEditor.ButtonPressedAction action = this.createSelectWorkspaceFolderAction(CommonUIMessages.SWT_FIELD_EDITOR_FACTORY_BROWS, defaultValue);
        CompositeEditor editor = new CompositeEditor(name, label, defaultValue);
        editor.addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, label), new TextFieldEditor(name, label, defaultValue), new ButtonFieldEditor(name, action, (Object)defaultValue)});
        action.setFieldEditor(editor);
        return editor;
    }

    @Override
    public IFieldEditor createBrowseSourceFolderEditor(String name, String label, String defaultValue) {
        ButtonFieldEditor.ButtonPressedAction action = this.createSelectSourceFolderAction(CommonUIMessages.SWT_FIELD_EDITOR_FACTORY_BROWS, defaultValue);
        CompositeEditor editor = new CompositeEditor(name, label, defaultValue);
        editor.addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, label), new TextFieldEditor(name, label, defaultValue), new ButtonFieldEditor(name, action, (Object)defaultValue)});
        action.setFieldEditor(editor);
        return editor;
    }

    @Override
    public IFieldEditor createBrowsePackageEditor(String name, String label, String initSourceFolderPath, String defaultValue) {
        SelectJavaPackageAction action = new SelectJavaPackageAction(CommonUIMessages.SWT_FIELD_EDITOR_FACTORY_BROWS, initSourceFolderPath, defaultValue);
        IFieldEditor editor = this.createButtonFieldEditor(name, label, defaultValue, action, ValidatorFactory.NO_ERRORS_VALIDATOR);
        return editor;
    }

    public ButtonFieldEditor.ButtonPressedAction createSelectSourceFolderAction(String buttonName, final String initPath) {
        ButtonFieldEditor.ButtonPressedAction action = new ButtonFieldEditor.ButtonPressedAction(buttonName){
            private String inerInitPath;

            public void run() {
                IProject project;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new JavaElementLabelProvider(), (ITreeContentProvider)new JavaSourceContentProvider());
                dialog.setInput((Object)ResourcesPlugin.getWorkspace());
                String path = this.inerInitPath != null ? this.inerInitPath : initPath;
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                if (resource != null && (project = resource.getProject()) != null && project.isOpen()) {
                    IJavaProject javaProject = EclipseUtil.getJavaProject((IProject)project);
                    try {
                        IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                        int i = 0;
                        while (i < roots.length) {
                            if (roots[i].getKind() == 1 && roots[i].getResource().equals((Object)resource)) {
                                dialog.setInitialSelection((Object)roots[i]);
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (JavaModelException e) {
                        CommonUIPlugin.getDefault().logError(e);
                    }
                }
                dialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if (selection.length > 0 && selection[0] instanceof IPackageFragmentRoot) {
                            return new Status(0, "org.jboss.tools.common.ui", 0, null, null);
                        }
                        return new Status(4, "org.jboss.tools.common.ui", 4, null, null);
                    }
                });
                dialog.setAllowMultiple(false);
                dialog.setTitle(CommonUIMessages.SELECT_WORKSPACE_FOLDER_DIALOG_TITLE);
                dialog.setMessage(CommonUIMessages.SELECT_WORKSPACE_FOLDER_DIALOG_MESSAGE);
                if (dialog.open() == 0) {
                    String value;
                    IPackageFragmentRoot pack = (IPackageFragmentRoot)dialog.getFirstResult();
                    IPath newPath = pack.getResource().getFullPath();
                    this.inerInitPath = value = newPath.toString();
                    this.getFieldEditor().setValue(value);
                }
            }
        };
        return action;
    }

    @Override
    public IFieldEditor createBrowseFileEditor(String name, String label, String defaultValue) {
        CompositeEditor editor = new CompositeEditor(name, label, defaultValue);
        editor.addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, label), new TextFieldEditor(name, label, defaultValue), new ButtonFieldEditor(name, this.createSelectFileAction(CommonUIMessages.SWT_FIELD_EDITOR_FACTORY_BROWS), (Object)defaultValue)});
        return editor;
    }

    @Override
    public IFieldEditor createButtonFieldEditor(String name, String label, String defaultValue, ButtonFieldEditor.ButtonPressedAction action, IValidator validator) {
        return this.createButtonFieldEditor(name, label, defaultValue, action, validator, null);
    }

    @Override
    public IFieldEditor createButtonFieldEditor(String name, String label, String defaultValue, ButtonFieldEditor.ButtonPressedAction action, IValidator validator, String description) {
        CompositeEditor editor = new CompositeEditor(name, label, defaultValue);
        editor.addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, label, description), new TextFieldEditor(name, label, defaultValue), new ButtonFieldEditor(name, action, (Object)defaultValue)});
        return editor;
    }

    @Override
    public IFieldEditor createButtonFieldEditor(String name, String label, String defaultValue, ButtonFieldEditor.ButtonPressedAction[] actions, IValidator validator) {
        CompositeEditor editor = new CompositeEditor(name, label, defaultValue);
        ArrayList<BaseFieldEditor> editors = new ArrayList<BaseFieldEditor>();
        editors.add(new LabelFieldEditor(name, label));
        editors.add(new TextFieldEditor(name, label, defaultValue));
        int i = 0;
        while (i < actions.length) {
            editors.add(new ButtonFieldEditor(name, actions[i], (Object)defaultValue));
            ++i;
        }
        editor.addFieldEditors(editors.toArray(new IFieldEditor[0]));
        return editor;
    }

    @Override
    public IFieldEditor createButtonAndLinkFieldEditor(String name, String label, String defaultValue, ButtonFieldEditor.ButtonPressedAction buttonAction, ButtonFieldEditor.ButtonPressedAction linkAction, IValidator validator) {
        CompositeEditor editor = new CompositeEditor(name, label, defaultValue);
        ArrayList<BaseFieldEditor> editors = new ArrayList<BaseFieldEditor>();
        editors.add(new LabelFieldEditor(name, label));
        editors.add(new TextFieldEditor(name, label, defaultValue));
        editors.add(new ButtonFieldEditor(name, buttonAction, (Object)defaultValue));
        editors.add(new LinkFieldEditor(name, linkAction, (Object)defaultValue));
        editor.addFieldEditors(editors.toArray(new IFieldEditor[0]));
        return editor;
    }

    public ButtonFieldEditor.ButtonPressedAction createSelectFolderAction(String buttonName) {
        return new ButtonFieldEditor.ButtonPressedAction(buttonName){

            public void run() {
                DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
                dialog.setFilterPath(this.getFieldEditor().getValueAsString());
                dialog.setMessage(CommonUIMessages.SWT_FIELD_EDITOR_FACTORY_SELECT_SEAM_HOME_FOLDER);
                dialog.setFilterPath(this.getFieldEditor().getValueAsString());
                String directory = dialog.open();
                if (directory != null) {
                    this.getFieldEditor().setValue(directory);
                }
            }
        };
    }

    public ButtonFieldEditor.ButtonPressedAction createSelectWorkspaceFolderAction(String buttonName, final String initPath) {
        ButtonFieldEditor.ButtonPressedAction action = new ButtonFieldEditor.ButtonPressedAction(buttonName){
            private String inerInitPath;

            public void run() {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setInput((Object)ResourcesPlugin.getWorkspace());
                String path = this.inerInitPath != null ? this.inerInitPath : initPath;
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                if (resource != null) {
                    dialog.setInitialSelection((Object)resource);
                }
                dialog.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        return element instanceof IFolder || element instanceof IProject;
                    }
                });
                dialog.setAllowMultiple(false);
                dialog.setTitle(CommonUIMessages.SELECT_WORKSPACE_FOLDER_DIALOG_TITLE);
                dialog.setMessage(CommonUIMessages.SELECT_WORKSPACE_FOLDER_DIALOG_MESSAGE);
                if (dialog.open() == 0) {
                    String value;
                    IResource res = (IResource)dialog.getFirstResult();
                    IPath newPath = res.getFullPath();
                    this.inerInitPath = value = newPath.toString();
                    this.getFieldEditor().setValue(value);
                }
            }
        };
        return action;
    }

    public ButtonFieldEditor.ButtonPressedAction createSelectFileAction(String buttonName) {
        return new ButtonFieldEditor.ButtonPressedAction(buttonName){

            public void run() {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell());
                dialog.setFilterPath(this.getFieldEditor().getValueAsString());
                dialog.setText(CommonUIMessages.SWT_FIELD_EDITOR_FACTORY_SELECT_SEAM_HOME_FOLDER);
                dialog.setFilterPath(this.getFieldEditor().getValueAsString());
                String directory = dialog.open();
                if (directory != null) {
                    this.getFieldEditor().setValue(directory);
                }
            }
        };
    }

    @Override
    public ButtonFieldEditor.ButtonPressedAction createNotImplementedYetAction(String buttonName) {
        return new ButtonFieldEditor.ButtonPressedAction(buttonName){

            public void run() {
                new MessageDialog(Display.getCurrent().getActiveShell(), CommonUIMessages.SWT_FIELD_EDITOR_FACTORY_ERROR, null, CommonUIMessages.SWT_FIELD_EDITOR_FACTORY_NOT_IMPLEMENTED_YET, 1, new String[]{CommonUIMessages.SWT_FIELD_EDITOR_FACTORY_OK}, 1).open();
            }
        };
    }

    @Override
    public IFieldEditor createComboWithTwoButtons(String name, String label, List values, Object defaultValue, boolean flat, ButtonFieldEditor.ButtonPressedAction action1, ButtonFieldEditor.ButtonPressedAction action2, IValidator validator) {
        CompositeEditor editor = new CompositeEditor(name, label, defaultValue);
        editor.addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, label), new ComboFieldEditor(name, label, values, defaultValue, false), new ButtonFieldEditor(name, action1, defaultValue), new ButtonFieldEditor(name, action2, defaultValue)});
        return editor;
    }

    @Override
    public IFieldEditor createComboWithButton(String name, String label, List values, Object defaultValue, boolean flat, ButtonFieldEditor.ButtonPressedAction action1, IValidator validator) {
        CompositeEditor editor = new CompositeEditor(name, label, defaultValue);
        editor.addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, label), new ComboFieldEditor(name, label, values, defaultValue, false), new ButtonFieldEditor(name, action1, defaultValue)});
        return editor;
    }

    private static class JavaSourceContentProvider
    extends StandardJavaElementContentProvider {
        boolean providePackages = false;

        public JavaSourceContentProvider() {
            super(false);
        }

        public JavaSourceContentProvider(boolean providePackages) {
            this();
            this.providePackages = providePackages;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IPackageFragmentRoot) {
                return this.providePackages;
            }
            return !(element instanceof IPackageFragment);
        }

        public Object[] getChildren(Object element) {
            if (!this.exists(element)) {
                return NO_CHILDREN;
            }
            if (element instanceof IWorkspace) {
                IWorkbenchAdapter adapter = (IWorkbenchAdapter)Util.getAdapter((Object)element, IWorkbenchAdapter.class);
                if (adapter != null) {
                    Object[] children = adapter.getChildren(element);
                    ArrayList<Object> result = new ArrayList<Object>();
                    int i = 0;
                    while (i < children.length) {
                        if (children[i] instanceof IProject && EclipseUtil.getJavaProject((IProject)((IProject)children[i])) != null) {
                            result.add(children[i]);
                        }
                        ++i;
                    }
                    return result.toArray(new Object[0]);
                }
                return new Object[0];
            }
            if (element instanceof IProject && (element = EclipseUtil.getJavaProject((IProject)((IProject)element))) == null) {
                return NO_CHILDREN;
            }
            if (element instanceof IJavaProject) {
                try {
                    return this.getPackageFragmentRoots((IJavaProject)element);
                }
                catch (JavaModelException e) {
                    CommonUIPlugin.getDefault().logError(e);
                    return NO_CHILDREN;
                }
            }
            if (element instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot pkgRoot = (IPackageFragmentRoot)element;
                try {
                    return pkgRoot.getChildren();
                }
                catch (JavaModelException javaModelException) {
                    return NO_CHILDREN;
                }
            }
            return super.getChildren(element);
        }

        protected Object[] getPackageFragmentRoots(IJavaProject project) throws JavaModelException {
            if (!project.getProject().isOpen()) {
                return NO_CHILDREN;
            }
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            ArrayList<IPackageFragmentRoot> list = new ArrayList<IPackageFragmentRoot>(roots.length);
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                if (!this.isProjectPackageFragmentRoot(root) && root.getKind() == 1) {
                    list.add(root);
                }
                ++i;
            }
            return list.toArray();
        }
    }

    private static class SelectJavaPackageAction
    extends ButtonFieldEditor.ButtonPressedAction {
        private String defaultSourceFolderPath;

        public SelectJavaPackageAction(String buttonName, String defaultSourceFolderPath, String defaultPackageName) {
            super(buttonName);
            this.defaultSourceFolderPath = defaultSourceFolderPath;
        }

        public void run() {
            String sourceFolder = (String)this.getFieldEditor().getData("source.folder.path");
            if (sourceFolder == null) {
                sourceFolder = this.defaultSourceFolderPath;
            }
            if (sourceFolder == null) {
                CommonUIPlugin.getDefault().logError("Can't init source folder");
                return;
            }
            IResource initSourceFolder = ResourcesPlugin.getWorkspace().getRoot().findMember(sourceFolder);
            if (initSourceFolder == null) {
                CommonUIPlugin.getDefault().logError("Can't find source folder: " + this.defaultSourceFolderPath);
                return;
            }
            IProject project = initSourceFolder.getProject();
            if (project == null) {
                CommonUIPlugin.getDefault().logError("Can't find project for: " + this.defaultSourceFolderPath);
                return;
            }
            IJavaProject javaProject = EclipseUtil.getJavaProject((IProject)project);
            if (javaProject == null) {
                CommonUIPlugin.getDefault().logError("Can't find java project for: " + this.defaultSourceFolderPath);
                return;
            }
            IPackageFragmentRoot packageFragmentRoot = null;
            try {
                IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1 && roots[i].getResource().equals((Object)initSourceFolder)) {
                        packageFragmentRoot = roots[i];
                        break;
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                CommonUIPlugin.getDefault().logError(e);
            }
            if (packageFragmentRoot == null) {
                packageFragmentRoot = javaProject.getPackageFragmentRoot(javaProject.getResource());
            }
            if (packageFragmentRoot == null) {
                CommonUIPlugin.getDefault().logError("Can't find source folder for project " + project.getName());
                return;
            }
            Object[] packages = null;
            try {
                packages = packageFragmentRoot.getChildren();
            }
            catch (JavaModelException e) {
                CommonUIPlugin.getDefault().logError(e);
            }
            if (packages == null) {
                packages = new IJavaElement[]{};
            }
            String initialValue = this.getFieldEditor().getValue().toString();
            IJavaElement initialElement = null;
            ArrayList<IJavaElement> packagesWithoutDefaultPackage = new ArrayList<IJavaElement>();
            Object[] objectArray = packages;
            int n = packages.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement packageElement = objectArray[n2];
                String packageName = packageElement.getElementName();
                if (packageName.length() > 0) {
                    packagesWithoutDefaultPackage.add(packageElement);
                    if (packageName.equals(initialValue)) {
                        initialElement = packageElement;
                    }
                }
                ++n2;
            }
            packages = packagesWithoutDefaultPackage.toArray(new IJavaElement[packagesWithoutDefaultPackage.size()]);
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
            dialog.setTitle(J2EEUIMessages.PACKAGE_SELECTION_DIALOG_TITLE);
            dialog.setMessage(J2EEUIMessages.PACKAGE_SELECTION_DIALOG_DESC);
            dialog.setEmptyListMessage(J2EEUIMessages.PACKAGE_SELECTION_DIALOG_MSG_NONE);
            dialog.setElements(packages);
            if (initialElement != null) {
                dialog.setInitialSelections(new Object[]{initialElement});
            }
            if (dialog.open() == 0) {
                IPackageFragment fragment = (IPackageFragment)dialog.getFirstResult();
                if (fragment != null) {
                    this.getFieldEditor().setValue(fragment.getElementName());
                } else {
                    this.getFieldEditor().setValue("");
                }
            }
        }
    }
}

