/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.internal.ui.taginfo;

import org.eclipse.angularjs.core.AngularProject;
import org.eclipse.angularjs.core.utils.AngularDOMUtils;
import org.eclipse.angularjs.core.utils.AngularELRegion;
import org.eclipse.angularjs.core.utils.AngularRegionUtils;
import org.eclipse.angularjs.core.utils.AngularScopeHelper;
import org.eclipse.angularjs.core.utils.DOMUtils;
import org.eclipse.angularjs.internal.ui.AngularELWordFinder;
import org.eclipse.angularjs.internal.ui.Trace;
import org.eclipse.angularjs.internal.ui.taginfo.HTMLAngularTernTypeCollector;
import org.eclipse.angularjs.internal.ui.utils.HTMLAngularPrinter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.wst.html.ui.internal.taginfo.HTMLTagInfoHoverProcessor;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tern.ITernFile;
import tern.angular.AngularType;
import tern.angular.modules.Directive;
import tern.angular.modules.DirectiveParameter;
import tern.angular.protocol.TernAngularQuery;
import tern.angular.protocol.type.TernAngularTypeQuery;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.resources.TernDocumentFile;
import tern.eclipse.ide.ui.hover.HTMLTernTypeCollector;
import tern.eclipse.ide.ui.hover.IDEHoverControlCreator;
import tern.eclipse.ide.ui.hover.IDEPresenterControlCreator;
import tern.eclipse.ide.ui.hover.ITernHoverInfoProvider;
import tern.eclipse.jface.text.TernBrowserInformationControlInput;
import tern.scriptpath.ITernScriptPath;
import tern.server.protocol.TernQuery;
import tern.server.protocol.type.ITernTypeCollector;
import tern.utils.StringUtils;

public class HTMLAngularTagInfoHoverProcessor
extends HTMLTagInfoHoverProcessor
implements ITextHoverExtension2,
IInformationProviderExtension2,
ITernHoverInfoProvider {
    private IInformationControlCreator fHoverControlCreator;
    private IDEPresenterControlCreator fPresenterControlCreator;
    private IIDETernProject ternProject;

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        TernBrowserInformationControlInput info = (TernBrowserInformationControlInput)this.getHoverInfo2(textViewer, hoverRegion);
        return info != null ? info.getHtml() : null;
    }

    public Object getHoverInfo2(ITextViewer viewer, IRegion hoverRegion) {
        if (hoverRegion == null || viewer == null || viewer.getDocument() == null) {
            return null;
        }
        int documentOffset = hoverRegion.getOffset();
        String displayText = this.computeHoverHelp(viewer, documentOffset);
        if (displayText == null) {
            return null;
        }
        return new TernBrowserInformationControlInput(null, displayText, 200);
    }

    protected String computeTagAttNameHelp(IDOMNode xmlnode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        if (AngularDOMUtils.hasAngularNature((IDOMNode)xmlnode)) {
            IDOMAttr attr = DOMUtils.getAttrByRegion((IDOMNode)xmlnode, (ITextRegion)region);
            IProject project = DOMUtils.getFile((IDOMNode)attr).getProject();
            Directive directive = AngularDOMUtils.getAngularDirective((IProject)project, (Attr)attr);
            if (directive != null) {
                return HTMLAngularPrinter.getDirectiveInfo(directive);
            }
            DirectiveParameter parameter = AngularDOMUtils.getAngularDirectiveParameter((IProject)project, (Attr)attr);
            if (parameter != null) {
                return HTMLAngularPrinter.getDirectiveParameterInfo(parameter);
            }
        }
        return super.computeTagAttNameHelp(xmlnode, parentNode, flatNode, region);
    }

    protected String computeTagAttValueHelp(IDOMNode xmlnode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region, IDocument document, int documentPosition) {
        if (AngularDOMUtils.hasAngularNature((IDOMNode)xmlnode)) {
            IDOMAttr attr = DOMUtils.getAttrByRegion((IDOMNode)xmlnode, (ITextRegion)region);
            IFile file = DOMUtils.getFile((IDOMNode)attr);
            IProject project = file.getProject();
            Directive directive = AngularDOMUtils.getAngularDirective((IProject)project, (Attr)attr);
            try {
                IIDETernProject ternProject = AngularProject.getTernProject((IProject)project);
                if (directive != null) {
                    Integer expressionOffset;
                    String expression = AngularScopeHelper.getAngularValue((IDOMAttr)attr, (AngularType)directive.getType());
                    String help = this.computeHelp((Node)attr, expression, expressionOffset = Integer.valueOf(documentPosition - attr.getValueRegionStartOffset()), file, document, ternProject, directive.getType());
                    if (!StringUtils.isEmpty((String)help)) {
                        return help;
                    }
                } else {
                    int expressionOffset;
                    String expression;
                    String help;
                    AngularELRegion angularRegion = AngularRegionUtils.getAngularELRegion((String)"XML_TAG_ATTRIBUTE_VALUE", (String)attr.getValue(), (int)(attr.getValueRegionStartOffset() + 1), (int)documentPosition, (IProject)project);
                    if (angularRegion != null && !StringUtils.isEmpty((String)(help = this.computeHelp((Node)attr, expression = angularRegion.getExpression(), expressionOffset = angularRegion.getExpressionOffset(), file, document, ternProject, AngularType.model)))) {
                        return help;
                    }
                }
            }
            catch (Exception e) {
                Trace.trace((byte)3, "Error while tern hover.", e);
            }
        }
        return super.computeTagAttValueHelp(xmlnode, parentNode, flatNode, region);
    }

    protected String computeHoverHelp(ITextViewer textViewer, int documentPosition) {
        ITextRegion region;
        String result = null;
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)documentPosition);
        if (treeNode == null) {
            return null;
        }
        Node node = (Node)treeNode;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode parentNode = (IDOMNode)node;
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(documentPosition);
        if (flatNode != null && (region = flatNode.getRegionAtCharacterOffset(documentPosition)) != null) {
            result = this.computeRegionHelp(treeNode, parentNode, flatNode, region, documentPosition, textViewer.getDocument());
        }
        return result;
    }

    protected String computeRegionHelp(IndexedRegion treeNode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region, int documentPosition, IDocument document) {
        if (region == null) {
            return null;
        }
        if (AngularDOMUtils.hasAngularNature((IDOMNode)parentNode)) {
            String regionType = region.getType();
            if (regionType == "XML_CONTENT") {
                return this.computeAngularExpressionHelp((IDOMNode)treeNode, parentNode, flatNode, region, document, documentPosition);
            }
            if (regionType == "XML_TAG_ATTRIBUTE_VALUE") {
                return this.computeTagAttValueHelp((IDOMNode)treeNode, parentNode, flatNode, region, document, documentPosition);
            }
        }
        return super.computeRegionHelp(treeNode, parentNode, flatNode, region);
    }

    protected String computeAngularExpressionHelp(IDOMNode treeNode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region, IDocument document, int documentPosition) {
        IFile file = DOMUtils.getFile((IDOMNode)treeNode);
        try {
            IIDETernProject ternProject = AngularProject.getTernProject((IProject)file.getProject());
            AngularELRegion angularRegion = AngularRegionUtils.getAngularELRegion((IStructuredDocumentRegion)flatNode, (int)documentPosition, (IProject)file.getProject());
            if (angularRegion != null) {
                String expression = angularRegion.getExpression();
                int expressionOffset = angularRegion.getExpressionOffset() + 1;
                return this.computeHelp((Node)treeNode, expression, expressionOffset, file, document, ternProject, AngularType.model);
            }
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error while tern hover.", e);
        }
        return null;
    }

    protected String computeTagNameHelp(IDOMNode xmlnode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        if (AngularDOMUtils.hasAngularNature((IDOMNode)xmlnode) && xmlnode instanceof Element) {
            Element element = (Element)xmlnode;
            IProject project = DOMUtils.getFile((IDOMNode)xmlnode).getProject();
            Directive directive = AngularDOMUtils.getAngularDirective((IProject)project, (Element)element);
            if (directive != null) {
                return HTMLAngularPrinter.getDirectiveInfo(directive);
            }
        }
        return super.computeTagNameHelp(xmlnode, parentNode, flatNode, region);
    }

    private String computeHelp(Node domNode, String expression, Integer end, IFile file, IDocument document, IIDETernProject ternProject, AngularType angularType) throws Exception {
        TernAngularTypeQuery query = new TernAngularTypeQuery(angularType);
        query.setExpression(expression);
        query.setEnd(end);
        ITernScriptPath scriptPath = AngularScopeHelper.populateScope((Node)DOMUtils.getOwnerElement((Node)domNode), (IFile)file, (AngularType)angularType, (TernAngularQuery)query);
        HTMLTernTypeCollector collector = this.createCollector(angularType);
        this.ternProject = ternProject;
        if (scriptPath != null) {
            ternProject.request((TernQuery)query, query.getFiles(), scriptPath, null, null, (ITernTypeCollector)collector);
        } else {
            TernDocumentFile tf = new TernDocumentFile(file, document);
            ternProject.request((TernQuery)query, query.getFiles(), null, domNode, (ITernFile)tf, (ITernTypeCollector)collector);
        }
        return collector.getInfo();
    }

    private HTMLTernTypeCollector createCollector(AngularType angularType) {
        if (angularType == AngularType.module || angularType == AngularType.controller) {
            return new HTMLAngularTernTypeCollector();
        }
        return new HTMLTernTypeCollector();
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer == null || textViewer.getDocument() == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(offset);
        ITextRegion region = null;
        if (flatNode != null) {
            region = flatNode.getRegionAtCharacterOffset(offset);
        }
        if (region != null) {
            IDOMNode element = DOMUtils.getNodeByOffset((IDocument)textViewer.getDocument(), (int)offset);
            String startSymbol = "{{";
            String endSymbol = "}}";
            try {
                AngularProject angularProject = AngularProject.getAngularProject((IProject)DOMUtils.getFile((IDOMNode)element).getProject());
                startSymbol = angularProject.getStartSymbol();
                endSymbol = angularProject.getEndSymbol();
            }
            catch (CoreException coreException) {}
            String regionType = region.getType();
            if ("XML_CONTENT".equals(regionType)) {
                return AngularELWordFinder.findWord(textViewer.getDocument(), offset, startSymbol, endSymbol);
            }
            if (regionType == "XML_TAG_NAME" || regionType == "XML_TAG_ATTRIBUTE_NAME" || regionType == "XML_TAG_ATTRIBUTE_VALUE") {
                try {
                    IDOMAttr attr;
                    IRegion line = textViewer.getDocument().getLineInformationOfOffset(offset);
                    if (offset > line.getOffset() && offset < line.getOffset() + line.getLength() && offset < flatNode.getTextEndOffset(region) && regionType == "XML_TAG_ATTRIBUTE_VALUE" && (AngularDOMUtils.isAngularDirective((IDOMAttr)(attr = DOMUtils.getAttrByOffset((Node)element, (int)offset))) || attr.getValue().contains(startSymbol))) {
                        return AngularELWordFinder.findWord(textViewer.getDocument(), offset, startSymbol, endSymbol);
                    }
                }
                catch (BadLocationException e) {
                    Trace.trace((byte)1, "Error while hovering.", e);
                }
            }
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new IDEHoverControlCreator((IInformationControlCreator)this.getInformationPresenterControlCreator(), (ITernHoverInfoProvider)this);
        }
        return this.fHoverControlCreator;
    }

    public IDEPresenterControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new IDEPresenterControlCreator((ITernHoverInfoProvider)this);
        }
        return this.fPresenterControlCreator;
    }

    public IIDETernProject getTernProject() {
        return this.ternProject;
    }

    public ITernFile getFile() {
        return null;
    }

    public Integer getOffset() {
        return null;
    }
}

