/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyEnablementEvent;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.PropertyValidationEvent;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ElementDisposeEvent;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.AndFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.ISapphireHint;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.forms.FormComponentDef;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.PropertyEditorDef;
import org.eclipse.sapphire.ui.forms.swt.CheckBoxListPropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentationFactory;
import org.eclipse.sapphire.ui.forms.swt.SlushBucketPropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.TablePropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.TextFieldPropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.CheckBoxGroupPropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.CheckBoxPropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.EnumPropertyEditorPresentationFactory;
import org.eclipse.sapphire.ui.forms.swt.internal.NamedValuesPropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.PopUpListFieldPropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.RadioButtonGroupPropertyEditorPresentation;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.widgets.Composite;

public final class PropertyEditorPart
extends FormComponentPart {
    public static final String RELATED_CONTROLS = "related-controls";
    public static final String BROWSE_BUTTON = "browse-button";
    public static final String DATA_BINDING = "binding";
    private static final List<PropertyEditorPresentationFactory> FACTORIES = new ArrayList<PropertyEditorPresentationFactory>();
    @Text(value="Property editor''s property reference path \"{0}\" is invalid.")
    private static LocalizableText invalidPath;
    @Text(value="Child property path \"{1}\" is invalid for \"{0}\".")
    private static LocalizableText invalidChildPropertyPath;
    private Property property;
    private List<ModelPath> childPropertyPaths;
    private Map<Element, Map<ModelPath, PropertyEditorPart>> childPropertyEditors;
    private Map<String, Object> hints;
    private List<FormComponentPart> relatedContentParts;
    private Listener propertyValidationListener;
    private FunctionResult labelFunctionResult;

    static {
        FACTORIES.add(new CheckBoxPropertyEditorPresentation.Factory());
        FACTORIES.add(new RadioButtonGroupPropertyEditorPresentation.Factory());
        FACTORIES.add(new PopUpListFieldPropertyEditorPresentation.Factory());
        FACTORIES.add(new EnumPropertyEditorPresentationFactory());
        FACTORIES.add(new NamedValuesPropertyEditorPresentation.Factory());
        FACTORIES.add(new TextFieldPropertyEditorPresentation.Factory());
        FACTORIES.add(new CheckBoxGroupPropertyEditorPresentation.HorizontalFactory());
        FACTORIES.add(new CheckBoxGroupPropertyEditorPresentation.VerticalFactory());
        FACTORIES.add(new CheckBoxListPropertyEditorPresentation.EnumFactory());
        FACTORIES.add(new SlushBucketPropertyEditorPresentation.Factory());
        FACTORIES.add(new TablePropertyEditorPresentation.Factory());
        LocalizableText.init(PropertyEditorPart.class);
    }

    @Override
    protected void init() {
        super.init();
        ISapphireUiDef rootdef = (ISapphireUiDef)this.definition.nearest(ISapphireUiDef.class);
        PropertyEditorDef propertyEditorPartDef = (PropertyEditorDef)this.definition;
        String propertyEditorPath = this.substituteParams(propertyEditorPartDef.getProperty().text());
        this.property = this.getModelElement().property(new ModelPath(propertyEditorPath));
        if (this.property == null) {
            throw new RuntimeException(invalidPath.format(new Object[]{propertyEditorPath}));
        }
        this.property.empty();
        ListFactory childPropertiesListFactory = ListFactory.start();
        ElementType type = this.property.definition().getType();
        if (type != null) {
            if (propertyEditorPartDef.getChildProperties().isEmpty()) {
                for (PropertyDef childProperty : type.properties()) {
                    if (!(childProperty instanceof ValueProperty)) continue;
                    childPropertiesListFactory.add((Object)new ModelPath(childProperty.name()));
                }
            } else {
                for (PropertyEditorDef childPropertyEditor : propertyEditorPartDef.getChildProperties()) {
                    ModelPath childPropertyPath = new ModelPath((String)childPropertyEditor.getProperty().content());
                    boolean invalid = false;
                    if (childPropertyPath.length() == 0) {
                        invalid = true;
                    } else {
                        ElementType t = type;
                        int i = 0;
                        int n = childPropertyPath.length();
                        while (i < n && !invalid) {
                            ModelPath.Segment segment = childPropertyPath.segment(i);
                            if (segment instanceof ModelPath.PropertySegment) {
                                PropertyDef p = t.property(((ModelPath.PropertySegment)segment).getPropertyName());
                                if (p instanceof ValueProperty) {
                                    if (i + 1 != n) {
                                        invalid = true;
                                    }
                                } else if (p instanceof ImpliedElementProperty) {
                                    if (i + 1 == n) {
                                        invalid = true;
                                    } else {
                                        t = p.getType();
                                    }
                                } else {
                                    invalid = true;
                                }
                            } else {
                                invalid = true;
                            }
                            ++i;
                        }
                    }
                    if (invalid) {
                        String msg = invalidChildPropertyPath.format(new Object[]{this.property.name(), childPropertyPath.toString()});
                        ((LoggingService)Sapphire.service(LoggingService.class)).logError(msg);
                        continue;
                    }
                    childPropertiesListFactory.add((Object)childPropertyPath);
                }
            }
        }
        this.childPropertyPaths = childPropertiesListFactory.result();
        this.childPropertyEditors = new HashMap<Element, Map<ModelPath, PropertyEditorPart>>();
        if (this.property instanceof ElementList || this.property instanceof ElementHandle) {
            this.propertyValidationListener = new FilteredListener<PropertyEvent>(){

                protected void handleTypedEvent(PropertyEvent event) {
                    if (!(event instanceof PropertyContentEvent) || !(event.property() instanceof Value)) {
                        PropertyEditorPart.this.refreshValidation();
                    }
                }
            };
            this.property.attach(this.propertyValidationListener, "*");
        } else {
            this.propertyValidationListener = new FilteredListener<PropertyEvent>(){

                protected void handleTypedEvent(PropertyEvent event) {
                    if (event instanceof PropertyValidationEvent || event instanceof PropertyEnablementEvent) {
                        PropertyEditorPart.this.refreshValidation();
                    }
                }
            };
            this.property.attach(this.propertyValidationListener);
        }
        this.hints = new HashMap<String, Object>();
        for (ISapphireHint hint : propertyEditorPartDef.getHints()) {
            String name = hint.getName().text();
            String valueString = hint.getValue().text();
            Serializable parsedValue = valueString;
            if (name.equals("show.header") || name.equals("border") || name.equals("browse.only") || name.equals("read.only")) {
                parsedValue = Boolean.parseBoolean(valueString);
            } else if (name.startsWith("factory") || name.startsWith("aux.text.provider")) {
                parsedValue = rootdef.resolveClass(valueString);
            } else if (name.equals("listeners")) {
                ArrayList contributors = new ArrayList();
                String[] stringArray = valueString.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    Class<?> cl = rootdef.resolveClass(segment.trim());
                    if (cl != null) {
                        contributors.add(cl);
                    }
                    ++n2;
                }
                parsedValue = contributors;
            }
            this.hints.put(name, parsedValue);
        }
        ListFactory relatedContentPartsListFactory = ListFactory.start();
        FilteredListener<PartValidationEvent> relatedContentPartListener = new FilteredListener<PartValidationEvent>(){

            protected void handleTypedEvent(PartValidationEvent event) {
                PropertyEditorPart.this.refreshValidation();
            }
        };
        for (FormComponentDef relatedContentPartDef : propertyEditorPartDef.getRelatedContent()) {
            FormComponentPart relatedContentPart = (FormComponentPart)PropertyEditorPart.create(this, this.property.element(), relatedContentPartDef, this.params);
            relatedContentPart.attach((Listener)relatedContentPartListener);
            relatedContentPartsListFactory.add((Object)relatedContentPart);
        }
        this.relatedContentParts = relatedContentPartsListFactory.result();
    }

    @Override
    protected Function initVisibleWhenFunction() {
        return AndFunction.create((Function[])new Function[]{super.initVisibleWhenFunction(), PropertyEditorPart.createVersionCompatibleFunction(this.property())});
    }

    @Override
    public PropertyEditorDef definition() {
        return (PropertyEditorDef)super.definition();
    }

    @Override
    public Element getLocalModelElement() {
        return this.property.element();
    }

    public Property property() {
        return this.property;
    }

    public List<ModelPath> getChildProperties() {
        return this.childPropertyPaths;
    }

    public PropertyEditorPart getChildPropertyEditor(Element element, PropertyDef property) {
        return this.getChildPropertyEditor(element, new ModelPath(property.name()));
    }

    public PropertyEditorPart getChildPropertyEditor(final Element element, ModelPath property) {
        PropertyEditorPart childPropertyEditorPart;
        Map<ModelPath, PropertyEditorPart> propertyEditorsForElement = this.childPropertyEditors.get(element);
        if (propertyEditorsForElement == null) {
            propertyEditorsForElement = new HashMap<ModelPath, PropertyEditorPart>();
            this.childPropertyEditors.put(element, propertyEditorsForElement);
            final Map<ModelPath, PropertyEditorPart> finalPropertyEditorsForElement = propertyEditorsForElement;
            element.attach((Listener)new FilteredListener<ElementDisposeEvent>(){

                protected void handleTypedEvent(ElementDisposeEvent event) {
                    for (PropertyEditorPart propertyEditor : finalPropertyEditorsForElement.values()) {
                        propertyEditor.dispose();
                    }
                    PropertyEditorPart.this.childPropertyEditors.remove(element);
                }
            });
        }
        if ((childPropertyEditorPart = propertyEditorsForElement.get(property)) == null) {
            PropertyEditorDef childPropertyEditorDef = ((PropertyEditorDef)this.definition).getChildPropertyEditor(property);
            if (childPropertyEditorDef == null) {
                childPropertyEditorDef = (PropertyEditorDef)PropertyEditorDef.TYPE.instantiate();
                childPropertyEditorDef.setProperty(property.toString());
            }
            childPropertyEditorPart = new PropertyEditorPart();
            childPropertyEditorPart.init(this, element, childPropertyEditorDef, this.params);
            childPropertyEditorPart.initialize();
            propertyEditorsForElement.put(property, childPropertyEditorPart);
        }
        return childPropertyEditorPart;
    }

    public String label() {
        return this.label(CapitalizationType.NO_CAPS, true);
    }

    public String label(CapitalizationType capitalizationType, boolean includeMnemonic) {
        PropertyEditorDef def = this.definition();
        if (((Boolean)def.getShowLabel().content()).booleanValue()) {
            if (this.labelFunctionResult == null) {
                this.labelFunctionResult = this.initExpression((Function)def.getLabel().content(), String.class, (Function)Literal.create((Object)this.property.definition().getLabel(false, CapitalizationType.NO_CAPS, true)), new Runnable(){

                    @Override
                    public void run() {
                        PropertyEditorPart.this.broadcast(new SapphirePart.LabelChangedEvent(PropertyEditorPart.this));
                    }
                });
            }
            String label = (String)this.labelFunctionResult.value();
            return LabelTransformer.transform((String)label, (CapitalizationType)capitalizationType, (boolean)includeMnemonic);
        }
        return null;
    }

    public boolean getSpanBothColumns() {
        return (Boolean)this.definition().getSpanBothColumns().content();
    }

    public int getWidth(int defaultValue) {
        Integer width = (Integer)this.definition().getWidth().content();
        return width == null || width < 1 ? defaultValue : width;
    }

    public int getHeight(int defaultValue) {
        Integer height = (Integer)this.definition().getHeight().content();
        return height == null || height < 1 ? defaultValue : height;
    }

    public int getMarginLeft() {
        int marginLeft = (Integer)this.definition().getMarginLeft().content();
        if (marginLeft < 0) {
            marginLeft = 0;
        }
        return marginLeft;
    }

    public <T> T getRenderingHint(String name, T defaultValue) {
        Object hintValue = this.hints == null ? null : this.hints.get(name);
        return (T)(hintValue == null ? defaultValue : hintValue);
    }

    public boolean getRenderingHint(String name, boolean defaultValue) {
        Object hintValue = this.hints == null ? null : this.hints.get(name);
        return hintValue == null ? defaultValue : (Boolean)hintValue;
    }

    public List<FormComponentPart> getRelatedContent() {
        return this.relatedContentParts;
    }

    public int getRelatedContentWidth() {
        Value<Integer> relatedContentWidth = this.definition().getRelatedContentWidth();
        if (relatedContentWidth.validation().ok()) {
            return (Integer)relatedContentWidth.content();
        }
        return (Integer)relatedContentWidth.getDefaultContent();
    }

    @Override
    public FormComponentPresentation createPresentation(SwtPresentation parent, Composite composite) {
        PropertyEditorPresentation presentation = null;
        try {
            Class factoryClass = this.getRenderingHint("factory", null);
            if (factoryClass != null) {
                PropertyEditorPresentationFactory factory = (PropertyEditorPresentationFactory)factoryClass.newInstance();
                presentation = factory.create(this, parent, composite);
            }
        }
        catch (Exception e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        if (presentation == null) {
            for (PropertyEditorPresentationFactory f : FACTORIES) {
                presentation = f.create(this, parent, composite);
                if (presentation != null) break;
            }
        }
        if (presentation == null) {
            throw new IllegalStateException(this.property.toString());
        }
        return presentation;
    }

    @Override
    protected Status computeValidation() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        if (this.property().enabled()) {
            Element element;
            factory.merge(this.property.validation());
            if (this.property instanceof ElementList) {
                for (Element element2 : (ElementList)this.property) {
                    factory.merge(element2.validation());
                }
            } else if (this.property instanceof ElementHandle && (element = ((ElementHandle)this.property).content()) != null) {
                factory.merge(element.validation());
            }
        }
        for (SapphirePart sapphirePart : this.relatedContentParts) {
            factory.merge(sapphirePart.validation());
        }
        return factory.create();
    }

    @Override
    public boolean setFocus() {
        if (this.property().enabled()) {
            this.broadcast(new SapphirePart.FocusReceivedEvent(this));
            return true;
        }
        return false;
    }

    @Override
    public boolean setFocus(ModelPath path) {
        String propertyName;
        ModelPath.Segment head = path.head();
        if (head instanceof ModelPath.PropertySegment && (propertyName = ((ModelPath.PropertySegment)head).getPropertyName()).equals(this.property.name())) {
            return this.setFocus();
        }
        return false;
    }

    public String getActionContext() {
        String context;
        if (this.property.definition() instanceof ValueProperty) {
            context = "Sapphire.ValuePropertyEditor";
        } else if (this.property.definition() instanceof ElementProperty) {
            context = "Sapphire.ElementPropertyEditor";
        } else if (this.property.definition() instanceof ListProperty) {
            context = "Sapphire.ListPropertyEditor";
        } else {
            throw new IllegalStateException();
        }
        return context;
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton(this.getActionContext());
    }

    public boolean isReadOnly() {
        return this.property.definition().isReadOnly() || this.getRenderingHint("read.only", false);
    }

    @Override
    public void dispose() {
        if (this.propertyValidationListener != null && !this.property.disposed()) {
            if (this.property instanceof ElementList) {
                this.property.detach(this.propertyValidationListener, "*");
            } else {
                this.property.detach(this.propertyValidationListener);
            }
        }
        if (this.labelFunctionResult != null) {
            this.labelFunctionResult.dispose();
        }
        for (Map<ModelPath, PropertyEditorPart> propertyEditorsForElement : this.childPropertyEditors.values()) {
            for (PropertyEditorPart propertyEditor : propertyEditorsForElement.values()) {
                propertyEditor.dispose();
            }
        }
        super.dispose();
    }
}

