/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.arquillian.core.ArquillianCoreActivator;
import org.jboss.tools.arquillian.core.internal.util.ArquillianSearchEngine;
import org.jboss.tools.arquillian.ui.internal.markers.RefactoringUtil;

public class AddMissingTypeRefactoring
extends Refactoring {
    private IMarker marker;
    private String deploymentMethodName;
    private String[] deploymentMethods;
    private List<MethodDeclaration> deploymentMethodDeclarations;
    private CompilationUnit astRoot;
    private String className;
    private ICompilationUnit cUnit;
    private IFile file;
    private IExpressionFragment selectedExpression;
    private ASTRewrite rewrite;
    private AST ast;
    private String tempName;
    private ImportRewrite importRewrite;
    private String[] excludedVariableNames;
    private String message;
    private boolean addAllDependentClasses = false;

    public AddMissingTypeRefactoring(IMarker marker) {
        this.marker = marker;
    }

    public String getName() {
        return RefactoringUtil.getQuickFixName(this.marker);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.className = RefactoringUtil.getMissingClassName(this.marker);
        String message = null;
        if (this.className == null) {
            message = "Invalid marker";
        } else {
            this.deploymentMethods = this.getDeploymentMethods();
            if (this.deploymentMethods == null || this.deploymentMethods.length <= 0) {
                message = "Cannot find a deployment method";
            } else {
                this.deploymentMethodName = this.deploymentMethods[0];
            }
        }
        if (message != null) {
            Status status = new Status(4, "org.jboss.tools.arquillian.ui", message);
            return RefactoringStatus.create((IStatus)status);
        }
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.message != null) {
            Status status = new Status(4, "org.jboss.tools.arquillian.ui", this.message);
            return RefactoringStatus.create((IStatus)status);
        }
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.message = null;
        if (this.astRoot == null || this.deploymentMethodName == null) {
            this.message = "Cannot find a deployment method";
            return null;
        }
        MethodDeclaration deploymentMethod = null;
        for (MethodDeclaration md : this.deploymentMethodDeclarations) {
            if (!this.deploymentMethodName.equals(md.getName().getIdentifier())) continue;
            deploymentMethod = md;
            break;
        }
        if (deploymentMethod == null) {
            this.message = "Cannot find a deployment method";
            return null;
        }
        ReturnStatement returnStatement = this.getReturnStatement(deploymentMethod);
        if (returnStatement == null) {
            this.message = "Cannot find a return statement";
            return null;
        }
        TextFileChange result = new TextFileChange(this.file.getName(), this.file);
        MultiTextEdit rootEdit = new MultiTextEdit();
        Expression expression = returnStatement.getExpression();
        this.ast = deploymentMethod.getAST();
        this.rewrite = ASTRewrite.create((AST)this.ast);
        this.importRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)this.astRoot, (boolean)true);
        if (this.astRoot.getAST().hasResolvedBindings()) {
            this.importRewrite.setUseContextToFilterImplicitImports(true);
        }
        if (expression instanceof MethodInvocation) {
            int start = expression.getStartPosition();
            int length = expression.getLength();
            this.selectedExpression = this.getSelectedExpression(new SourceRange(start, length));
            this.tempName = "archive";
            int i = 0;
            while (!this.checkTempName(this.tempName).isOK()) {
                this.tempName = String.valueOf(this.tempName) + i++;
            }
            this.createAndInsertTempDeclaration(start, length);
            this.addReplaceExpressionWithTemp();
            this.createStatements(this.tempName, this.className, deploymentMethod, returnStatement, rootEdit, pm);
        }
        if (expression instanceof SimpleName) {
            String name = ((SimpleName)expression).getIdentifier();
            this.createStatements(name, this.className, deploymentMethod, returnStatement, rootEdit, pm);
        }
        result.setEdit((TextEdit)rootEdit);
        return result;
    }

    private void createStatements(String variableName, String cName, MethodDeclaration deploymentMethod, ReturnStatement returnStatement, MultiTextEdit rootEdit, IProgressMonitor pm) throws JavaModelException, CoreException {
        this.createStatement(variableName, cName, deploymentMethod, returnStatement, rootEdit, pm);
        if (this.addAllDependentClasses) {
            IMarker[] markers;
            HashSet<String> classNames = new HashSet<String>();
            IMarker[] iMarkerArray = markers = this.file.findMarkers("org.jboss.tools.arquillian.core.problem.class", true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                String clazzName;
                IMarker marker = iMarkerArray[n2];
                if (RefactoringUtil.isMissingClassMarker(marker) && (clazzName = RefactoringUtil.getMissingClassName(marker)) != null && !clazzName.equals(this.className) && !classNames.contains(clazzName)) {
                    classNames.add(clazzName);
                }
                ++n2;
            }
            for (String c : classNames) {
                this.createStatement(variableName, c, deploymentMethod, returnStatement, rootEdit, pm);
            }
        }
        rootEdit.addChild(this.rewrite.rewriteAST());
        rootEdit.addChild(this.importRewrite.rewriteImports(pm));
        ArquillianCoreActivator.getDefault().removeProjectLoader(this.file.getProject());
    }

    private RefactoringStatus checkTempName(String newName) {
        RefactoringStatus status = Checks.checkTempName((String)newName, (IJavaElement)this.cUnit);
        if (Arrays.asList(this.getExcludedVariableNames()).contains(newName)) {
            status.addWarning(Messages.format((String)RefactoringCoreMessages.ExtractTempRefactoring_another_variable, (Object)BasicElementLabels.getJavaElementName((String)newName)));
        }
        return status;
    }

    private String[] getExcludedVariableNames() {
        if (this.excludedVariableNames == null) {
            IBinding[] bindings = new ScopeAnalyzer(this.astRoot).getDeclarationsInScope(this.selectedExpression.getStartPosition(), 18);
            this.excludedVariableNames = new String[bindings.length];
            int i = 0;
            while (i < bindings.length) {
                this.excludedVariableNames[i] = bindings[i].getName();
                ++i;
            }
        }
        return this.excludedVariableNames;
    }

    private void addReplaceExpressionWithTemp() throws JavaModelException {
        IASTFragment[] fragmentsToReplace = AddMissingTypeRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
        HashSet<IASTFragment> seen = new HashSet<IASTFragment>();
        int i = 0;
        while (i < fragmentsToReplace.length) {
            IASTFragment fragment = fragmentsToReplace[i];
            if (seen.add(fragment)) {
                SimpleName simpleName = this.ast.newSimpleName(this.tempName);
                fragment.replace(this.rewrite, (ASTNode)simpleName, null);
            }
            ++i;
        }
    }

    private static IASTFragment[] retainOnlyReplacableMatches(IASTFragment[] allMatches) {
        ArrayList<IASTFragment> result = new ArrayList<IASTFragment>(allMatches.length);
        int i = 0;
        while (i < allMatches.length) {
            if (AddMissingTypeRefactoring.canReplace(allMatches[i])) {
                result.add(allMatches[i]);
            }
            ++i;
        }
        return result.toArray(new IASTFragment[result.size()]);
    }

    private static boolean canReplace(IASTFragment fragment) {
        VariableDeclarationFragment vdf;
        ASTNode node = fragment.getAssociatedNode();
        ASTNode parent = node.getParent();
        if (parent instanceof VariableDeclarationFragment && node.equals((Object)(vdf = (VariableDeclarationFragment)parent).getName())) {
            return false;
        }
        if (AddMissingTypeRefactoring.isMethodParameter(node)) {
            return false;
        }
        if (AddMissingTypeRefactoring.isThrowableInCatchBlock(node)) {
            return false;
        }
        if (parent instanceof ExpressionStatement) {
            return false;
        }
        if (AddMissingTypeRefactoring.isLeftValue(node)) {
            return false;
        }
        if (AddMissingTypeRefactoring.isReferringToLocalVariableFromFor((Expression)node)) {
            return false;
        }
        if (AddMissingTypeRefactoring.isUsedInForInitializerOrUpdater((Expression)node)) {
            return false;
        }
        return !(parent instanceof SwitchCase);
    }

    private static boolean isUsedInForInitializerOrUpdater(Expression expression) {
        ASTNode parent = expression.getParent();
        if (parent instanceof ForStatement) {
            ForStatement forStmt = (ForStatement)parent;
            return forStmt.initializers().contains(expression) || forStmt.updaters().contains(expression);
        }
        return false;
    }

    private static List<IVariableBinding> getForInitializedVariables(VariableDeclarationExpression variableDeclarations) {
        ArrayList<IVariableBinding> forInitializerVariables = new ArrayList<IVariableBinding>(1);
        for (VariableDeclarationFragment fragment : variableDeclarations.fragments()) {
            IVariableBinding binding = fragment.resolveBinding();
            if (binding == null) continue;
            forInitializerVariables.add(binding);
        }
        return forInitializerVariables;
    }

    private static boolean isReferringToLocalVariableFromFor(Expression expression) {
        Expression current = expression;
        ASTNode parent = current.getParent();
        while (parent != null && !(parent instanceof BodyDeclaration)) {
            List initializers;
            ForStatement forStmt;
            if (parent instanceof ForStatement && ((forStmt = (ForStatement)parent).initializers().contains(current) || forStmt.updaters().contains(current) || forStmt.getExpression() == current) && (initializers = forStmt.initializers()).size() == 1 && initializers.get(0) instanceof VariableDeclarationExpression) {
                List<IVariableBinding> forInitializerVariables = AddMissingTypeRefactoring.getForInitializedVariables((VariableDeclarationExpression)initializers.get(0));
                ForStatementChecker checker = new ForStatementChecker(forInitializerVariables);
                expression.accept((ASTVisitor)checker);
                if (checker.isReferringToForVariable()) {
                    return true;
                }
            }
            current = parent;
            parent = current.getParent();
        }
        return false;
    }

    private static boolean isThrowableInCatchBlock(ASTNode node) {
        return node instanceof SimpleName && node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof CatchClause;
    }

    private static boolean isLeftValue(ASTNode node) {
        Assignment assignment;
        ASTNode parent = node.getParent();
        if (parent instanceof Assignment && (assignment = (Assignment)parent).getLeftHandSide() == node) {
            return true;
        }
        if (parent instanceof PostfixExpression) {
            return true;
        }
        if (parent instanceof PrefixExpression) {
            PrefixExpression.Operator op = ((PrefixExpression)parent).getOperator();
            if (op.equals(PrefixExpression.Operator.DECREMENT)) {
                return true;
            }
            return op.equals(PrefixExpression.Operator.INCREMENT);
        }
        return false;
    }

    private static boolean isMethodParameter(ASTNode node) {
        return node instanceof SimpleName && node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof MethodDeclaration;
    }

    private IASTFragment[] getMatchingFragments() throws JavaModelException {
        return new IASTFragment[]{this.selectedExpression};
    }

    private void createAndInsertTempDeclaration(int start, int length) throws CoreException {
        SourceRange range = new SourceRange(start, length);
        IExpressionFragment selectionExpression = this.getSelectedExpression(range);
        Expression initializer = selectionExpression.createCopyTarget(this.rewrite, true);
        VariableDeclarationStatement vds = this.createTempDeclaration(initializer);
        this.insertAt(selectionExpression.getAssociatedNode(), (Statement)vds);
    }

    private void insertAt(ASTNode target, Statement declaration) {
        ASTNode parent = target.getParent();
        StructuralPropertyDescriptor locationInParent = target.getLocationInParent();
        while (locationInParent != Block.STATEMENTS_PROPERTY && locationInParent != SwitchStatement.STATEMENTS_PROPERTY) {
            if (locationInParent == IfStatement.THEN_STATEMENT_PROPERTY || locationInParent == IfStatement.ELSE_STATEMENT_PROPERTY || locationInParent == ForStatement.BODY_PROPERTY || locationInParent == EnhancedForStatement.BODY_PROPERTY || locationInParent == DoStatement.BODY_PROPERTY || locationInParent == WhileStatement.BODY_PROPERTY) {
                Block replacement = this.rewrite.getAST().newBlock();
                ListRewrite replacementRewrite = this.rewrite.getListRewrite((ASTNode)replacement, Block.STATEMENTS_PROPERTY);
                replacementRewrite.insertFirst((ASTNode)declaration, null);
                replacementRewrite.insertLast(this.rewrite.createMoveTarget(target), null);
                this.rewrite.replace(target, (ASTNode)replacement, null);
                return;
            }
            target = parent;
            parent = parent.getParent();
            locationInParent = target.getLocationInParent();
        }
        ListRewrite listRewrite = this.rewrite.getListRewrite(parent, (ChildListPropertyDescriptor)locationInParent);
        listRewrite.insertBefore((ASTNode)declaration, target, null);
    }

    private VariableDeclarationStatement createTempDeclaration(Expression initializer) throws CoreException {
        VariableDeclarationFragment vdf = this.ast.newVariableDeclarationFragment();
        vdf.setName(this.ast.newSimpleName(this.tempName));
        vdf.setInitializer(initializer);
        VariableDeclarationStatement vds = this.ast.newVariableDeclarationStatement(vdf);
        vds.setType(this.createTempType());
        return vds;
    }

    private Type createTempType() throws CoreException {
        Expression expression = this.selectedExpression.getAssociatedExpression();
        Type resultingType = null;
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        AST ast = this.rewrite.getAST();
        if (expression instanceof ClassInstanceCreation && (typeBinding == null || typeBinding.getTypeArguments().length == 0)) {
            resultingType = (Type)this.rewrite.createCopyTarget((ASTNode)((ClassInstanceCreation)expression).getType());
        } else if (expression instanceof CastExpression) {
            resultingType = (Type)this.rewrite.createCopyTarget((ASTNode)((CastExpression)expression).getType());
        } else {
            if (typeBinding == null) {
                typeBinding = ASTResolving.guessBindingForReference((ASTNode)expression);
            }
            if (typeBinding != null) {
                typeBinding = Bindings.normalizeForDeclarationUse((ITypeBinding)typeBinding, (AST)ast);
                ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)expression, this.importRewrite);
                resultingType = this.importRewrite.addImport(typeBinding, ast, (ImportRewrite.ImportRewriteContext)context);
            } else {
                resultingType = ast.newSimpleType((Name)ast.newSimpleName("Object"));
            }
        }
        return resultingType;
    }

    private IExpressionFragment getSelectedExpression(SourceRange range) throws JavaModelException {
        if (this.selectedExpression != null) {
            return this.selectedExpression;
        }
        IASTFragment selectedFragment = ASTFragmentFactory.createFragmentForSourceRange((ISourceRange)range, (ASTNode)this.astRoot, (ICompilationUnit)this.cUnit);
        if (selectedFragment instanceof IExpressionFragment && !Checks.isInsideJavadoc((ASTNode)selectedFragment.getAssociatedNode())) {
            this.selectedExpression = (IExpressionFragment)selectedFragment;
        } else if (selectedFragment != null) {
            if (selectedFragment.getAssociatedNode() instanceof ExpressionStatement) {
                ExpressionStatement exprStatement = (ExpressionStatement)selectedFragment.getAssociatedNode();
                Expression expression = exprStatement.getExpression();
                this.selectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)expression);
            } else if (selectedFragment.getAssociatedNode() instanceof Assignment) {
                Assignment assignment = (Assignment)selectedFragment.getAssociatedNode();
                this.selectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)assignment);
            }
        }
        if (this.selectedExpression != null && Checks.isEnumCase((ASTNode)this.selectedExpression.getAssociatedExpression().getParent())) {
            this.selectedExpression = null;
        }
        return this.selectedExpression;
    }

    private void createStatement(String variableName, String cName, MethodDeclaration deploymentMethod, ReturnStatement returnStatement, MultiTextEdit rootEdit, IProgressMonitor pm) throws JavaModelException, CoreException {
        this.importRewrite.addImport(cName);
        MethodInvocation mi = this.ast.newMethodInvocation();
        mi.setExpression((Expression)this.ast.newSimpleName(variableName));
        mi.setName(this.ast.newSimpleName("addClass"));
        int index = cName.lastIndexOf(".");
        String simpleClassName = index >= 0 ? cName.substring(index + 1) : cName;
        Name typeName = this.ast.newName(simpleClassName);
        SimpleType type = this.ast.newSimpleType(typeName);
        TypeLiteral typeLiteral = this.ast.newTypeLiteral();
        typeLiteral.setType((Type)type);
        mi.arguments().add(typeLiteral);
        ExpressionStatement newStatement = this.ast.newExpressionStatement((Expression)mi);
        Block block = deploymentMethod.getBody();
        ListRewrite listRewrite = this.rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
        listRewrite.insertBefore((ASTNode)newStatement, (ASTNode)returnStatement, null);
    }

    private ReturnStatement getReturnStatement(MethodDeclaration deploymentMethod) {
        final HashSet returnStatements = new HashSet();
        deploymentMethod.accept(new ASTVisitor(){

            public boolean visit(ReturnStatement statement) {
                ITypeBinding binding = statement.getExpression().resolveTypeBinding();
                if (ArquillianSearchEngine.isArchiveType((ITypeBinding)binding)) {
                    returnStatements.add(statement);
                }
                return true;
            }
        });
        if (returnStatements.size() != 1) {
            return null;
        }
        return (ReturnStatement)returnStatements.iterator().next();
    }

    public String[] getDeploymentMethods() {
        if (this.deploymentMethods == null) {
            this.deploymentMethodDeclarations = new LinkedList<MethodDeclaration>();
            CompilationUnit root = this.getAST();
            if (root == null) {
                this.deploymentMethods = new String[0];
            } else {
                root.accept(new ASTVisitor(){

                    public boolean visit(MethodDeclaration node) {
                        IMethodBinding binding = node.resolveBinding();
                        if (ArquillianSearchEngine.isDeploymentMethod((IMethodBinding)binding)) {
                            AddMissingTypeRefactoring.this.deploymentMethodDeclarations.add(node);
                        }
                        return false;
                    }
                });
                this.deploymentMethods = new String[this.deploymentMethodDeclarations.size()];
                int i = 0;
                for (MethodDeclaration methodDeclaration : this.deploymentMethodDeclarations) {
                    this.deploymentMethods[i++] = methodDeclaration.getName().getIdentifier();
                }
            }
        }
        return this.deploymentMethods;
    }

    private CompilationUnit getAST() {
        IResource resource = this.marker.getResource();
        if (!(resource instanceof IFile)) {
            return null;
        }
        this.file = (IFile)resource;
        IJavaElement element = JavaCore.create((IFile)this.file);
        if (!(element instanceof ICompilationUnit)) {
            return null;
        }
        this.cUnit = (ICompilationUnit)element;
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setSource(this.cUnit);
        parser.setResolveBindings(true);
        parser.setKind(8);
        this.astRoot = (CompilationUnit)parser.createAST(null);
        return this.astRoot;
    }

    public void setDeploymentMethod(String name) {
        this.deploymentMethodName = name;
    }

    public boolean isAddAllDependentClasses() {
        return this.addAllDependentClasses;
    }

    public void setAddAllDependentClasses(boolean addAllDependentClasses) {
        this.addAllDependentClasses = addAllDependentClasses;
    }

    private static final class ForStatementChecker
    extends ASTVisitor {
        private final Collection<IVariableBinding> fForInitializerVariables;
        private boolean fReferringToForVariable = false;

        public ForStatementChecker(Collection<IVariableBinding> forInitializerVariables) {
            Assert.isNotNull(forInitializerVariables);
            this.fForInitializerVariables = forInitializerVariables;
        }

        public boolean isReferringToForVariable() {
            return this.fReferringToForVariable;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding != null && this.fForInitializerVariables.contains(binding)) {
                this.fReferringToForVariable = true;
            }
            return false;
        }
    }
}

