/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.internal;

import java.util.Set;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.IRuntimeDetector;
import org.osgi.service.prefs.BackingStoreException;

public class RuntimeCorePreferences {
    private static final String ENABLED_DETECTORS = "enabledDetectors";
    private IEclipsePreferences prefs;
    private static RuntimeCorePreferences INSTANCE;

    public static RuntimeCorePreferences getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new RuntimeCorePreferences();
        }
        return INSTANCE;
    }

    public String[] getEnabledRuntimeDetectors() {
        String enabledDetectors = this.getPreferences().get(ENABLED_DETECTORS, null);
        return enabledDetectors == null ? null : enabledDetectors.split(",");
    }

    public void saveEnabledDetectors() {
        this.saveEnabledDetectors(RuntimeCoreActivator.getDefault().getRuntimeDetectors());
    }

    public void saveEnabledDetectors(Set<IRuntimeDetector> allDetectors) {
        StringBuilder builder = new StringBuilder();
        for (IRuntimeDetector detector : allDetectors) {
            if (!detector.isEnabled()) continue;
            builder.append(detector.getId());
            builder.append(",");
        }
        String enabled = builder.toString();
        int index = enabled.lastIndexOf(",");
        if (index != -1) {
            enabled = enabled.substring(0, index);
        }
        this.getPreferences().put(ENABLED_DETECTORS, enabled);
        try {
            this.getPreferences().flush();
        }
        catch (BackingStoreException e) {
            RuntimeCoreActivator.pluginLog().logError((Throwable)e);
        }
    }

    IEclipsePreferences getPreferences() {
        if (this.prefs == null) {
            this.prefs = ConfigurationScope.INSTANCE.getNode("org.jboss.tools.runtime.core");
        }
        return this.prefs;
    }
}

