/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.angularjs.core.utils.StringUtils;
import org.eclipse.angularjs.internal.core.Trace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import tern.TernResourcesManager;
import tern.angular.AngularType;
import tern.angular.modules.AbstractAngularModulesRegistry;
import tern.angular.modules.Directive;
import tern.angular.modules.DirectiveValue;
import tern.angular.modules.IDirectiveCollector;
import tern.angular.modules.IDirectiveSyntax;
import tern.angular.modules.Module;
import tern.angular.modules.Restriction;
import tern.angular.protocol.completions.TernAngularCompletionsQuery;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.server.protocol.IJSONObjectHelper;
import tern.server.protocol.TernQuery;
import tern.server.protocol.completions.ITernCompletionCollector;
import tern.server.protocol.completions.TernCompletionProposalRec;

public class CustomAngularModulesRegistry
extends AbstractAngularModulesRegistry
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private final IProject project;
    private boolean refreshDirectives;
    private final Object lock = new Object();

    public CustomAngularModulesRegistry(IProject project) {
        this.project = project;
        this.clear();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public Directive getDirective(String tagName, String name, Restriction restriction) {
        this.refreshIfNeeded();
        return super.getDirective(tagName, name, restriction);
    }

    public void collectDirectives(String tagName, String directiveName, IDirectiveSyntax syntax, List<Directive> existingDirectives, Restriction restriction, IDirectiveCollector collector) {
        this.refreshIfNeeded();
        super.collectDirectives(tagName, directiveName, syntax, existingDirectives, restriction, collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshIfNeeded() {
        try {
            if (!this.refreshDirectives) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                if (!this.refreshDirectives) {
                    return;
                }
                super.clear();
                IIDETernProject ternProject = TernCorePlugin.getTernProject((IProject)this.project);
                TernAngularCompletionsQuery query = new TernAngularCompletionsQuery(AngularType.directives);
                query.setExpression("");
                ternProject.request((TernQuery)query, query.getFiles(), null, null, null, new ITernCompletionCollector(){

                    public void addProposal(TernCompletionProposalRec proposal, Object completion, IJSONObjectHelper jsonObjectHelper) {
                        String moduleName = jsonObjectHelper.getText(completion, "module");
                        if (!StringUtils.isEmpty(moduleName)) {
                            Module module = CustomAngularModulesRegistry.this.getModule(moduleName);
                            if (module == null) {
                                module = new Module(moduleName);
                                CustomAngularModulesRegistry.this.addModule(module);
                            }
                            ArrayList tagsName = new ArrayList();
                            String restrict = jsonObjectHelper.getText(completion, "restrict");
                            DirectiveValue directiveValue = DirectiveValue.none;
                            new Directive(proposal.name, AngularType.model, null, tagsName, restrict, directiveValue, module);
                        }
                    }
                });
                this.refreshDirectives = false;
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error while refresh custom angular directives.", e);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)this);
            }
        }
        catch (Throwable e) {
            Trace.trace((byte)3, "", e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        switch (resource.getType()) {
            case 2: 
            case 8: {
                return true;
            }
            case 4: {
                IProject project = (IProject)resource;
                return this.project.equals((Object)project);
            }
            case 1: {
                if (TernResourcesManager.isJSFile((Object)resource.getName()) || TernResourcesManager.isHTMLFile((Object)resource)) {
                    this.clear();
                }
                return true;
            }
        }
        return false;
    }

    public void clear() {
        super.clear();
        this.refreshDirectives = true;
    }
}

