/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xml.XMLRootHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.util.RegionHolder;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.StructuredSelectionHelper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class JumpToHyperlink
extends AbstractHyperlink {
    @Override
    protected void doHyperlink(IRegion region) {
        RegionHolder holder = this.getRegionHolder(this.getName(region), region);
        if (holder != null) {
            StructuredSelectionHelper.setSelectionAndRevealInActiveEditor(holder.region);
        } else {
            this.openFileFailed();
        }
    }

    protected String getName(IRegion region) {
        try {
            return Utils.trimQuotes(this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected String getDestinationAxis() {
        return null;
    }

    protected NodeList getRootElementsToSearch(IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            NodeList nodeList = xmlDocument.getChildNodes();
            return nodeList;
        }
        finally {
            smw.dispose();
        }
    }

    protected RegionHolder getRegionHolder(String content, IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            List<Node> elements = this.findElementsByAxis(this.getRootElementsToSearch(region), this.getDestinationAxis());
            if (elements == null || elements.size() == 0) {
                return null;
            }
            int i = elements.size() - 1;
            while (i >= 0) {
                IDOMElement element;
                String text;
                if (elements.get(i) instanceof IDOMElement && content.equals(text = Utils.trimQuotes(this.getElementText((Node)(element = (IDOMElement)elements.get(i)))))) {
                    RegionHolder regionHolder = new RegionHolder((IRegion)new Region(element.getStartOffset(), element.getStartStructuredDocumentRegion().getLength()));
                    return regionHolder;
                }
                --i;
            }
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    protected String getElementText(Node element) {
        String result;
        if (element instanceof IDOMText) {
            return ((IDOMText)element).getData();
        }
        StringBuffer text = new StringBuffer();
        if (element instanceof IDOMElement) {
            Node child = element.getFirstChild();
            while (child != null) {
                if (child instanceof IDOMText) {
                    text.append(((IDOMText)child).getData());
                }
                child = child.getNextSibling();
            }
        }
        if ((result = text.toString()) == null || result.length() == 0) {
            return null;
        }
        return result;
    }

    protected List<Node> findElementsByAxis(NodeList list, String axis) {
        String requiredAxis = axis.toLowerCase();
        ArrayList<Node> elements = new ArrayList<Node>();
        int i = 0;
        while (list != null && i < list.getLength()) {
            if (list.item(i) instanceof IDOMElement) {
                List<Node> add;
                IDOMElement element = (IDOMElement)list.item(i);
                String currentAxis = String.valueOf(XMLRootHyperlinkPartitioner.computeAxis(this.getDocument(), element.getStartOffset())) + "/";
                if ((currentAxis = currentAxis.toLowerCase()).endsWith(requiredAxis)) {
                    elements.add((Node)element);
                }
                if (element.hasChildNodes() && (add = this.findElementsByAxis(element.getChildNodes(), axis)) != null) {
                    elements.addAll(add);
                }
            }
            ++i;
        }
        return elements;
    }

    @Override
    public abstract String getHyperlinkText();
}

