/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.internal.core.parser.token;

import org.jboss.tools.common.el.core.ElCoreMessages;
import org.jboss.tools.common.el.core.parser.ITokenDescription;
import org.jboss.tools.common.el.core.parser.SyntaxError;
import org.jboss.tools.common.el.core.parser.Tokenizer;

public class PrimitiveValueTokenDescription
implements ITokenDescription {
    public static final int PRIMITIVE_VALUE = 6;
    public static PrimitiveValueTokenDescription INSTANCE = new PrimitiveValueTokenDescription();
    private static final String[] OPS_2 = new String[]{"null", "true", "false"};
    static String TYPE_CHAR = "lLfFdD";

    @Override
    public String getName() {
        return ElCoreMessages.PrimitiveValueTokenDescription_Name;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public boolean isStart(Tokenizer tokenizer, int offset) {
        if (this.isNumber(tokenizer, offset)) {
            return true;
        }
        int end = -1;
        boolean canBeFollowedByOperand = true;
        int i = 0;
        while (end < 0 && i < OPS_2.length) {
            if (tokenizer.startsWith(OPS_2[i])) {
                end = offset + OPS_2[i].length();
                canBeFollowedByOperand = false;
            }
            ++i;
        }
        if (end < 0) {
            return false;
        }
        char ch = tokenizer.lookUpChar(end);
        return Character.isWhitespace(ch) || ch == '\u0000' || !Character.isJavaIdentifierPart(ch) || canBeFollowedByOperand && Character.isJavaIdentifierPart(ch);
    }

    private boolean isNumber(Tokenizer tokenizer, int offset) {
        char ch = tokenizer.lookUpChar(offset);
        if (ch == '.') {
            ch = tokenizer.lookUpChar(offset + 1);
        }
        return ch != '\u0000' && Character.isDigit(ch);
    }

    @Override
    public boolean read(Tokenizer tokenizer, int offset) {
        if (this.isNumber(tokenizer, offset)) {
            return this.readNumber(tokenizer, offset);
        }
        int end = -1;
        int i = 0;
        while (end < 0 && i < OPS_2.length) {
            if (tokenizer.startsWith(OPS_2[i])) {
                end = offset + OPS_2[i].length();
            }
            ++i;
        }
        tokenizer.addToken(this.getType(), offset, end);
        return true;
    }

    private boolean readNumber(Tokenizer tokenizer, int offset) {
        int i = offset;
        int dotCount = 1;
        int dotOffset = -1;
        if (tokenizer.startsWith("0x")) {
            i += 2;
            dotCount = 0;
        }
        char ch = '\u0000';
        boolean lastCharIsWrong = false;
        boolean inE = false;
        while ((ch = tokenizer.readNextChar()) != '\u0000') {
            if (ch == '.') {
                if (--dotCount < 0) {
                    lastCharIsWrong = true;
                    break;
                }
                dotOffset = tokenizer.getCurrentIndex() - 1;
            } else if (!Character.isDigit(ch)) {
                char ch1;
                if (TYPE_CHAR.indexOf(ch) >= 0) {
                    ch1 = tokenizer.lookUpChar(i + 1);
                    if (ch1 == '\u0000' || !Character.isJavaIdentifierPart(ch1)) {
                        ++i;
                        break;
                    }
                } else if (ch == 'e' || ch == 'E') {
                    ch1 = tokenizer.lookUpChar(i + 1);
                    char ch2 = tokenizer.lookUpChar(i + 2);
                    if ((ch1 == '+' || ch1 == '-') && Character.isDigit(ch2)) {
                        tokenizer.readNextChar();
                        tokenizer.readNextChar();
                        i += 3;
                        inE = true;
                        dotCount = 0;
                        continue;
                    }
                    if (Character.isDigit(ch1)) {
                        tokenizer.readNextChar();
                        i += 2;
                        inE = true;
                        dotCount = 0;
                        continue;
                    }
                }
                lastCharIsWrong = true;
                break;
            }
            ++i;
        }
        if (lastCharIsWrong) {
            tokenizer.releaseChar();
        }
        if (tokenizer.getLastToken() != null && tokenizer.getLastToken().getType() == 10 && dotCount < 1) {
            SyntaxError error = new SyntaxError(dotOffset, 301);
            error.setProblem(ElCoreMessages.PrimitiveValueTokenDescription_ArgMustResolveToIntegerOrString);
            tokenizer.addSyntaxError(error);
        }
        tokenizer.addToken(this.getType(), offset, i);
        return true;
    }
}

