/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.core.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.tools.common.el.core.parser.IRule;
import org.jboss.tools.common.el.core.parser.ITokenDescription;
import org.jboss.tools.common.el.core.parser.LexicalToken;
import org.jboss.tools.common.el.core.parser.SyntaxError;

public class Tokenizer {
    public static int LITERAL = -10;
    private Map<Integer, ITokenDescription> tokenDescriptions = new HashMap<Integer, ITokenDescription>();
    private Map<Integer, List<IRule>> rules = new HashMap<Integer, List<IRule>>();
    private String sourceString;
    private int index = 0;
    private LexicalToken start;
    private LexicalToken last;
    private int state;
    private Properties context = new Properties();
    List<SyntaxError> errors = new ArrayList<SyntaxError>();
    private static List<SyntaxError> EMPTY = new ArrayList<SyntaxError>();

    public void dispose() {
        this.sourceString = null;
        this.index = 0;
        this.start = null;
        this.last = null;
        this.context.clear();
        this.errors.clear();
    }

    public void setTokenDescriptions(ITokenDescription[] ds) {
        this.tokenDescriptions.clear();
        int i = 0;
        while (i < ds.length) {
            int type = ds[i].getType();
            if (this.tokenDescriptions.containsKey(type)) {
                throw new IllegalArgumentException("Token type " + type + " is not unique.");
            }
            this.tokenDescriptions.put(type, ds[i]);
            ++i;
        }
    }

    public ITokenDescription getTokenDescription(int id) {
        return this.tokenDescriptions.get(id);
    }

    public void setRules(IRule[] rules) {
        this.rules.clear();
        int i = 0;
        while (i < rules.length) {
            int[] ss = rules[i].getStartStates();
            int j = 0;
            while (j < ss.length) {
                List<IRule> rs = this.rules.get(ss[j]);
                if (rs == null) {
                    rs = new ArrayList<IRule>();
                    this.rules.put(ss[j], rs);
                }
                rs.add(rules[i]);
                ++j;
            }
            ++i;
        }
    }

    public LexicalToken parse(String sourceString) {
        return this.parse(sourceString, 0, sourceString.length());
    }

    public LexicalToken parse(String sourceString, int initialOffset, int length) {
        this.sourceString = sourceString;
        this.errors.clear();
        this.index = initialOffset;
        this.last = this.start = new LexicalToken(initialOffset, 0, "", -1000);
        this.state = 0;
        int lastIndex = initialOffset + length;
        if (lastIndex > sourceString.length()) {
            lastIndex = sourceString.length();
        }
        while (this.index < lastIndex) {
            boolean done = false;
            List<IRule> rs = this.rules.get(this.state);
            for (IRule rule : rs) {
                int[] ts = rule.getTokenTypes(this.state);
                int j = 0;
                while (!done && j < ts.length) {
                    ITokenDescription td = this.tokenDescriptions.get(ts[j]);
                    if (td != null && td.isStart(this, this.index)) {
                        td.read(this, this.index);
                        this.state = rule.getFinalState(this.state, ts[j]);
                        done = true;
                    }
                    ++j;
                }
            }
            if (done) continue;
            if (this.state == 0 || this.state == -1) {
                char ch = this.readNextChar();
                if (ch != '\u0000') continue;
                break;
            }
            SyntaxError error = new SyntaxError(this.index, this.state);
            String problem = null;
            for (IRule rule : rs) {
                problem = rule.getProblem(this.state, this);
                if (problem != null) break;
            }
            error.setProblem(problem);
            this.errors.add(error);
            this.state = -1;
        }
        LexicalToken result = this.start.getNextToken();
        if (result != null) {
            result.makeItFirst();
        }
        if (this.last != null && this.last.getStart() + this.last.getLength() < sourceString.length() && this.last.getType() != LITERAL) {
            int lastEnd = this.last.getStart() + this.last.getLength();
            LexicalToken t = new LexicalToken(lastEnd, length, this.getCharSequence(lastEnd, sourceString.length()), LITERAL);
            this.last.setNextToken(t);
            this.last = t;
        }
        return result;
    }

    public List<SyntaxError> getErrors() {
        if (this.errors.size() == 0) {
            return EMPTY;
        }
        ArrayList<SyntaxError> copy = new ArrayList<SyntaxError>();
        copy.addAll(this.errors);
        return copy;
    }

    public void addSyntaxError(SyntaxError error) {
        this.errors.add(error);
    }

    public void addToken(int type, int start, int end) {
        if (end < 0) {
            return;
        }
        int lastEnd = this.last.getStart() + this.last.getLength();
        if (start > lastEnd) {
            int length = start - lastEnd;
            LexicalToken t = new LexicalToken(lastEnd, length, this.getCharSequence(lastEnd, start), LITERAL);
            this.last.setNextToken(t);
            this.last = t;
            this.index = start;
        }
        LexicalToken t = new LexicalToken(start, end - start, this.getCharSequence(start, end), type);
        this.last.setNextToken(t);
        this.last = t;
        this.index = end;
    }

    public Properties getContext() {
        return this.context;
    }

    private CharSequence getCharSequence(int start, int end) {
        String text = this.sourceString.substring(start, end);
        return text.subSequence(0, text.length());
    }

    public char readNextChar() {
        char c = '\u0000';
        if (this.index < this.sourceString.length()) {
            c = this.sourceString.charAt(this.index);
        }
        ++this.index;
        return c;
    }

    public char lookUpChar(int i) {
        return i < 0 || this.sourceString.length() <= i ? (char)'\u0000' : this.sourceString.charAt(i);
    }

    public void releaseChar() {
        if (this.index > 0) {
            --this.index;
        }
    }

    public boolean startsWith(String s) {
        int l = this.index + s.length();
        if (l > this.sourceString.length()) {
            return false;
        }
        int i = this.index;
        while (i < l) {
            if (this.lookUpChar(i) != s.charAt(i - this.index)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public LexicalToken getLastToken() {
        return this.last;
    }

    public int getState() {
        return this.state;
    }

    public int getCurrentIndex() {
        return this.index;
    }
}

