/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.editor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;

public class ServerWorkingCopyPropertyCommand
extends ServerCommand {
    public static int POST_EXECUTE = 1;
    public static int POST_UNDO = 2;
    public static int POST_REDO = 3;
    protected String oldVal;
    protected String newVal;
    protected String key;
    protected Text text;
    protected ModifyListener listener;
    protected IServerWorkingCopy wc;

    public ServerWorkingCopyPropertyCommand(IServerWorkingCopy wc, String commandName, Text text, String newVal, String attributeKey, ModifyListener listener) {
        this(wc, commandName, text, newVal, attributeKey, listener, "");
    }

    public ServerWorkingCopyPropertyCommand(IServerWorkingCopy wc, String commandName, Text text, String newVal, String attributeKey, ModifyListener listener, String defaultVal) {
        super(wc, commandName);
        this.wc = wc;
        this.text = text;
        this.key = attributeKey;
        this.newVal = newVal;
        this.listener = listener;
        if (this.key != null) {
            this.oldVal = wc.getAttribute(attributeKey, defaultVal);
        }
    }

    public void execute() {
        this.wc.setAttribute(this.key, this.newVal);
        this.postOp(POST_EXECUTE);
    }

    public void undo() {
        if (this.listener != null) {
            this.text.removeModifyListener(this.listener);
        }
        this.wc.setAttribute(this.key, this.oldVal);
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setText(this.oldVal);
        }
        if (this.listener != null) {
            this.text.addModifyListener(this.listener);
        }
        this.postOp(POST_UNDO);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable adapt) {
        if (this.listener != null) {
            this.text.removeModifyListener(this.listener);
        }
        this.wc.setAttribute(this.key, this.newVal);
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setText(this.newVal);
        }
        if (this.listener != null) {
            this.text.addModifyListener(this.listener);
        }
        this.postOp(POST_REDO);
        return Status.OK_STATUS;
    }

    protected void postOp(int type) {
    }
}

