/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.contentassist;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import tern.ITernFile;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.eclipse.ide.ui.contentassist.Arg;
import tern.eclipse.ide.ui.contentassist.Arguments;
import tern.eclipse.ide.ui.utils.HTMLTernPrinter;
import tern.eclipse.jface.contentassist.TernCompletionProposal;
import tern.server.ITernPlugin;
import tern.server.TernPlugin;
import tern.server.protocol.completions.FunctionInfo;
import tern.server.protocol.completions.Parameter;
import tern.server.protocol.completions.TernCompletionItem;
import tern.server.protocol.completions.TernCompletionProposalRec;
import tern.server.protocol.completions.TernTypeHelper;
import tern.server.protocol.guesstypes.ITernGuessTypesCollector;
import tern.server.protocol.guesstypes.TernGuessTypesQuery;
import tern.utils.StringUtils;

public class JSTernCompletionProposal
extends TernCompletionProposal {
    public static final String TAB = "\t";
    public static final String SPACE = " ";
    private static final String RPAREN = ")";
    private static final String LPAREN = "(";
    private static final String COMMA = ",";
    private IRegion fSelectedRegion;
    private IPositionUpdater fUpdater;
    private Arguments arguments;
    private ITextViewer fTextViewer;
    private boolean fToggleEating;
    private boolean generateObjectValue;
    private boolean generateAnonymousFunction;
    private String indentChars = "\t";
    private ITernFile ternFile;
    private IIDETernProject ternProject;

    public JSTernCompletionProposal(TernCompletionProposalRec proposal) {
        super(proposal);
    }

    protected Image getDefaultImage() {
        return TernUIPlugin.getTernDescriptorManager().getImage((TernCompletionItem)this);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        if (this.fTextViewer == null) {
            this.fTextViewer = viewer;
        }
        Point selection = viewer.getSelectedRange();
        this.fToggleEating = (stateMask & SWT.MOD1) != 0;
        int newLength = selection.x + selection.y - this.getReplacementOffset();
        if (this.insertCompletion() ^ this.fToggleEating && newLength >= 0) {
            this.setReplacementLength(newLength);
        }
        this.apply(document, trigger, offset);
        this.fToggleEating = false;
    }

    public void apply(IDocument document, char trigger, int offset) {
        String replacement = this.computeReplacementString(document, offset);
        this.setReplacementString(replacement);
        this.updateReplacementLengthForString(document, offset, replacement);
        super.apply(document, trigger, offset);
        int baseOffset = this.getReplacementOffset();
        if (this.arguments != null && this.getTextViewer() != null) {
            try {
                this.arguments.setBaseOffset(baseOffset);
                this.guessParameters(offset);
                Arg arg = null;
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                while (i != this.arguments.size()) {
                    arg = (Arg)((Object)this.arguments.get(i));
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    if (arg.getProposals() == null) {
                        group.addPosition(new LinkedPosition(document, arg.getOffset(), arg.getLength(), -1));
                    } else {
                        this.ensurePositionCategoryInstalled(document, model);
                        document.addPosition(this.getCategory(), (Position)arg);
                        group.addPosition((LinkedPosition)new ProposalPosition(document, arg.getOffset(), arg.getLength(), -1, arg.getProposals()));
                    }
                    model.addGroup(group);
                    ++i;
                }
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setExitPosition(this.getTextViewer(), baseOffset + replacement.length(), 0, Integer.MAX_VALUE);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(')', document));
                ui.setDoContextInfo(true);
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            }
            catch (BadLocationException badLocationException) {
                this.ensurePositionCategoryRemoved(document);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                this.ensurePositionCategoryRemoved(document);
            }
        } else {
            int newOffset = baseOffset + replacement.length();
            if (this.isObjectKey() && TernTypeHelper.isStringType((String)this.getType())) {
                --newOffset;
            }
            this.fSelectedRegion = new Region(newOffset, 0);
        }
    }

    protected void guessParameters(int offset) {
        if (this.ternProject != null && this.ternProject.hasPlugin((ITernPlugin)TernPlugin.guess_types)) {
            String property = super.getName();
            TernGuessTypesQuery query = new TernGuessTypesQuery(this.ternFile.getFileName(), Integer.valueOf(offset), property);
            try {
                this.ternProject.request(query, this.ternFile, (ITernGuessTypesCollector)this.arguments);
            }
            catch (Exception e) {
                Trace.trace((byte)3, "Error while guessing type", e);
            }
        }
    }

    protected void updateReplacementLengthForString(IDocument document, int offset, String replacement) {
        boolean isString;
        boolean bl = isString = replacement.startsWith("\"") || replacement.startsWith("'");
        if (isString) {
            int length = document.getLength();
            int pos = offset;
            while (pos < length) {
                try {
                    char c = document.getChar(pos);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            return;
                        }
                        case '\"': 
                        case '\'': {
                            this.setReplacementLength(this.getReplacementLength() + pos - offset + 1);
                            return;
                        }
                    }
                    ++pos;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public ITextViewer getTextViewer() {
        return this.fTextViewer;
    }

    public final String getReplacementString() {
        return super.getReplacementString();
    }

    private String computeReplacementString(IDocument document, int offset) {
        if (this.isObjectKey()) {
            StringBuilder replacement = new StringBuilder(super.getName());
            replacement.append(": ");
            if (TernTypeHelper.isStringType((String)this.getType())) {
                replacement.append("\"\"");
            } else if (TernTypeHelper.isBoolType((String)this.getType())) {
                replacement.append("false");
            }
            return replacement.toString();
        }
        List parameters = super.getParameters();
        if (parameters == null) {
            return super.getReplacementString();
        }
        String indentation = this.getIndentation(document, offset);
        this.arguments = new Arguments();
        StringBuilder replacement = new StringBuilder(super.getName());
        replacement.append(LPAREN);
        this.setCursorPosition(replacement.length());
        this.computeReplacementString(parameters, replacement, this.arguments, indentation, 1, true);
        replacement.append(RPAREN);
        return replacement.toString();
    }

    private void computeReplacementString(List<Parameter> parameters, StringBuilder replacement, Arguments arguments, String indentation, int nbIndentations, boolean initialFunction) {
        int count = parameters.size();
        Parameter parameter = null;
        String paramName = null;
        int i = 0;
        while (i != count) {
            parameter = parameters.get(i);
            if (i != 0) {
                replacement.append(COMMA);
                replacement.append(SPACE);
            }
            if (parameter.isFunction() && this.isGenerateAnonymousFunction() && initialFunction) {
                FunctionInfo info = parameter.getInfo();
                List parametersOfParam = info.getParameters();
                replacement.append("function(");
                if (parametersOfParam != null) {
                    this.computeReplacementString(parametersOfParam, replacement, arguments, indentation, nbIndentations + 1, false);
                } else {
                    arguments.addArg(replacement.length(), 0);
                }
                replacement.append(") {");
                replacement.append("\n");
                this.indent(replacement, indentation, nbIndentations);
                this.indent(replacement);
                if (!StringUtils.isEmpty((String)info.getReturnType())) {
                    if (TernTypeHelper.isStringType((String)info.getReturnType())) {
                        replacement.append("return \"\";");
                    } else if (TernTypeHelper.isBoolType((String)info.getReturnType())) {
                        replacement.append("return true;");
                    } else if ("{}".equals(info.getReturnType())) {
                        replacement.append("return {");
                        replacement.append("\n");
                        this.indent(replacement, indentation, nbIndentations);
                        this.indent(replacement);
                        this.indent(replacement);
                        arguments.addArg(replacement.length(), 0);
                        replacement.append("\n");
                        this.indent(replacement, indentation, nbIndentations);
                        this.indent(replacement);
                        replacement.append("}");
                    }
                } else {
                    arguments.addArg(replacement.length(), 0);
                }
                replacement.append("\n");
                this.indent(replacement, indentation, nbIndentations);
                replacement.append("}");
            } else if ("{}".equals(parameter.getType()) && this.isGenerateObjectValue()) {
                replacement.append("{");
                replacement.append("\n");
                this.indent(replacement, indentation, nbIndentations);
                replacement.append("}");
            } else {
                int offset = replacement.length();
                paramName = parameter.getName();
                replacement.append(paramName);
                if (initialFunction) {
                    arguments.addParameter(offset, paramName.length(), paramName, i);
                } else {
                    arguments.addArg(offset, paramName.length());
                }
            }
            ++i;
        }
    }

    protected void indent(StringBuilder replacement) {
        replacement.append(this.indentChars);
    }

    public String getAdditionalProposalInfo() {
        return HTMLTernPrinter.getAdditionalProposalInfo((TernCompletionItem)this, null);
    }

    protected Shell getActiveWorkbenchShell() {
        return TernUIPlugin.getActiveWorkbenchShell();
    }

    public boolean isGenerateObjectValue() {
        return this.generateObjectValue;
    }

    public void setGenerateObjectValue(boolean generateObjectValue) {
        this.generateObjectValue = generateObjectValue;
    }

    public boolean isGenerateAnonymousFunction() {
        return this.generateAnonymousFunction;
    }

    public void setGenerateAnonymousFunction(boolean generateAnonymousFunction) {
        this.generateAnonymousFunction = generateAnonymousFunction;
    }

    private boolean insertCompletion() {
        return true;
    }

    private void indent(StringBuilder replacement, String indentation, int nbIndentations) {
        int j = 0;
        while (j < nbIndentations) {
            replacement.append(indentation);
            ++j;
        }
    }

    private String getIndentation(IDocument document, int offset) {
        try {
            IRegion lineRegion = document.getLineInformationOfOffset(offset);
            String lineText = document.get(lineRegion.getOffset(), lineRegion.getLength());
            StringBuilder indentation = new StringBuilder();
            char[] chars = lineText.toCharArray();
            int i = 0;
            while (i < chars.length) {
                char c = chars[i];
                if (c != ' ' && c != '\t') break;
                indentation.append(c);
                ++i;
            }
            return indentation.toString();
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public void setIndentChars(String indentChars) {
        this.indentChars = indentChars;
    }

    public String getIndentChars() {
        return this.indentChars;
    }

    public void setTernFile(ITernFile ternFile) {
        this.ternFile = ternFile;
    }

    public ITernFile getTernFile() {
        return this.ternFile;
    }

    public void setTernProject(IIDETernProject ternProject) {
        this.ternProject = ternProject;
    }

    public IIDETernProject getTernProject() {
        return this.ternProject;
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.fUpdater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater(this.fUpdater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    JSTernCompletionProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            document.removePositionUpdater(this.fUpdater);
        }
    }

    private String getCategory() {
        return "JSTernCompletionProposal_" + ((Object)((Object)this)).toString();
    }

    protected static final class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        private final IDocument fDocument;

        public ExitPolicy(char exitCharacter, IDocument document) {
            this.fExitCharacter = exitCharacter;
            this.fDocument = document;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel environment, VerifyEvent event, int offset, int length) {
            if (event.character == this.fExitCharacter) {
                if (environment.anyPositionContains(offset)) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
                return new LinkedModeUI.ExitFlags(2, true);
            }
            switch (event.character) {
                case ';': {
                    return new LinkedModeUI.ExitFlags(0, true);
                }
                case '\r': {
                    if (offset > 0) {
                        try {
                            if (this.fDocument.getChar(offset - 1) == '{') {
                                return new LinkedModeUI.ExitFlags(1, true);
                            }
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

