/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.properties;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Table;

public abstract class AbstractTableBlock {
    private int fSortColumn;

    protected abstract Table getTable();

    protected abstract IDialogSettings getDialogSettings();

    protected abstract String getQualifier();

    protected void setSortColumn(int column) {
        this.fSortColumn = column;
    }

    public void saveColumnSettings() {
        int columnCount = this.getTable().getColumnCount();
        int i = 0;
        while (i < columnCount) {
            this.getDialogSettings().put(String.valueOf(this.getQualifier()) + ".columnWidth" + i, this.getTable().getColumn(i).getWidth());
            ++i;
        }
        this.getDialogSettings().put(String.valueOf(this.getQualifier()) + ".sortColumn", this.fSortColumn);
    }

    public void restoreColumnSettings() {
        this.getTable().layout(true);
        this.restoreColumnWidths(this.getDialogSettings(), this.getQualifier());
        int col = 0;
        try {
            col = this.getDialogSettings().getInt(String.valueOf(this.getQualifier()) + ".sortColumn");
        }
        catch (NumberFormatException numberFormatException) {
            col = 1;
        }
        this.setSortColumn(col);
    }

    private void restoreColumnWidths(IDialogSettings settings, String qualifier) {
        int columnCount = this.getTable().getColumnCount();
        int i = 0;
        while (i < columnCount) {
            int width = -1;
            try {
                width = settings.getInt(String.valueOf(qualifier) + ".columnWidth" + i);
            }
            catch (NumberFormatException numberFormatException) {}
            if (width > 0) {
                this.getTable().getColumn(i).setWidth(width);
            }
            ++i;
        }
    }

    public void dispose() {
        if (this.getTable() != null && !this.getTable().isDisposed()) {
            this.saveColumnSettings();
        }
    }
}

