/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.controls;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import tern.eclipse.ide.internal.ui.controls.AbstractTernModulePanel;
import tern.eclipse.ide.internal.ui.descriptors.TernModuleDescriptorManager;
import tern.eclipse.ide.ui.descriptors.options.ITernModuleOptionFactory;
import tern.metadata.TernModuleMetadata;
import tern.metadata.TernModuleMetadataOption;
import tern.server.ITernModule;
import tern.server.ITernModuleConfigurable;
import tern.server.ModuleType;
import tern.server.protocol.JsonHelper;
import tern.utils.StringUtils;

public class TernModuleOptionsPanel
extends AbstractTernModulePanel {
    public TernModuleOptionsPanel(Composite parent, ITernModule module, IProject project) {
        super(parent, module, project);
    }

    @Override
    protected void createUI(Composite parent, ITernModule module, IProject project) {
        GridLayout layout = new GridLayout(2, false);
        super.setLayout((Layout)layout);
        TernModuleMetadata metadata = module.getMetadata();
        if (metadata != null && module.getModuleType() == ModuleType.Configurable) {
            JsonObject jsonOptions = this.getOptions((ITernModuleConfigurable)module);
            Collection options = metadata.getOptions();
            for (TernModuleMetadataOption option : options) {
                this.createUI(parent, jsonOptions, project, option);
            }
        }
    }

    protected void createUI(Composite parent, JsonObject options, IProject project, TernModuleMetadataOption metadata) {
        String name = metadata.getName();
        String description = metadata.getDescription();
        String type = metadata.getType();
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(2));
        label.setText(name + ":");
        label.setToolTipText(description);
        ITernModuleOptionFactory factory = TernModuleDescriptorManager.getManager().getTernModuleOptionFactory(type);
        if (factory != null) {
            factory.createOption(parent, project, metadata, options);
        } else {
            this.createJsonOption(parent, name, options);
        }
    }

    protected void createJsonOption(Composite parent, final String name, final JsonObject options) {
        final Text textField = new Text(parent, 2626);
        GridData data = new GridData(768);
        data.heightHint = 100;
        textField.setLayoutData((Object)data);
        String initialValue = JsonHelper.getString((JsonValue)options.get(name));
        textField.setText(initialValue != null ? initialValue : "");
        textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value = textField.getText();
                if (StringUtils.isEmpty((String)value)) {
                    options.remove(name);
                } else {
                    try {
                        options.set(name, (JsonValue)JsonObject.readFrom((String)value));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        });
    }

    protected JsonObject getOptions(ITernModuleConfigurable module) {
        JsonObject options = module.getOptions();
        if (options == null) {
            options = new JsonObject();
            module.setOptions(options);
        }
        return options;
    }
}

