/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.modules;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModelException;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.util.ModelUtil;
import org.jboss.ide.eclipse.archives.webtools.IntegrationPlugin;
import org.jboss.ide.eclipse.archives.webtools.modules.PackageModuleFactory;

public class ArchivesModelModuleContributor {
    private PackageModuleFactory factory;
    protected ArrayList<IModule> modules = null;
    protected HashMap<IPath, ArrayList<IModule>> projectToModules = new HashMap(5);
    protected HashMap<IModule, Object> moduleDelegates = new HashMap(5);
    protected HashMap<IArchive, IModule> packageToModule = new HashMap(5);

    ArchivesModelModuleContributor(PackageModuleFactory factory) {
        this.factory = factory;
    }

    public IModule[] getModules() {
        if (this.modules == null) {
            this.modules = new ArrayList();
            IProject[] projects2 = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int size = projects2.length;
            int i = 0;
            while (i < size) {
                if (projects2[i].isAccessible()) {
                    if (!ArchivesModel.instance().isProjectRegistered(projects2[i].getLocation())) {
                        if (ArchivesModel.instance().canReregister(projects2[i].getLocation())) {
                            ArchivesModel.instance().registerProject(projects2[i].getLocation(), (IProgressMonitor)new NullProgressMonitor());
                        }
                    } else {
                        try {
                            this.createModules(projects2[i]);
                        }
                        catch (ArchivesModelException ame) {
                            Status status = new Status(4, "org.jboss.ide.eclipse.archives.webtools", ame.getMessage(), (Throwable)ame);
                            IntegrationPlugin.getDefault().getLog().log((IStatus)status);
                        }
                    }
                }
                ++i;
            }
        }
        return this.modules.toArray(new IModule[this.modules.size()]);
    }

    protected void createModules(IProject project) throws ArchivesModelException {
        if (project == null) {
            return;
        }
        IArchive[] packages = ModelUtil.getProjectArchives((IPath)project.getLocation());
        if (packages != null && packages.length > 0) {
            boolean requiresSave = this.ensureArchivesHaveIDs(project, packages);
            ArrayList<IModule> mods = new ArrayList<IModule>();
            int i = 0;
            while (i < packages.length) {
                IModule module = this.factory.createModule2(packages[i], project);
                this.modules.add(module);
                PackageModuleFactory.PackagedModuleDelegate moduleDelegate = new PackageModuleFactory.PackagedModuleDelegate(packages[i]);
                this.packageToModule.put(packages[i], module);
                this.moduleDelegates.put(module, (Object)moduleDelegate);
                mods.add(module);
                ++i;
            }
            this.projectToModules.put(project.getLocation(), mods);
            if (requiresSave) {
                try {
                    ArchivesModel.instance().getRoot(project.getLocation()).save((IProgressMonitor)new NullProgressMonitor());
                }
                catch (ArchivesModelException archivesModelException) {}
            }
        }
    }

    public boolean containsModule(IModule module) {
        return this.moduleDelegates.containsKey(module);
    }

    public PackageModuleFactory.PackagedModuleDelegate getModuleDelegate(IModule module) {
        return (PackageModuleFactory.PackagedModuleDelegate)((Object)this.moduleDelegates.get(module));
    }

    public void refreshProject(IPath projectLoc) {
        ArrayList<IModule> mods;
        if (this.modules == null) {
            this.getModules();
        }
        if ((mods = this.projectToModules.get(projectLoc)) != null) {
            for (IModule mod : mods) {
                if (!this.modules.contains(mod)) continue;
                PackageModuleFactory.PackagedModuleDelegate delegate = (PackageModuleFactory.PackagedModuleDelegate)((Object)this.moduleDelegates.get(mod));
                this.moduleDelegates.remove(mod);
                this.modules.remove(mod);
                if (delegate == null) continue;
                this.packageToModule.remove(delegate.getPackage());
            }
        }
        try {
            this.createModules(this.findProject(projectLoc));
        }
        catch (ArchivesModelException ame) {
            Status status = new Status(4, "org.jboss.ide.eclipse.archives.webtools", ame.getMessage(), (Throwable)ame);
            IntegrationPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    protected IProject findProject(IPath projectLoc) {
        IProject proj = null;
        IProject[] projects2 = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int size = projects2.length;
        int i = 0;
        while (i < size) {
            if (projects2[i].getLocation().equals((Object)projectLoc)) {
                proj = projects2[i];
            }
            ++i;
        }
        return proj;
    }

    protected boolean ensureArchivesHaveIDs(IProject project, IArchive[] archives) {
        boolean requiresSave = false;
        int i = 0;
        while (i < archives.length) {
            if (PackageModuleFactory.getStamp(archives[i]) == null) {
                requiresSave = true;
                archives[i].setProperty("org.jboss.ide.eclipse.as.core.packages.ModuleIDPropertyKey", PackageModuleFactory.getStamp(archives[i], true));
            }
            ++i;
        }
        return requiresSave;
    }
}

