/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.xml.ui.xpl;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.jboss.tools.common.text.xml.XmlEditorPlugin;

public class BasePreferenceConstants {
    public static final String EDITOR_BOLD_SUFFIX = "_bold";
    public static final String EDITOR_FOREGROUND_SUFFIX = "_foreground";
    public static final String EDITOR_BACKGROUND_SUFFIX = "_background";
    public static final String EDITOR_CUSTOM_BACKGROUND_SUFFIX = "_custom_background";
    public static final String EDITOR_BACKGROUND_COLOR = "AbstractTextEditor.Color.Background";
    public static final String EDITOR_BACKGROUND_DEFAULT_COLOR = "AbstractTextEditor.Color.Background.SystemDefault";
    public static final String EDITOR_TAB_WIDTH = "org.jboss.tools.common.text.xml.ui.tab.width";
    public static final String EDITOR_REPLACE_TAB_WITH_WHITESPACE = "org.jboss.tools.common.text.xml.ui.tab.replace";

    public static IPreferenceStore getPreferenceStore() {
        return XmlEditorPlugin.getDefault().getPreferenceStore();
    }

    public static final String getItemForegroundKey(String item) {
        return String.valueOf(item) + EDITOR_FOREGROUND_SUFFIX;
    }

    public static final String getItemBackgroundKey(String item) {
        return String.valueOf(item) + EDITOR_BACKGROUND_SUFFIX;
    }

    public static final String getItemUseCustomBackgroundKey(String item) {
        return String.valueOf(item) + EDITOR_CUSTOM_BACKGROUND_SUFFIX;
    }

    public static final String getItemBoldKey(String item) {
        return String.valueOf(item) + EDITOR_BOLD_SUFFIX;
    }

    public static final void setDefault(IPreferenceStore store, String item, RGB foreground, RGB background, boolean useCustomBackground, boolean bold) {
        if (store == null || item == null || item.length() == 0) {
            return;
        }
        if (foreground != null) {
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)BasePreferenceConstants.getItemForegroundKey(item), (RGB)foreground);
        }
        if (background != null) {
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)BasePreferenceConstants.getItemBackgroundKey(item), (RGB)background);
        }
        store.setDefault(BasePreferenceConstants.getItemUseCustomBackgroundKey(item), useCustomBackground);
        store.setDefault(BasePreferenceConstants.getItemBoldKey(item), bold);
    }
}

