/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.server.extensions;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.browser.ImageResource;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.jboss.ide.eclipse.as.core.server.internal.JBossLaunchAdapter;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.actions.ServerActionMessages;
import org.jboss.ide.eclipse.as.ui.launch.JBTWebLaunchableClient;
import org.jboss.ide.eclipse.as.ui.views.server.extensions.CommonActionProviderUtils;

public class ShowInWelcomePageActionProvider
extends CommonActionProvider {
    private Action action;
    private ICommonActionExtensionSite actionSite;

    public void init(ICommonActionExtensionSite aSite) {
        StructuredViewer v;
        super.init(aSite);
        this.actionSite = aSite;
        ICommonViewerSite site = aSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite && (v = aSite.getStructuredViewer()) instanceof CommonViewer) {
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            this.createActions((CommonViewer)v, wsSite.getSelectionProvider());
        }
    }

    public void createActions(CommonViewer tableViewer, ISelectionProvider provider) {
        this.action = new Action(){

            public void run() {
                new Job("Fetching Welcome Page URL"){

                    public IStatus run(IProgressMonitor monitor) {
                        String url2 = null;
                        try {
                            url2 = ShowInWelcomePageActionProvider.this.getUrl();
                        }
                        catch (CoreException ce) {
                            return ce.getStatus();
                        }
                        final String url = url2;
                        if (url != null) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    JBTWebLaunchableClient.checkedCreateInternalBrowser(url, ShowInWelcomePageActionProvider.this.getServer().getName(), "org.jboss.ide.eclipse.as.ui", JBossServerUIPlugin.getDefault().getLog());
                                }
                            });
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        };
        this.action.setText(ServerActionMessages.OpenWithBrowser);
        this.action.setDescription(ServerActionMessages.OpenWithBrowserDescription);
        this.action.setImageDescriptor(ImageResource.getImageDescriptor((String)"internalBrowser"));
    }

    private boolean hasURL() {
        IServer server = this.getServer();
        ServerExtendedProperties props = (ServerExtendedProperties)server.loadAdapter(ServerExtendedProperties.class, (IProgressMonitor)new NullProgressMonitor());
        if (props != null) {
            return props.hasWelcomePage();
        }
        return false;
    }

    private static JBossLaunchAdapter.JBTCustomHttpLaunchable getCustomLaunchable(IServer server, final IModule[] module) throws CoreException {
        IModuleArtifact[] moduleArtifacts;
        IProject p;
        IModule mod = module == null || module.length == 0 ? null : module[module.length - 1];
        IModuleArtifact artifact = null;
        if (mod != null && (p = mod.getProject()) != null && (moduleArtifacts = ServerPlugin.getModuleArtifacts((Object)p)) != null && moduleArtifacts.length > 0) {
            artifact = moduleArtifacts[0];
        }
        if (artifact == null) {
            artifact = new IModuleArtifact(){

                public IModule getModule() {
                    return module == null || module.length == 0 ? null : module[module.length - 1];
                }
            };
        }
        return ShowInWelcomePageActionProvider.getLaunchable(server, artifact);
    }

    private static JBossLaunchAdapter.JBTCustomHttpLaunchable getLaunchable(IServer server, IModuleArtifact moduleArtifact) throws CoreException {
        ILaunchableAdapter[] adapters = ServerPlugin.getLaunchableAdapters();
        IStatus lastStatus = null;
        if (adapters != null) {
            int size2 = adapters.length;
            int j = 0;
            while (j < size2) {
                try {
                    Object launchable2 = adapters[j].getLaunchable(server, moduleArtifact);
                    if (launchable2 != null && launchable2 instanceof JBossLaunchAdapter.JBTCustomHttpLaunchable) {
                        return (JBossLaunchAdapter.JBTCustomHttpLaunchable)launchable2;
                    }
                }
                catch (CoreException ce) {
                    lastStatus = ce.getStatus();
                }
                catch (Exception exception) {}
                ++j;
            }
            if (lastStatus != null) {
                throw new CoreException(lastStatus);
            }
        }
        return null;
    }

    private String getUrl() throws CoreException {
        String urlString = null;
        IServer server = this.getServer();
        if (server != null && server.getServerState() == 2) {
            ModuleServer ms = this.getModuleServer();
            if (ms != null) {
                URL url;
                IServer s;
                Object o;
                JBossLaunchAdapter.JBTCustomHttpLaunchable launchable = ShowInWelcomePageActionProvider.getCustomLaunchable(server, ms.getModule());
                if (launchable != null) {
                    return launchable.getURL().toString();
                }
                IModule[] mss = ms.getModule();
                IModule m = this.getWebModule(mss);
                if (m != null && (o = (s = this.getServer()).loadAdapter(IURLProvider.class, null)) instanceof IURLProvider && (url = ((IURLProvider)o).getModuleRootURL(m)) != null) {
                    urlString = url.toString();
                }
            } else {
                ServerExtendedProperties props = (ServerExtendedProperties)server.loadAdapter(ServerExtendedProperties.class, (IProgressMonitor)new NullProgressMonitor());
                if (props != null) {
                    urlString = props.getWelcomePageUrl();
                }
            }
        }
        return urlString;
    }

    private IModule getWebModule(IModule[] m) {
        if (m.length > 0) {
            IModule[] mms;
            IModule module = m[m.length - 1];
            if (this.isWebModule(module)) {
                return module;
            }
            IServer s = this.getServer();
            IModule[] iModuleArray = mms = s.getChildModules(m, null);
            int n = mms.length;
            int n2 = 0;
            while (n2 < n) {
                IModule child = iModuleArray[n2];
                if (this.isWebModule(child)) {
                    return child;
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean isWebModule(IModule module) {
        IModuleType type = module.getModuleType();
        return "jst.web".equals(type.getId());
    }

    public void fillContextMenu(IMenuManager menu) {
        IContributionItem menuItem;
        if ((this.getModuleServer() != null || this.getServer() != null) && (menuItem = CommonActionProviderUtils.getShowInQuickMenu(menu, true)) instanceof MenuManager) {
            ((MenuManager)menuItem).add((IAction)this.action);
            this.action.setEnabled(this.hasURL() && this.getServer().getServerState() == 2);
        }
    }

    public IServer getServer() {
        Object o = this.getSelection();
        if (o instanceof IServer) {
            return (IServer)o;
        }
        if (o instanceof ModuleServer) {
            return ((ModuleServer)o).server;
        }
        return null;
    }

    public ModuleServer getModuleServer() {
        Object o = this.getSelection();
        if (o instanceof ModuleServer) {
            return (ModuleServer)o;
        }
        return null;
    }

    protected Object getSelection() {
        ICommonViewerWorkbenchSite wsSite;
        ICommonViewerSite site = this.actionSite.getViewSite();
        IStructuredSelection selection = null;
        if (site instanceof ICommonViewerWorkbenchSite && (selection = (IStructuredSelection)(wsSite = (ICommonViewerWorkbenchSite)site).getSelectionProvider().getSelection()).size() == 1) {
            return selection.getFirstElement();
        }
        return null;
    }
}

